<?php
  /**
   **  Timeout User (timeout_user) v1.1
   **
   **  By Ray Black III <allah@accessnode.net>
   **  Changes by Paul Lesneiwski <pdontthink@angrynerds.com>
   **  (c) 2001 (GNU GPL - see ../../COPYING)
   **
   **  This plugin monitors page changes in the right-hand frame.
   **  If the right-hand frame doesn't update within a set number
   **  of minutes, then the plugin logs the user out automatically.
   **  
   **  To change the timeout, see the file config.php. 
   **/


function squirrelmail_plugin_init_timeout_user()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['menuline']['timeout_user']
            = 'timeout_user_metatag';
    $squirrelmail_plugin_hooks['logout_above_text']['timeout_user']
            = 'timeout_user_explanation';
    $squirrelmail_plugin_hooks['options_display_inside']['timeout_user']
            = 'timeout_user_show_options';
    $squirrelmail_plugin_hooks['options_display_save']['timeout_user']
            = 'timeout_user_save_options';

} // end squirrelmail_plugin_init_timeout_user()


function timeout_user_show_options()
{

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/timeout_user/functions.php');
    else
       include_once('../plugins/timeout_user/functions.php');

    timeout_user_show_options_do();

}


function timeout_user_save_options()
{

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/timeout_user/functions.php');
    else
       include_once('../plugins/timeout_user/functions.php');

    timeout_user_save_options_do();

}


function timeout_user_metatag()
{

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/timeout_user/functions.php');
    else
       include_once('../plugins/timeout_user/functions.php');

    timeout_user_metatag_do();

} // end timeout_user_metatag()



// this function only applies in 1.1.2 and beyond
function timeout_user_explanation()
{  
     
    if (defined('SM_PATH'))
    {
        include_once(SM_PATH . 'plugins/timeout_user/functions.php');
        return timeout_user_explanation_do();
    }
    else
    {
        include_once('../plugins/timeout_user/functions.php');
        timeout_user_explanation_do();
    }
        
} // end timeout_user_explanation()


?>
