<?php


/**
  * SquirrelMail Templates Plugin
  * Copyright (c) 2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Copyright (c) 2003-2005 Ryan Rubley <ryan@morpheussoftware.net>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage templates
  *
  */

function LoadTemplate(&$d, &$t, $post) {
    global $username, $data_dir;

    $d = getPref($data_dir, $username, 'description' . $post);
    $t = getTemplate($data_dir,$username,$post);

    if ($d != '' || $t != '')
        return true;
}

function setTemplate($data_dir, $username, $number, $value) {

      bindtextdomain('templates', SM_PATH . 'locale');
      textdomain('templates');

    $filename = getHashedFile($username, $data_dir, "$username.template.$number");
    /* Open the file for writing, or else display an error to the user. */
    if(!$file = @fopen("$filename.tmp", 'w')) {
        logout_error( sprintf( _("Template file, %s, could not be opened. Contact your system administrator to resolve this issue."), $filename . '.tmp') );
        exit;
    }
    if ( @fwrite($file, $value) === FALSE ) {
       logout_error( sprintf( _("Template file, %s, could not be written. Contact your system administrator to resolve this issue.") , $filename . '.tmp'));
       exit;
    }
    fclose($file);
    if (! @copy($filename . '.tmp',$filename) ) {
       logout_error( sprintf( _("Template file, %s, could not be copied from temporary file, %s. Contact your system administrator to resolve this issue."), $filename, $filename . '.tmp') );
       exit;
    }
    @unlink($filename . '.tmp');
    chmod($filename, 0600);

      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

}

function getTemplate($data_dir, $username, $number) {

      bindtextdomain('templates', SM_PATH . 'locale');
      textdomain('templates');

    $filename = getHashedFile($username, $data_dir, "$username.template.$number");
    $template = '';
    if (file_exists($filename)) {
        /* Open the file, or else display an error to the user. */
        if(!$file = @fopen($filename, 'r'))
        {
            logout_error( sprintf( _("Template file, %s, could not be opened. Contact your system administrator to resolve this issue."), $filename) );
            exit;
        }
        while (!feof($file)) {
            $template .= fgets($file, 1024);
        }
        fclose($file);
    }

      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

    return $template;
}
?>
