<?php

/* Templates Plugin
 * by Ryan Rubley (ryan@morpheussoftware.net)
 * (c) 2003 (GNU GPL - see ../../COPYING)
 *
 * This was greatly hacked from src/options_identities.php
 */

include_once('common.php');

/* Path for SquirrelMail required files. */
define('SM_PATH','../../');

/* SquirrelMail required files. */
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/global.php');
include_once(SM_PATH . 'functions/display_messages.php');
include_once(SM_PATH . 'functions/html.php');

/* POST data var names are dynamic because 
   of the possible multiple idents so lets get
   them all
*/
if (!empty($_POST)) {
    extract($_POST);
}
/* got 'em all */

    displayPageHeader($color, 'None');
 
    if (CheckAndDoPromote()) {
       SaveUpdateFunction();
    }
    if (isset($update) || CheckForDelete()) {
        SaveUpdateFunction();
    }
 
   $td_str = '';
   $td_str .= '<form name="f" action="options.php" method="post"><br>';

   global $username, $data_dir;
   $template_prepend = getPref($data_dir, $username, 'template_prepend');
   $template_preblank = getPref($data_dir, $username, 'template_preblank');
   $template_postblank = getPref($data_dir, $username, 'template_postblank');
   $td_str .= '<tr><td align="center" valign="middle" colspan="2" nowrap><b>Template Options</b></td></tr>' .
   html_tag( 'tr', "\n" .
      html_tag( 'td', "\n" .
         _("Append Templates before all existing text") . ':' ,
      'right', '', 'valign="middle"' ) .
      html_tag( 'td', '<input type="radio" name="template_prepend" value="1"' .
         ($template_prepend?' checked':'').'>&nbsp;' . _("Yes") .
         '&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="template_prepend" value="0"' . 
         ($template_prepend?'':' checked').'>&nbsp;' . _("No"),
      'left' )
   ) .
   html_tag( 'tr', "\n" .
      html_tag( 'td', "\n" .
         _("Add blank line before template text when appending") . ':' ,
      'right', '', 'valign="middle"' ) .
      html_tag( 'td', '<input type="radio" name="template_preblank" value="1"' .
         ($template_preblank?' checked':'').'>&nbsp;' . _("Yes") .
         '&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="template_preblank" value="0"' . 
         ($template_preblank?'':' checked').'>&nbsp;' . _("No"),
      'left' )
   ) .
   html_tag( 'tr', "\n" .
      html_tag( 'td', "\n" .
         _("Add blank line after template text when appending") . ':' ,
      'right', '', 'valign="middle"' ) .
      html_tag( 'td', '<input type="radio" name="template_postblank" value="1"' .
         ($template_postblank?' checked':'').'>&nbsp;' . _("Yes") .
         '&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="template_postblank" value="0"' . 
         ($template_postblank?'':' checked').'>&nbsp;' . _("No"),
      'left' )
   ) .
   '<tr><td colspan="2">&nbsp;</td></tr>';

   $num = 1;
   while (LoadTemplate($description, $templatetext, $num)) {
       $td_str .= html_tag( 'tr',
                          html_tag( 'th', sprintf (_("Template %d"), $num), 'center', '', 'colspan="2"' ) ,
                      '', $color[9]);
       $td_str .= ShowTableInfo($description, $templatetext, $num);
       $num ++;
       }

   echo '<br>' . 
   html_tag( 'table', "\n" .
       html_tag( 'tr', "\n" .
           html_tag( 'td', "\n" .
               '<b>'. _("Options") . ' - ' . _("Templates") .'</b><br>' .
               html_tag( 'table', "\n" .
                   html_tag( 'tr', "\n" .
                       html_tag( 'td', "\n" .
                           html_tag( 'table', "\n" .
                                   $td_str . "\n" .
                               html_tag( 'tr',
                                   html_tag( 'th', _("Add a New Template") . ShowTableInfo('', '', $num), 'center', '', 'colspan="2"' ) ,
                               '', $color[9]) ,
                            '', '', 'width="80%" cellpadding="2" cellspacing="0" border="0"' ) ,
                       'center', $color[4] )
                   ) ,
               '', '', 'width="100%" border="0" cellpadding="1" cellspacing="1"' ) ,
           'center', $color[0] )
       ) ,
   'center', '', 'width="95%" border="0" cellpadding="2" cellspacing="0"' ) .

   '</body></html>';

    function SaveUpdateFunction() {
        global $username, $data_dir, $template_prepend, $template_preblank, $template_postblank;

        setPref($data_dir, $username, 'template_prepend', $template_prepend);
        setPref($data_dir, $username, 'template_preblank', $template_preblank);
        setPref($data_dir, $username, 'template_postblank', $template_postblank);

        $i = 1;
        $fakeI = 1;
        $name = 'form_for_' . $i;
        global $$name;
        while (isset($$name))
        {
            $name = 'delete_' . $i;
            global $$name;
            if (isset($$name)) {
                $fakeI --;
            } else {
                $filled = 0;

                $name = 'description' . $i;
                global $$name;
            if ($$name != '')
                $filled ++;
                setPref($data_dir, $username, 'description' . $fakeI, $$name);

                $name = 'templatetext' . $i;
                global $$name;
            if ($$name != '')
                $filled ++;
                setTemplate($data_dir, $username, $fakeI, $$name);

            if ($filled == 0)
                $fakeI --;
            }

            $fakeI ++;
            $i ++;
            $name = 'form_for_' . $i;
            global $$name;
        }

        setPref($data_dir, $username, 'templates', $fakeI - 1);

        while ($fakeI != $i)
        {
            removePref($data_dir, $username, 'description' . $fakeI);
            setTemplate($data_dir, $username, $fakeI, "");
            $fakeI ++;
        }
    }

    function CheckForDelete() {
        global $username, $data_dir, $description, $templatetext;

        $i = 1;
        $name = 'form_for_' . $i;
        global $$name;
        while (isset($$name))
        {
            $name = 'delete_' . $i;
            global $$name;
            if (isset($$name)) {
                return true;
            }

            $i ++;
            $name = 'form_for_' . $i;
            global $$name;
        }
        return false;
    }

    function CheckAndDoPromote() {
        global $username, $data_dir, $description;

        $i = 1;
        $name = 'form_for_' . $i;
        global $$name;
        while (isset($$name)) {
            $name = 'promote_' . $i;
            global $$name;
            if (isset($$name) && $i > 1) {

                $nameA = 'description' . $i;
                $nameB = 'description' . ($i - 1);
                global $$nameA, $$nameB;
                $temp = $$nameA;
                $$nameA = $$nameB;
                $$nameB = $temp;
    
            $nameA = 'templatetext' . $i;
            $nameB = 'templatetext' . ($i - 1);
            global $$nameA, $$nameB;
            $temp = $$nameA;
            $$nameA = $$nameB;
            $$nameB = $temp;

                return true;
            }

            $i ++;
            $name = 'form_for_' . $i;
            global $$name;
        }
        return false;
    }

function sti_input( $title, $hd, $data, $post, $bg ) {
    $return_val = html_tag( 'tr',
                           html_tag( 'td', $title . ':', 'right', '', 'nowrap' ) .
                           html_tag( 'td', '<input size="50" type="text" value="' . htmlspecialchars($data) . '" name="' . $hd . $post . '">' , 'left' ) ,
                       '', $bg );
     return ($return_val);
}

function sti_textarea( $title, $hd, $data, $post, $bg ) {
    $return_val = html_tag( 'tr',
                           html_tag( 'td', $title . ':', 'right', '', 'nowrap' ) .
                           html_tag( 'td', '<textarea cols="50" rows="5" name="' . $hd . $post . '">' . htmlspecialchars($data) . '</textarea>' , 'left' ) ,
                       '', $bg );
     return ($return_val);
}

function ShowTableInfo($description, $templatetext, $post) {
    global $color;

    $OtherBG = $color[0];
    if ($description == '' && $templatetext == '')
        $OtherBG = '';

    if ($description == '' && $templatetext == '')
        $isEmptySection = true;
    else
        $isEmptySection = false;

    $return_val = '';
    $return_val .= sti_input( _("Description"), 'description', $description, $post, $OtherBG );
    $return_val .= sti_textarea( _("Template Text"), 'templatetext', $templatetext, $post, $OtherBG );

    $return_val .= html_tag( 'tr', '', '', $OtherBG);
    $return_val .= html_tag( 'td', '&nbsp;', 'left' );
    $return_val .= html_tag( 'td', '', 'left' );
    $return_val .= '<input type=hidden name="form_for_'. $post .'" value="1">';
    $return_val .= '<input type="submit" name="update" value="' . _("Save / Update") . '">';


    if (! $isEmptySection && $post != '') {
        $return_val .= '<input type=submit name="delete_' . $post . '" value="'.
             _("Delete") . '">';
    }
    if (! $isEmptySection && $post != '' && $post > 1) {
        $return_val .= '<input type=submit name="promote_' . $post . '" value="'.
             _("Move Up") . '">';
    }
    $return_val .=  '</td></tr>'.
         html_tag( 'tr', html_tag( 'td', '&nbsp;', 'left', '', 'colspan="2"' ));

    return ($return_val);
}

?>
