<?php


/**
  * SquirrelMail Taglines Plugin
  * Copyright (C) 2002-2004 Tracy McKibben, Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


   function taglines_options_do()
   {

      global $taglines_allow_overrides, $taglines_enable_default,
             $data_dir, $username;

      include_once(SM_PATH . 'plugins/taglines/config.php');


      // bail if admin is disallowing user settings
      //
      if (!$taglines_allow_overrides) return;


      $taglines_enable = getPref($data_dir, $username, 'taglines_enable', $taglines_enable_default);

      bindtextdomain('taglines', SM_PATH . 'plugins/taglines/locale');
      textdomain('taglines');

      global $optpage_data;
      $optpage_data['vals'][2][] = array(
         'name'          => 'taglines_enable',
         'caption'       => _("Append Random Phrase to Messages"),
         'type'          => SMOPT_TYPE_BOOLEAN,
         'initial_value' => $taglines_enable,
         'refresh'       => SMOPT_REFRESH_NONE,
      );

      bindtextdomain('squirrelmail', SM_PATH . 'locale');
      textdomain('squirrelmail');

   }



   function taglines_on_off_switch_do()
   {

      global $taglines_allow_overrides, $taglines_enable_default,
             $username, $data_dir, $taglines_show_switches_on_compose_page;

      include_once(SM_PATH . 'plugins/taglines/config.php');


      if (!$taglines_show_switches_on_compose_page) return;


      $taglines_enable = getPref($data_dir, $username, 'taglines_enable', $taglines_enable_default);
      if (!$taglines_allow_overrides) $taglines_enable = $taglines_enable_default;


      if (!$taglines_enable) return;


      echo '<br />';

      bindtextdomain('taglines', SM_PATH . 'plugins/taglines/locale');
      textdomain('taglines');

      echo _("Append Random Phrase");

      bindtextdomain('squirrelmail', SM_PATH . 'locale');
      textdomain('squirrelmail');


      echo ' <input type="radio" name="enable_tagline_override" CHECKED value="1" />' . _("Yes")
         . '<input type="radio" name="enable_tagline_override" value="0" />' . _("No");
   
   }



   function taglines_getquote_do(&$argv) 
   {

      global $fortuneCommand, $taglineSource, $taglinePrefix,
             $taglines_allow_overrides, $taglines_enable_default,
             $username, $data_dir;

      include_once(SM_PATH . 'plugins/taglines/config.php');


      $taglines_enable = getPref($data_dir, $username, 'taglines_enable', $taglines_enable_default);


      global $enable_tagline_override;
      sqgetGlobalVar('enable_tagline_override', $enable_tagline_override, SQ_POST);
      if (!$enable_tagline_override) $taglines_enable = 0;


      if (!$taglines_allow_overrides) $taglines_enable = $taglines_enable_default;


      if (!$taglines_enable) return;


      // autodetect taglines source - if fortune program
      // isn't available, only pull from qotd - if fortune program
      // isn't available, only pull from qotd.org
      //
      if ($taglineSource == 0)
      {
         preg_match('/(.+?)(\s|$)/', $fortuneCommand, $matches);
         if (!file_exists($matches[1]))
            $taglineSource = 1;
      }


      // random number generation...
      //
      mt_srand((double)microtime()*1000000);


      // figure out where to pull tag line from and do it...
      //
      if ($taglineSource == 1 || ($taglineSource == 0 && mt_rand(1,20) > 10))
      {
 
         // check age of cache 
         //
         $quotesrc = $data_dir . 'taglines_qotd.html';
         if (is_writable($quotesrc))
         {
            $filemod     = filemtime($quotesrc);
            $filemodtime = date('F j Y h:i:s A', $filemod);
            $currenttime = getdate(time());
            $currentdate = $currenttime['0'];
            $difference  = $currentdate - $filemod;

            if ($difference >= 3600) 
               unlink($quotesrc);
         }


         // get qotd from website if local copy not available
         //
         if (!file_exists($quotesrc)) 
            $qotd = 'http://www.qotd.org/sm';
         else
            $qotd = $quotesrc;


         // get qotd
         //
         $sk = @fopen($qotd, 'r');
         $retstr = '';
         if (isset($sk) && $sk !== FALSE)
         {
            while (!feof($sk))
            {
               $resp = fgets($sk,80);
               $retstr .= $resp;
            }
         }


         // parse quote out of web page
         //
         $sString = $retstr;
         $explode = explode('randomly selected quote:</b>',$sString);
         $sString = $explode[1];
         $explode = explode("<A HREF",$sString);
         $sString = $explode[0];
/*
   // this is how to parse it from the main web site (without the /sm on the end of the URL)
         $sString = $retstr;
         $explode = explode('quote:</b>',$sString);
         $sString = $explode[1];
         $explode = explode('<A',$sString);
         $sString = $explode[0];
*/
         $sString = str_replace('<br>','',$sString);
         $sString = str_replace('<BR>','',$sString);
         $sString = str_replace('<i>','',$sString);
         $sString = str_replace('</i>','',$sString);
         $sString = str_replace('<I>','',$sString);
         $sString = str_replace('</I>','',$sString);
         $sString = trim($sString);


         // if the cache file is nonexistent, save local
         // copy of web page
         //
         if (!file_exists($quotesrc))
         {
            if ($QOTDFILE = fopen($quotesrc, 'w'))
            {
               fwrite($QOTDFILE, $retstr);
               fclose($QOTDFILE);
            }
         }

      } 


      // get tag line from fortune program
      //
      else 
      {
         $sString = shell_exec($fortuneCommand);
         //$sString = nl2br($sString);
      }


      // put tag line into body text
      //
      $tagline = $taglinePrefix . $sString;
      $message = &$argv[1];
      if (is_array($message->entities) && sizeof($message->entities) > 0)
         $message->entities[0]->body_part = $message->entities[0]->body_part . $tagline;
      else
         $message->body_part = $message->body_part . $tagline;

   }


?>
