<?php

/**
  * SquirrelMail Squirrel Logger Plugin
  * Copyright (c) 2001-2005 Ron Chinn, Pat Winn, Paul Lesneiwski
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage squirrel_logger
  *
  */


/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../../');


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_squirrel_logger() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_verified']['squirrel_logger']  = 'sl_log_login';
   $squirrelmail_plugin_hooks['logout']['squirrel_logger']  = 'sl_log_logout';
   $squirrelmail_plugin_hooks['logout_error']['squirrel_logger']  = 'sl_log_login_error';
   $squirrelmail_plugin_hooks['error_box']['squirrel_logger']  = 'sl_log_error';
   $squirrelmail_plugin_hooks['compose_send']['squirrel_logger']  = 'sl_monitor_sent_msgs';

}



/**
  * Returns version info about this plugin
  *
  */
function squirrel_logger_version() 
{

   return '2.0-1.2.7';

}



/**
  * Log user logins
  *
  */
function sl_log_login() 
{

  include_once(SM_PATH . 'plugins/squirrel_logger/functions.php');
  sl_log_login_do();

}



/**
  * Log user logouts
  *
  */
function sl_log_logout() 
{

  include_once(SM_PATH . 'plugins/squirrel_logger/functions.php');
  sl_log_logout_do();

}



/**
  * Log user login errors
  *
  */
function sl_log_login_error($args) 
{

  include_once(SM_PATH . 'plugins/squirrel_logger/functions.php');
  sl_log_login_error_do($args);

}



/**
  * Log user errors
  *
  */
function sl_log_error($args) 
{

  include_once(SM_PATH . 'plugins/squirrel_logger/functions.php');
  sl_log_error_do($args);

}



/**
  * Monitor mails being sent, watching for possible mass mailings (spam)
  *
  */
function sl_monitor_sent_msgs($args) 
{

  include_once(SM_PATH . 'plugins/squirrel_logger/functions.php');
  sl_monitor_sent_msgs_do($args);

}



?>
