<?php

   /*
    *  sql_squirrel_logger v1.1.0 (12/15/2003)
    *  A mysql based logger derived from Ron Chinn's squirrel_logger plugin.
    *  by Pat Winn <pat.winn@velocibyte.com>
    *
    *  No error reporting or debugging are used at this time.
    *  It is assumed that you know the values to put in below to connect
    *  to your database. The database schema is included below.
    *
    *  This should be reasonably secure, but I make no claims of it being secure. 
    *  You are on your own should you decide to use this. 
    *
    *  squirrel_logger version 1.0 is by Ron Chinn
    *  <ron@amalgasys.com>
    *
    *  (c) 2002 GNU GPL
   */

   /* ==============================================================================
       Database setup:
       1. Create a database w/ name of your choice.
       2. Create the table below:

       #DROP TABLE IF EXISTS userActivity;
       CREATE TABLE `userActivity` (
         `username` varchar(64) NOT NULL default '',
         `activity` varchar(10) NOT NULL default '',
         `fromHost` varchar(128) NOT NULL default '',
         `date` datetime NOT NULL default '0000-00-00 00:00:00'
       ) TYPE=MyISAM COMMENT='User activity';

       3. GRANT select, insert, update, delete ON yourdatabase_name.* TO yourdatabase_user@yourdatabase_host identified by 'your_password';
       (select, delete and update are there for use later in viewing the data via a web page)

       4. Enjoy ;-)
   ==============================================================================*/
 
   global $sl_namelookups, $db, $dbuser, $dbpasswd, $dbhost;

   // --------------------------------------------------------------------
   // ** Modify the following settings for your particular installation **
   // --------------------------------------------------------------------

   // Turn hostname lookups on or off
   // Valid options are TRUE and FALSE
   //
   // example:   $sl_namelookups = TRUE;

   $sl_namelookups = TRUE;

   // database name for storing things in
   // example:   "squirrelStats" 

   $db = "squirrelStats";

   // database user name to use
   // example:   "squirrel"
   
   $dbuser = "CHANGE_ME";

   // database password to use
   // example:   "some!password"
  
   $dbpasswd = "CHANGE_ME";

   // host where database lives (where to connect to)
   // example:   "localhost"

   $dbhost = "localhost";

// -----------------------------------------------------------------------
// You don't need to modify anything below this line
// -----------------------------------------------------------------------

function squirrelmail_plugin_init_sql_squirrel_logger()
{ 
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks["login_verified"]["sql_squirrel_logger"] = "sql_squirrel_logger_login";
  $squirrelmail_plugin_hooks["logout"]["sql_squirrel_logger"] = "sql_squirrel_logger_logout";
  $squirrelmail_plugin_hooks["invalid_login"]["sql_squirrel_logger"] = "sql_squirrel_logger_invalid";
}

// Execute a database query
// $query = query string to use
// Returns: result set (empty if nothing found)
function doQuery($query) {
    global $db, $dbuser, $dbpasswd, $dbhost;

    $conn = mysql_connect($dbhost, $dbuser, $dbpasswd);
    mysql_select_db($db, $conn);
    $result = mysql_query($query);
    mysql_close();
}


// -------------------------------------------------
// Log a successful login
// -------------------------------------------------

function sql_squirrel_logger_login()
{
  global $login_username;
  global $sl_namelookups;
    
  if ($sl_namelookups == TRUE)
      $ip_str = gethostbyaddr(getenv("REMOTE_ADDR"));
  else
      $ip_str = getenv("REMOTE_ADDR");
  
  if(!isset($ip_str))
	$ip_str = "Unknown";

  $query = "insert into userActivity values('" . $login_username . "','LOGIN','" . $ip_str . "',now())";
  doQuery($query);
}

// -------------------------------------------------
// Log a successful logout
// -------------------------------------------------

function sql_squirrel_logger_logout()
{
  global $username;
  global $sl_namelookups;
    
  if ($sl_namelookups == TRUE)
      $ip_str = gethostbyaddr(getenv("REMOTE_ADDR"));
  else
      $ip_str = getenv("REMOTE_ADDR");
  
  if(!isset($ip_str))
	$ip_str = "Unknown";

  if (strstr(getenv("REQUEST_URI"),"timeout") == TRUE)
    $event_str = "TIMEOUT";
  else
    $event_str = "LOGOUT";  

  $query = "insert into userActivity values('" . $username . "','" . $event_str . "','" . $ip_str . "',now())";
  doQuery($query);
}



// -------------------------------------------------
// Log an invalid login attempt
//
// This only works if the user adds a hook in
//  functions/imap_general.php
// -------------------------------------------------

function sql_squirrel_logger_invalid()
{
  global $login_username;
  global $sl_namelookups;
    
  if ($sl_namelookups == TRUE)
      $ip_str = gethostbyaddr(getenv("REMOTE_ADDR"));
  else
      $ip_str = getenv("REMOTE_ADDR");
  
  if(!isset($ip_str))
	$ip_str = "Unknown";

  $query = "insert into userActivity values('" . $login_username . "','INVALID','" . $ip_str . "',now())";
  doQuery($query);
}


?>
