<?php

/**
 * spamrule/config.php
 * 
 * User configuration page for the SquirrelMail "spamrule" plugin,
 * which provides users with simple management of email filter groups.
 * 
 * @copyright Copyright (c) 2002-2007 O'Shaughnessy Evans <shaug-sqml @ wumpus.org>
 * @version $Id: config.php,v 1.19 2007/09/11 23:55:11 shaug Exp $
 * @license http://opensource.org/licenses/artistic-license-2.0.php
 * @package plugins
 * @subpackage spamrule
 */


/*
 * Filter Installation Config
 * 
 * In the options below, you should configure the name of the host that
 * provides the IMAP users with FTP access to their accounts.  Each user
 * must have their own account with the ability to change their mail
 * forward file and their mail filtering file.
 * 
 * If this isn't an option, you can configure a local program to run when
 * installing filters by setting $SPAMRULE_INSTALL['command'].  If that 
 * variable is set, it will be used instead of FTP.
 * 
 * By default:
 *   - the plugin will use localhost as the FTP server,
 *   - .forward as the user's mail forward file,
 *   - maildrop as the email filter, installed in /usr/local/bin/maildrop
 *   - .mailfilter as the path to the user's maildrop config
 *   - .mailfilters as the subdir where the user's maildrop pattern files go
 *   - /usr/local/etc/maildroprcs as the include dir for enabling
 *     individual maildrop filters
 * 
 * There are a lot of individual maildrop filters that are configured later
 * in this file.  If you want to use those, then you may also want to install
 * the maildroprc and maildroprcs that are included in this distribution
 * under the "maildrop" directory.  Copy them both to /usr/local/etc or
 * wherever your maildrop binary is compiled to look.
 * 
 * Read through this config file carefully.  There's a lot you can configure,
 * and it looks complicated, but the end result for users should be very
 * clear and simple.
 */


// make these global so that the vlogin plugin can override options
// and other files can access them
global $SPAMRULE_OPTS, $SPAMRULE_INSTALL, $domain, $javascript_on, $username;
sqsession_register($SPAMRULE_OPTS, 'SPAMRULE_OPTS');
sqsession_register($SPAMRULE_INSTALL, 'SPAMRULE_INSTALL');
sqgetGlobalVar('domain', $domain, SQ_SESSION);
sqgetGlobalVar('javascript_on', $javascript_on, SQ_SESSION);
sqgetGlobalVar('username', $username, SQ_SESSION);


// The host that stores user mail filter info:
//  Each user with an IMAP account must have the same login and password here.
// Don't override this if it's already set so that the vlogin plugin can
// define it.
if (empty($SPAMRULE_OPTS['ftphost'])) {
    $SPAMRULE_OPTS['ftphost'] = 'localhost';
}

// User mail filter info:
//
// What is the name of the mail filter config?
//  for procmail, it would be .procmailrc
//  for maildrop, .mailfilter
$SPAMRULE_INSTALL['filter_file'] = '.mailfilter';
// What should an individual line in the filter file look like?
//  %s will be replaced with the name of the given filter as set in
//  $SPAMRULE_FILTERS[] (see below).
$SPAMRULE_INSTALL['filter_string'] =
 "include(\"/usr/local/etc/maildroprcs/%s\")\n";

// User forward file info:
//
// What is the name of the user's filter file?
//  for sendmail or postfix, it would be .forward
//  for qmail, .qmail
$SPAMRULE_INSTALL['forward_file']    = '.forward';
// What should the filter file contain?  (make sure to include the newline)
//$SPAMRULE_INSTALL['forward_string']  = '| /usr/local/bin/maildrop';
$SPAMRULE_INSTALL['forward_string']  = '"|/usr/local/bin/maildrop"';
// What pattern will match the forward filter string?
//$SPAMRULE_INSTALL['forward_pattern'] = '^\| */usr/local/bin/maildrop';
$SPAMRULE_INSTALL['forward_pattern'] = '^\"?\| */usr/local/bin/maildrop\"?';
// What pattern will match the local inbox?
//$SPAMRULE_INSTALL['inbox_pattern']   = '^\.\/Incoming';
$SPAMRULE_INSTALL['inbox_pattern']   = "^\.$username";

// The command to run to install the new set of filters:
//  %s will be replaced with the names of all the filters being installed,
//  as named in the keys of $SPAMRULE_FILTERS[].
/*
$SPAMRULE_INSTALL['command'] =
 "/usr/local/www/libexec/save-mailfilters -l {$username} %s";
*/



/*
 * Individual Filters
 * 
 * Define an array of filters here:
 * Each filter entry should be keyed by the name with which its form input
 * will be known.  Each filter value should be an array with these strings:
 *   title:      A brief name for the filter.
 *   text:       A few sentences describing the filter.
 *   install:    If defined, this command will be run when the filter has been
 *               selected for use.  If not defined, the default install command
 *               or FTP process will be used (see above).
 *   uninstall:  If defined, this command will be run whenever the filter has
 *               *not* been selected for use.
 */
$SPAMRULE_OPTS['filters'] = array(
  'only-from'  => array(
    'title'    => 'Only From',
    'text'     => 'Only accept mail from an <em>Allowed Sender</em>.  Mail '.
                  'from them will always go through; mail from <em>everyone '.
		  'else will be sent to your "Junk" mailbox.</em>  <em>Please '.
		  'note!</em>  This supercedes all other filters.  IF YOU '.
		  'ENABLE THIS, NONE OF YOUR OTHER FILTERS WILL BE USED.'.
		  '<div align=right><small><em>Update your:  '.
                  ( $javascript_on
                    ? '<a href="javascript:void(0)" onclick="subwin'.
                      '(\'options.php?action=editlist&list=allowed_senders\', '.
                      '\'sr_editlist\', 500, 600)">'
                    : '<a href="options.php?action=editlist'.
                      '&list=allowed_senders" target="_blank">'
                  ).
		  'Allowed Senders</a></em></small></div>'.
		  '<hr size=1>'
  ),
  'always-from' => array(
    'title'    => 'Always From',
    'text'     => 'Always accept mail from an <em>Allowed Sender</em>.  Mail '.
                  'from them will always go through, no matter what other '.
		  'filters are in use.'.
		  '<div align=right><small><em>Update your:  '.
                  ( $javascript_on
                    ? '<a href="javascript:void(0)" onclick="subwin'.
                      '(\'options.php?action=editlist&list=allowed_senders\', '.
                      '\'sr_editlist\', 450, 450)">'
                    : '<a href="options.php?action=editlist'.
                      '&list=allowed_senders" target="_blank">'
                  ).
		  'Allowed Senders</a></em></small></div>'
),
  'subject-passwords' => array(
    'title'    => 'Subject Passwords',
    'text'     => 'Always accept mail with one of your <em>Subject '.
                  'Passwords</em>.  Create one or more secret words, '.
                  'and then tell them to your friends.  All they have to do '.
                  'is include a secret word in the <b>Subject</b> and the '.
                  'message will get past your filters.'.
                  '<div align=right><small><em>Update your:  '.
                  ( $javascript_on
                    ? '<a href="javascript:void(0)" onclick="subwin'.
                      '(\'options.php?action=editlist'.
                      '&list=subject_passwords\', \'sr_editlist\', 450, 450)">'
                    : '<a href="options.php?action=editlist'.
                      '&list=subject_passwords" target="_blank">'
                  ).
		  'Subject Passwords</a></em></small></div>'
  ),
  'only-to-cc' => array(
    'title'    => 'Only To Me',
    'text'     => 'If "'. $username. '@aloha.net" or one of your '.
                  '<em>aliases</em> isn\'t in the <b>To</b> or <b>Cc</b> '.
                  'headers, send the message to your "Junk" mailbox.  This '.
                  '<em>may</em> catch some mailing lists, so if you\'re '.
                  'subscribed to a list, enable the <em>Always From</em> '.
                  'filter and add the list sender to your <em>Allowed Senders'.
                  '</em> before using this.'.
		  '<div align=right><small><em>Update your:  '.
                  ( $javascript_on
                    ? '<a href="javascript:void(0)" onclick="subwin'.
                      '(\'options.php?action=editlist&list='.
                       'allowed_recipients\', \'sr_editlist\', 450, 450)">'
                    : '<a href="options.php?action=editlist&list='.
                      'allowed_recipients" target="_blank">'
                  ).
		  'Aliases</a> '.
                  ( $javascript_on
                    ? '<a href="javascript:void(0)" onclick="subwin'.
                      '(\'options.php?action=editlist&list=allowed_senders\', '.
                      '\'sr_editlist\', 450, 450)">'
                    : '<a href="options.php?action=editlist'.
                      '&list=allowed_senders" target="_blank">'
                  ).
		  'Allowed Senders</a></em></small></div>'
  ),
  /* // this doesn't work on a qmail system.  only-to-cc is enough.
  'reject-bcc' => array(
    'title'    => 'No Blind Ccs',
    'text'     => 'Filter any mail that was sent as a Blind Carbon Copy.  '.
                  'This means the message was sent to people that aren\'t '.
                  'listed in the <b>To</b> or <b>Cc</b> header, and there\'s '.
                  'no way for you to know who.'
  ),
  */
  'reject-ad' => array(
    'title'    => 'No Ads',
    'text'     => 'Catch any mail with a subject that starts with "AD" or '.
                  '"ADV", or mail that has an <b>X-Advertisement</b> or '.
                  '<b>X-Promotion</b> header.  Some spammers will announce '.
                  'their unsolicited mail this way.'
  ),
  'reject-bulk' => array(
    'title'    => 'No Bulk Mail',
    'text'     => 'Block any mail that has a "bulk" or "low" '.
                  '<b>Priority</b> header.  This is almost always junk mail.'
  ),
  'reject-not822' => array(
    'title'    => 'No Broken Messages',
    'text'     => 'Filter any mail that isn\'t properly formatted email '.
                  '(called "RFC 822-compliant").  Most Internet Providers '.
                  'will make sure the mail from their servers complies with '.
                  'this and other standards because it\'s more likely to get '.
                  'delivered correctly, and less likely to break mail '.
                  'programs like Outlook or Eudora.  Spammers, on the other '.
                  'hand, don\'t seem to care quite as much.'
  ),
  'reject-me' => array(
    'title'    => 'Never From Me',
    'text'     => 'Never accept mail that was sent from your own address, "'.
                  $username. '@aloha.net."  Some spammers will '.
		  'fake the sender and make it appear that the message is '.
		  'coming <em>from</em> you as well as being sent <em>to</em> '.
		  'you.  Unless you send yourself email, this is a safe way '.
		  'to stop some junk from getting through.'
  ),
  'reject-from' => array(
    'title'    => 'Never From',
    'text'     => 'Filter any mail from a <em>Blocked Sender</em>.  Add the '.
                  'addresses of people from whom you never want to get mail.'.
		  '<div align=right><small><em>Update your:  '.
                  ( $javascript_on
                    ? '<a href="javascript:void(0)" onclick="subwin'.
                      '(\'options.php?action=editlist&list=blocked_senders\','.
                      ' \'sr_editlist\', 450, 450)">'
                    : '<a href="options.php?action=editlist&list='.
                      'blocked_senders" target="_blank">'
                  ).
		  'Blocked Senders</a></em></small></div>'
  ),
  'reject-subject' => array(
    'title'    => 'Bad Subjects',
    'text'     => 'Filter any mail that has a <em>Blocked Subject</em>.  '.
                  'Edit your list of subject words, then any mail with a '.
                  'subject that matches your list will be filtered.'.
		  '<div align=right><small><em>Update your:  '.
                  ( $javascript_on
                    ? '<a href="javascript:void(0)" onclick="subwin'.
                      '(\'options.php?action=editlist&list=blocked_subjects\','.
                      ' \'sr_editlist\', 450, 450)">'
                    : '<a href="options.php?action=editlist&list='.
                      'blocked_subjects" target="_blank">'
                  ).
		  'Blocked Subjects</a></em></small></div>'
  ),
/*
  'spamassassin' => array(
    'title'    => 'SpamAssassin',
    'text'     => 'Use <a href="http://www.spamassassin.org" target="_blank">'.
                  'SpamAssassin</a>, a comprehensive program that applies '.
                  'many advanced tests, to check whether a message is junk.  '.
                  'Note that if a message is filtered by this rule, you\'ll '.
                  'see a description of why it was caught in the first part '.
                  'of your message.'
  ),
 */
/*
  'GLOBAL' => array(
    'title'    => 'System-Wide Filters',
    'text'     => 'These filters are used for all incoming mail at '.
                  'aloha.net.  They utilize various tools to stop junk mail, '.
                  'including sophisticated tests to look for common spam '.
                  'characteristics and blacklists that block mail from known '.
                  'Internet abusers and stop a lot of junk before it '.
                  'gets inside the HOL computers.  Occasionally, '.
                  'though, they may block legitimate email.  '.
                  'We <em>strongly</em> recommend that you leave this '.
                  'enabled, but if you know that mail from a contact is '.
                  'getting blocked, you may want to opt out by disabling '.
                  'this option via the "Custom" filters.  If you would like '.
                  'to learn more about these filters, please see '.
                  '<a href="http://www.aloha.net/support/antispam.php" '.
                  'target="_blank">our Anti-Spam page</a>.',
    'install'   => '/usr/local/www/libexec/spamfriend-del '. $username,
    'uninstall' => '/usr/local/www/libexec/spamfriend-add '. $username,
  ),
 */
/*
 *   'FORWARD' => array(
 *     'default'  => FALSE,
 *     'title'    => 'Forward All Mail',
 *     'text'     => 'Send all my mail to another address:  '.
 *                   '<input type=text size=30 name=ADD_FORWARD> '.
 *                   '(<small><i>Keep a local copy, too</i></small> '.
 *                   '<input type=checkbox name=KEEP_FORWARD>)'
 *   ),
 */
);



/*
 * Filter Groups
 * 
 * Define each group of filters that the user can choose.  These will be
 * presented at the first option page for the plugin.  Each group should
 * have a 'title' and a 'text' definition, both of which will be listed in
 * the option page.  The 'filters' are an array of keys from the
 * $SPAMRULE_FILTERS list.  If the user selects a group, that list of filters
 * will be saved in their account.  'CUSTOM' is a special element here:  if
 * the user selects that, they'll be shown a form that lists each element
 * in $SPAMRULE_FILTERS, with those in this 'filters' element selected by
 * default, where they can choose exactly which filters they want to use.
 */
// Name the default group here (should be one of the keys in $SPAMRULE_GROUPS)
$SPAMRULE_OPTS['default_group'] = 'CAREFUL';
// Array of arrays, each containing a group of filters that the user can
// select.
$SPAMRULE_OPTS['groups'] = array(
  'ALL_OFF' => array(
    'title'   => 'No Personal Filtering',
    //'filters' => array('GLOBAL'),
    'filters' => array(),
    'text'    => <<<EOtext
  Don't do any special filtering.<br>
  <!--
  <small><i>Your mail will still go through the system-wide filters (see
  the description under "Custom").</i></small>
  -->
EOtext
  ),
  'CAREFUL' => array(
    'title'   => 'Careful',
    //'filters' => array('only-to-cc', 'reject-ad', 'reject-bulk', 'GLOBAL'),
    'filters' => array('only-to-cc', 'reject-ad', 'reject-bulk'),
    'text'    => <<<EOtext
  Only filter out messages that clearly look like junk mail.<br>
  <small><i>If you have any other email addresses that go to this mailbox, make sure to return here and customize your aliases when you're finished.
  </i></small>
EOtext
  ),
  'STRICT' => array(
    'title'   => 'Strict',
    'filters' => array('always-from', 'subject-passwords', 'only-to-cc',
                       'reject-ad', 'reject-bulk', 'reject-not822',
                       'reject-from', 'reject-subject'),
                        #'spamassassin', 'GLOBAL'),
    'text'    => <<<EOtext
  Be aggressive:  use all the available filters.<br>
  <small><i>... including your own lists of Allowed Senders, Blocked Senders,
  Blocked Subjects, and Subject Passwords that can be very useful.
  </i></small>
EOtext
  ),
  'CUSTOM' => array(
    'title'   => 'Custom',
    'filters' => array('only-to-cc', 'reject-ad', 'reject-bulk',
                       'reject-not822'), #'GLOBAL'),
    'text'    => <<<EOtext
  Choose your own set of filters.<br>
  <small><i>
  Use this to select from all the filters we have available.
  <!-- , or to opt out
  of the system-wide filters if you're having trouble getting mail from
  someone. -->
  </i></small>
EOtext
  )
);



/*
 * Page Descriptions
 * 
 * These sections go at the top and bottom of each different Options page.
 * 
 * $SPAMRULE_OPTS is an array of arrays.  Each array contains text for a
 * different options page:
 * 
 *   $SPAMRULE_OPTS['groups']
 * 
 * Each of these arrays contains a sub-array with specific fields:
 * 
 *   $SPAMRULE_OPTS[<array>]['header']
 *   $SPAMRULE_OPTS[<array>]['footer']
 * 
 *   For the lists that users can maintain:
 *   $SPAMRULE_OPTS[<array>]['file'] -- where the list is kept (can be relative)
 *   $SPAMRULE_OPTS[<array>]['type'] -- if "email", then only addrs are allowed
 *   $SPAMRULE_OPTS[<array>]['title'] -- title of the editing window page
 *   $SPAMRULE_OPTS[<array>]['default'] -- how to initialize the file's contents
 */

// Description of the first page, showing the filter group selection form:
$SPAMRULE_OPTS['groupsel']['header'] = <<<EOdesc
  <p>Here you can control the way your incoming mail will be filtered.
  All messages caught by the rules you select will be delivered to your
  "Junk" mail folder.</p>
EOdesc;
$SPAMRULE_OPTS['groupsel']['footer'] = <<<EOdesc
  <div align=left><p>
  <em>Please note:</em><ul>
  <li>Messages in your "Trash" mail folder <u>do not</u> count against your
    storage.
  <li>Messages in your "Junk" mail folder <u>do</u> count against your
    storage.
  <li>Messages more than a few days old are removed from both of these folders
    to keep them from getting too large.  Be sure to check your "Junk"
    mailbox periodically to make sure you don't miss any mail that you want
    to get.
  <li>No junk mail filter is perfect.  Spammers are always trying to come
    up with new ways to get around the things we do to block them.  It's
    possible that some legitimate mail will be caught by our filters, so
    check your Junk mailbox regularly.  The stricter the filter you choose,
    the more likely it will be to catch good email, but of course it
    should also catch a lot more spam.
  </ul>
  </p></div>
EOdesc;

// Description of the follow up page after filters have been saved
$SPAMRULE_OPTS['summary']['header'] = <<<EOdesc
  <p align=left>
    Your preferences have been saved.
    Here's the ruleset you've selected:
  </p>
EOdesc;
$SPAMRULE_OPTS['summary']['footer'] = $SPAMRULE_OPTS['groups']['footer']. 
<<<EOfooter
  <p><a href="options.php">Back to the beginning</a></p>
EOfooter;

// Description of the page showing a user's subscribed filters
$SPAMRULE_OPTS['show']['header'] = NULL;
$SPAMRULE_OPTS['show']['footer'] = $SPAMRULE_OPTS['groups']['footer'].
  '<div align=center><p><a href="options.php">Back to the beginning</a></p></div>';

// Description of the custom filters selection form:
$SPAMRULE_OPTS['custom']['header'] = <<<EOheader
  <p>Here you can choose exactly which filters you want to use.  If you
  customized your filters before now, your old settings will already be loaded.
  If this is your first time, our recommended list will be selected.</p>
  <p><strong>Make sure you press &quot;Finish&quot; to save your changes.
  </strong></p>
EOheader;
$SPAMRULE_OPTS['custom']['footer'] = <<<EOfooter
  <p><a href="options.php">Back to the beginning</a></p>
EOfooter;

// Some custom filter subpages:
// ... for editing the list of senders from whom we'll *always* accept mail
$SPAMRULE_OPTS['allowed_senders']['file'] = '.mailfilters/senders+';
$SPAMRULE_OPTS['allowed_senders']['type'] = 'email';
$SPAMRULE_OPTS['allowed_senders']['title'] = 'Allowed/Exclusive Senders';
$SPAMRULE_OPTS['allowed_senders']['anchor'] = TRUE;
$SPAMRULE_OPTS['allowed_senders']['header'] = <<<EOdesc
  <p align=center><u>Allowed Senders</u></p>
  <p align=left>
     Here you can list people from whom you <strong><em>always</em></strong>
     want to get email, regardless of your other Spam Filters.  For example,
     if you add "<tt>a_good_friend@{$domain}</tt>", then any mail
     from your friend will always go directly to your Inbox; if you just add
     "<tt>@{$domain}</tt>", then mail from anyone at your
     friend's domain will be allowed through.  If you've chosen the
     <em>Only From</em> filter, then you'll <strong>only</strong> get mail
     from these people, and <strong>none from anyone else</strong>.  If
     you've chosen <em>Always From</em>, then mail from these people will
     always go to your Inbox, but mail from other people may also get through.
  </p>
EOdesc;
$SPAMRULE_OPTS['allowed_senders']['footer'] = $javascript_on
 ? '<p>[ <a href="javascript:window.close()">Close</a> ]</p>'
 : '';
/*
$SPAMRULE_OPTS['allowed_senders']['footer'] = <<<EOfooter
  <p>[ <a href="options.php">Back to the beginning</a> |
     <a href="options.php?action=subscribed">Show my current filters</a> ]
  </p>
EOfooter;
*/
//$SPAMRULE_OPTS['allowed_senders']['default'] = 
// $username. '@'. $domain;

// ... for editing the list of users from whom we'll *never* accept mail
$SPAMRULE_OPTS['blocked_senders']['file'] = '.mailfilters/senders-';
$SPAMRULE_OPTS['blocked_senders']['type'] = 'email';
$SPAMRULE_OPTS['blocked_senders']['title'] = 'Blocked Senders';
$SPAMRULE_OPTS['blocked_senders']['anchor'] = TRUE;
$SPAMRULE_OPTS['blocked_senders']['header'] = <<<EOdesc
  <p align=center><u>Blocked Senders</u></p>
  <p align=left>
     Here you can list addresses from which you <strong><em>never</em></strong>
     want to get email.  For example, if you add
     "<tt>some_joker@example.org</tt>", then any mail from that address will
     always be put into your "Junk" mailbox.
  </p>
EOdesc;
$SPAMRULE_OPTS['blocked_senders']['footer']
 = $SPAMRULE_OPTS['allowed_senders']['footer'];

// ... for editing the list of users that we use as aliases in only-to-cc
$SPAMRULE_OPTS['allowed_recipients']['file'] = '.mailfilters/recipients+';
$SPAMRULE_OPTS['allowed_recipients']['type'] = 'email';
$SPAMRULE_OPTS['allowed_recipients']['title'] = 'Allowed Recipients';
$SPAMRULE_OPTS['allowed_recipients']['anchor'] = TRUE;
$SPAMRULE_OPTS['allowed_recipients']['header'] = <<<EOdesc
  <p align=center><u>Allowed Recipients</u></p>
  <p align=left>
     Here you can list alternative addresses, a.k.a. "aliases", that get sent
     to <em>{$username}@aloha.net</em>.  If you are forwarding
     mail from other Internet Providers to your aloha.net account, or you have
     an alias or mailbox-only account with us, and you chose the <em>Only To
     Me</em> filter, we recommend that you add those other addresses here.
  </p>
  <p align=left>
     For example, if you have a Yahoo! account and forward
     your messages here, you should add "<tt>yourname@yahoo.com</tt>"
     to this list so that messages for <em>yourname@yahoo.com</em> won't
     get caught by the <em>Only to Me</em> filter.
  </p>
EOdesc;
$SPAMRULE_OPTS['allowed_recipients']['footer']
 = $SPAMRULE_OPTS['allowed_senders']['footer'];


// ... for editing the list of subject words that we want to block
$SPAMRULE_OPTS['blocked_subjects']['file'] = '.mailfilters/subjects-';
$SPAMRULE_OPTS['blocked_subjects']['title'] = 'Blocked Subjects';
$SPAMRULE_OPTS['blocked_subjects']['header'] = <<<EOdesc
  <p align=center><u>Blocked Subjects</u></p>
  <p align=left>
     Here you can create a list of subject words that you want to block.  Any
     message that has one of these phrases in the <b>Subject</b> field will be
     filtered.  For example, if you add "<tt>some bad phrase</tt>", then any
     mail that says "<em>some bad phrase</em>" anywhere in the subject will be
     put into your "Junk" mail folder.
  </p>
EOdesc;
$SPAMRULE_OPTS['blocked_subjects']['footer']
 = $SPAMRULE_OPTS['allowed_senders']['footer'];

// ... for editing the list of subject words that we want to accept
$SPAMRULE_OPTS['subject_passwords']['file'] = '.mailfilters/subjects+';
$SPAMRULE_OPTS['subject_passwords']['title'] = 'Subject Passwords';
$SPAMRULE_OPTS['subject_passwords']['header'] = <<<EOdesc
  <p align=center><u>Subject Passwords</u></p>
  <div align=left>
  <p>
     Here you can create a list of secret keywords that will let email
     go straight past your filters and right into your Inbox.  Any message
     that has one of these phrases in the <b>Subject</b> field will
     <strong><em>always</em></strong> be allowed.  For example, if you
     add <tt>(My Friends)</tt>, then any mail that
     says "<em>(My Friends)</em>" anywhere in the <b>Subject</b> line will
     make it past your spam filters.  You can create more than one secret:
     give one to your friends and family and another to business associates.
  </p>
  <p>
     For example:<br><ul>
     <li>Add <tt>(Friends)</tt> and tell your friends to use that tag in
         the Subject line whenever they send you mail.
     <li>Create a entry like <tt>short term secret:</tt>, then give it to
         someone that you want to send you mail for just a limited time.
     <li>If you're on a mailing list that tags Subject lines, add that tag
         to your keywords list below.
     </ol>
  </p>
  </div>
EOdesc;
$SPAMRULE_OPTS['subject_passwords']['footer']
 = $SPAMRULE_OPTS['allowed_senders']['footer'];


?>
