<?php

/**
  * SquirrelMail Spam Buttons Plugin
  * Copyright (c) 2005-2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage spam_buttons
  *
  */



/**
  * Constructs spam button text
  *
  * @param array $buttons The list of buttons being added to under 1.5.2+
  *                       NOTE that this parameter is passed by reference
  *                       and is potentially modified herein.  Because it
  *                       is passed by reference, PHP 4 doesn't like a default
  *                       value being specified, so callers should pass an
  *                       empty string when it is not needed (usually only
  *                       needed under 1.5.2 during the relevant hooks, such 
  *                       as "message_list_controls").
  * @param boolean $dont_show_if_report_by_move_to_folder When true, and the
  *                                                       report-by-move-to-
  *                                                       folder method is
  *                                                       configured, don't
  *                                                       show the corresponding
  *                                                       button if the message
  *                                                       in question is an
  *                                                       attachment to another
  *                                                       message, otherwise all
  *                                                       buttons are shown no
  *                                                       matter what (OPTIONAL;
  *                                                       default = FALSE).
  */
function get_spam_buttons(&$buttons, 
                          $dont_show_if_report_by_move_to_folder=FALSE)
{

   global $show_not_spam_button, $spam_button_text, $not_spam_button_text,
          $show_is_spam_button, $username, $data_dir,
          $sb_report_spam_by_move_to_folder, 
          $sb_report_not_spam_by_move_to_folder,
          $sb_suppress_spam_button_folder,
          $sb_suppress_spam_button_folder_allow_override,
          $sb_suppress_not_spam_button_folder,
          $sb_suppress_not_spam_button_folder_allow_override,
          $sb_show_spam_button_folder,
          $sb_show_spam_button_folder_allow_override,
          $sb_show_not_spam_button_folder,
          $sb_show_not_spam_button_folder_allow_override;
 
   $passed_ent_id = 0;
   sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
   sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
   if (empty($mailbox)) $mailbox = 'INBOX';

   spam_buttons_init();

   if ($sb_suppress_spam_button_folder_allow_override)
   {
      $sb_suppress_spam_button_folder = getPref($data_dir, $username, 
                                                'sb_suppress_spam_button_folder', 
                                                $sb_suppress_spam_button_folder);
   }
   if ($sb_suppress_not_spam_button_folder_allow_override)
   {
      $sb_suppress_not_spam_button_folder = getPref($data_dir, $username, 
                                                    'sb_suppress_not_spam_button_folder', 
                                                    $sb_suppress_not_spam_button_folder);
   }
   if ($sb_show_spam_button_folder_allow_override)
   {
      $sb_show_spam_button_folder = getPref($data_dir, $username, 
                                            'sb_show_spam_button_folder', 
                                            $sb_show_spam_button_folder);
   }
   if ($sb_show_not_spam_button_folder_allow_override)
   {
      $sb_show_not_spam_button_folder = getPref($data_dir, $username, 
                                                'sb_show_not_spam_button_folder', 
                                                $sb_show_not_spam_button_folder);
   }


   // these options used to be a strings; these lines convert
   // values that may have already been stored in user prefs
   // as strings into proper array format (also unpacks
   // serialized arrays for SM v1.5.2+)...  perhaps this
   // code should be removed a year (or more?) after 1.4.x
   // supports multiple select folder lists on the options page
   // (but not the unserialize() calls)
   //
   if (empty($sb_suppress_spam_button_folder))
      $sb_suppress_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_suppress_spam_button_folder))
      $sb_suppress_spam_button_folder = unserialize($sb_suppress_spam_button_folder);
   if (!is_array($sb_suppress_spam_button_folder))
      $sb_suppress_spam_button_folder = array($sb_suppress_spam_button_folder);

   if (empty($sb_suppress_not_spam_button_folder))
      $sb_suppress_not_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_suppress_not_spam_button_folder))
      $sb_suppress_not_spam_button_folder = unserialize($sb_suppress_not_spam_button_folder);
   if (!is_array($sb_suppress_not_spam_button_folder))
      $sb_suppress_not_spam_button_folder = array($sb_suppress_not_spam_button_folder);

   if (empty($sb_show_spam_button_folder))
      $sb_show_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_show_spam_button_folder))
      $sb_show_spam_button_folder = unserialize($sb_show_spam_button_folder);
   if (!is_array($sb_show_spam_button_folder))
      $sb_show_spam_button_folder = array($sb_show_spam_button_folder);

   if (empty($sb_show_not_spam_button_folder))
      $sb_show_not_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_show_not_spam_button_folder))
      $sb_show_not_spam_button_folder = unserialize($sb_show_not_spam_button_folder);
   if (!is_array($sb_show_not_spam_button_folder))
      $sb_show_not_spam_button_folder = array($sb_show_not_spam_button_folder);


//TODO: create tooltip with more verbose explanation 
   $ret = '';

   if ($show_is_spam_button || $show_not_spam_button)
      $ret .= ' ';
   
   sq_change_text_domain('spam_buttons');


   // 1) is button turned on in the first place?
   // 2)  a) if in (one of) the ham folder(s), show spam button
   //     b) otherwise, if not using the ham folder (list), then
   //        if in (one of) the spam folder(s), don't show spam button
   // 3) if current message is tagged as spam, don't show spam button
   // 4) can't show button if caller doesn't want it shown
   //    when report method is move-to-folder and we're 
   //    looking at a message that is an attachment to another
   // 
   if ($show_is_spam_button
    && (in_array($mailbox, $sb_show_spam_button_folder)
     || (empty($sb_show_spam_button_folder) 
      && !in_array($mailbox, $sb_suppress_spam_button_folder)))
    && !current_message_is_tagged(TRUE)
    && (!$dont_show_if_report_by_move_to_folder
     || !($sb_report_spam_by_move_to_folder && !empty($passed_ent_id))))
   {
      if (check_sm_version(1, 5, 2))
         $buttons['isSpam'] = array('value' => _($spam_button_text), 'type' => 'submit');
      else if (check_sm_version(1, 5, 1))
         $buttons[1]['isSpam'] = array(0 => _($spam_button_text), 1 => 'submit');
      else
         $ret .= '<input type="submit" name="isSpam" value="' . _($spam_button_text) . "\" />\n";
   }


   // 1) is button turned on in the first place?
   // 2)  a) if in (one of) the spam folder(s), show ham button
   //     b) otherwise, if not using the spam folder (list), then
   //        if in (one of) the ham folder(s), don't show ham button
   // 3) if current message is tagged as ham, don't show ham button
   // 4) can't show button if caller doesn't want it shown
   //    when report method is move-to-folder and we're 
   //    looking at a message that is an attachment to another
   // 
   if ($show_not_spam_button
    && (in_array($mailbox, $sb_show_not_spam_button_folder)
     || (empty($sb_show_not_spam_button_folder) 
      && !in_array($mailbox, $sb_suppress_not_spam_button_folder)))
    && !current_message_is_tagged(FALSE)
    && (!$dont_show_if_report_by_move_to_folder
     || !($sb_report_not_spam_by_move_to_folder && !empty($passed_ent_id))))
   {
      if (check_sm_version(1, 5, 1))
         $buttons['notSpam'] = array('value' => _($not_spam_button_text), 'type' => 'submit');
      else if (check_sm_version(1, 5, 1))
         $buttons[1]['notSpam'] = array(0 => _($not_spam_button_text), 1 => 'submit');
      else
         $ret .= '<input type="submit" name="notSpam" value="' . _($not_spam_button_text) . "\" />\n";
   }

   sq_change_text_domain('squirrelmail');

   return $ret;

}



/**
  * Adds spam/ham links to message options list on read body page
  *
  */
function sb_read_message_links_do(&$links)
{

   include_once(SM_PATH . 'plugins/spam_buttons/functions.php');

   global $show_spam_link_on_read_body, $show_not_spam_button, 
          $spam_button_text, $not_spam_button_text, $show_is_spam_button,
          $sb_report_spam_by_move_to_folder, $username,
          $sb_report_not_spam_by_move_to_folder,
          $sb_suppress_spam_button_folder, $data_dir,
          $sb_suppress_spam_button_folder_allow_override,
          $sb_suppress_not_spam_button_folder,
          $sb_suppress_not_spam_button_folder_allow_override,
          $sb_show_spam_button_folder,
          $sb_show_spam_button_folder_allow_override,
          $sb_show_not_spam_button_folder,
          $sb_show_not_spam_button_folder_allow_override;

   spam_buttons_init();

   if (!$show_spam_link_on_read_body)
      return;

   if ($sb_suppress_spam_button_folder_allow_override)
   {
      $sb_suppress_spam_button_folder = getPref($data_dir, $username, 
                                                'sb_suppress_spam_button_folder', 
                                                $sb_suppress_spam_button_folder);
   }
   if ($sb_suppress_not_spam_button_folder_allow_override)
   {
      $sb_suppress_not_spam_button_folder = getPref($data_dir, $username, 
                                                    'sb_suppress_not_spam_button_folder', 
                                                    $sb_suppress_not_spam_button_folder);
   }
   if ($sb_show_spam_button_folder_allow_override)
   {
      $sb_show_spam_button_folder = getPref($data_dir, $username, 
                                            'sb_show_spam_button_folder', 
                                            $sb_show_spam_button_folder);
   }
   if ($sb_show_not_spam_button_folder_allow_override)
   {
      $sb_show_not_spam_button_folder = getPref($data_dir, $username, 
                                                'sb_show_not_spam_button_folder', 
                                                $sb_show_not_spam_button_folder);
   }


   // these options used to be a strings; these lines convert
   // values that may have already been stored in user prefs
   // as strings into proper array format (also unpacks
   // serialized arrays for SM v1.5.2+)...  perhaps this
   // code should be removed a year (or more?) after 1.4.x
   // supports multiple select folder lists on the options page
   // (but not the unserialize() calls)
   //
   if (empty($sb_suppress_spam_button_folder))
      $sb_suppress_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_suppress_spam_button_folder))
      $sb_suppress_spam_button_folder = unserialize($sb_suppress_spam_button_folder);
   if (!is_array($sb_suppress_spam_button_folder))
      $sb_suppress_spam_button_folder = array($sb_suppress_spam_button_folder);

   if (empty($sb_suppress_not_spam_button_folder))
      $sb_suppress_not_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_suppress_not_spam_button_folder))
      $sb_suppress_not_spam_button_folder = unserialize($sb_suppress_not_spam_button_folder);
   if (!is_array($sb_suppress_not_spam_button_folder))
      $sb_suppress_not_spam_button_folder = array($sb_suppress_not_spam_button_folder);

   if (empty($sb_show_spam_button_folder))
      $sb_show_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_show_spam_button_folder))
      $sb_show_spam_button_folder = unserialize($sb_show_spam_button_folder);
   if (!is_array($sb_show_spam_button_folder))
      $sb_show_spam_button_folder = array($sb_show_spam_button_folder);

   if (empty($sb_show_not_spam_button_folder))
      $sb_show_not_spam_button_folder = array();
   else if (check_sm_version(1, 5, 2) && !is_array($sb_show_not_spam_button_folder))
      $sb_show_not_spam_button_folder = unserialize($sb_show_not_spam_button_folder);
   if (!is_array($sb_show_not_spam_button_folder))
      $sb_show_not_spam_button_folder = array($sb_show_not_spam_button_folder);


   $spam_links = array();
   $passed_ent_id = 0;
   sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
   sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
   sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
   sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
   sqgetGlobalVar('view_as_html',  $view_as_html,  SQ_FORM);
   sqgetGlobalVar('account',       $account,       SQ_FORM);


   sq_change_text_domain('spam_buttons');

//TODO: create tooltip with more verbose explanation 
   // do not show buttons if the report-by-move-to-folder method
   // has been configured and $passed_ent_id is non-zero (can't
   // move an attachment)... and of course, not if in (one of) the
   // spam/ham folder(s) (unless in (one of) the ham/spam folder(s))
   // or if message is tagged as spam/ham
   //
   if ($show_is_spam_button 
    && (in_array($mailbox, $sb_show_spam_button_folder)
     || (empty($sb_show_spam_button_folder) 
      && !in_array($mailbox, $sb_suppress_spam_button_folder)))
    && !current_message_is_tagged(TRUE)
    && !($sb_report_spam_by_move_to_folder && !empty($passed_ent_id)))
      $spam_links[] = array('URL' => sqm_baseuri() 
         . 'src/read_body.php?isSpam=yslnk&mailbox=' 
         . urlencode($mailbox) . '&passed_id=' . $passed_id . '&view_as_html='
         . $view_as_html . '&startMessage=' . $startMessage . '&passed_ent_id=' 
         . $passed_ent_id . '&account=' . $account, 
         'Text' => _($spam_button_text));
   
   if ($show_not_spam_button
    && (in_array($mailbox, $sb_show_not_spam_button_folder)
     || (empty($sb_show_not_spam_button_folder) 
      && !in_array($mailbox, $sb_suppress_not_spam_button_folder)))
    && !current_message_is_tagged(FALSE)
    && !($sb_report_not_spam_by_move_to_folder && !empty($passed_ent_id)))
      $spam_links[] = array('URL' => sqm_baseuri() 
         . 'src/read_body.php?notSpam=yslnk&mailbox='
         . urlencode($mailbox) . '&passed_id=' . $passed_id . '&view_as_html='
         . $view_as_html . '&startMessage=' . $startMessage . '&passed_ent_id=' 
         . $passed_ent_id . '&account=' . $account, 
         'Text' => _($not_spam_button_text));

   if (check_sm_version(1, 5, 2))
      $links = array_merge($links, $spam_links);

   else
   {
      foreach ($spam_links as $link)
         echo ' | <a href="' . $link['URL'] . '">' . $link['Text'] . '</a>';
   }

   sq_change_text_domain('squirrelmail');

}



/**
  * Adds spam/ham buttons to mailbox listing
  *
  */
function sb_mailbox_list_buttons_do(&$buttons)
{

   include_once(SM_PATH . 'plugins/spam_buttons/functions.php');

   global $show_spam_buttons_on_message_list;

   spam_buttons_init();

   if (!$show_spam_buttons_on_message_list)
      return;

   if (check_sm_version(1, 5, 1))
   {
      get_spam_buttons($buttons);
   }
   else
   {
      $temp = '';
      echo get_spam_buttons($temp);
   }

}



/**
  * Adds spam/ham buttons to message display 
  * (currently only useful in 1.5.x)
  *
  */
function sb_read_message_buttons_do($args)
{

   include_once(SM_PATH . 'plugins/spam_buttons/functions.php');

   global $show_spam_buttons_on_read_body;

   spam_buttons_init();

   if (!$show_spam_buttons_on_read_body)
      return;


   if (check_sm_version(1, 5, 2))
   {
//TODO: 1.5.2 should change the API for the buttons on the read message screen, then this code will have to change to suit
      global $oTemplate;

      sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
      sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
      sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
      sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
      sqgetGlobalVar('view_as_html',  $view_as_html,  SQ_FORM);
      sqgetGlobalVar('account',       $account,       SQ_FORM);

      $buttons = array();
      get_spam_buttons($buttons, TRUE); 

      $oTemplate->assign('buttons', $buttons);
      $oTemplate->assign('mailbox', $mailbox);
      $oTemplate->assign('passed_id', $passed_id);
      $oTemplate->assign('passed_ent_id', $passed_ent_id);
      $oTemplate->assign('startMessage', $startMessage);
      $oTemplate->assign('view_as_html', $view_as_html);
      $oTemplate->assign('account', $account);

      $output = $oTemplate->fetch('plugins/spam_buttons/read_menubar_buttons.tpl');

      return array('read_body_menu_buttons_bottom' => $output,
                   'read_body_menu_buttons_top' => $output);
   }


   // as of SM version 1.5.0, this works a little differently
   //
   else if (check_sm_version(1, 5, 0))
   {

      sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
      sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
      sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
      sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
      sqgetGlobalVar('view_as_html',  $view_as_html,  SQ_FORM);

      // add spam buttons after delete stuff
      //
      $temp = '';
      $args[1] = preg_replace('/<\/td>/', 
                 '<form method="post" style="display: inline">' 
               . get_spam_buttons($temp, TRUE) 
               . '<input type="hidden" name="mailbox" value="' . $mailbox . '" />'
               . '<input type="hidden" name="msg[0]" value="' . $passed_id . '" />'
               . '<input type="hidden" name="passed_ent_id" value="' . $passed_ent_id . '" />'
               . '<input type="hidden" name="view_as_html" value="' . $view_as_html . '" />'
               . '<input type="hidden" name="startMessage" value="' . $startMessage . '" />'
               . '</form></td>', $args[1], 1);
   
      return $args;

   }


   // all older versions...  way too much trouble, especially if 
   // preview pane is in use; read_body_header_right will be 
   // sufficient
   //
   else
   {

      return;

   }


}



/**
  * Determine if the current message being viewed is spam or ham
  *
  * If the configuration items related to this functionality are
  * not set, or we are not on a message view screen, this always 
  * returns FALSE.
  *
  * @param boolean $spam When TRUE, check if the message is spam,
  *                      when FALSE, check if the message is ham.
  *
  * @return boolean TRUE if the message has been tagged as inquired
  *
  */
function current_message_is_tagged($spam)
{

   if (defined('PAGE_NAME'))
   {
      if (PAGE_NAME != 'read_body') return FALSE;
   }
   else
   {
      global $PHP_SELF;
      if (strpos($PHP_SELF, '/src/read_body') === FALSE) 
         return FALSE;
   }

   global $sb_spam_header_name, $sb_not_spam_header_name,
          $sb_spam_header_value, $sb_not_spam_header_value;

   spam_buttons_init();

   sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
   sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);

   if ($spam && !empty($sb_spam_header_name) 
    && !empty($sb_spam_header_value))
   {

      $headers = get_message_headers($passed_id, $passed_ent_id);
      foreach ($headers as $header)
         if (strtolower($header[0]) == strtolower($sb_spam_header_name . ':')
          && preg_match($sb_spam_header_value, trim($header[1])))
            return TRUE;

   }
   else if (!$spam && !empty($sb_not_spam_header_name) 
    && !empty($sb_not_spam_header_value))
   {

      $headers = get_message_headers($passed_id, $passed_ent_id);
      foreach ($headers as $header)
         if (strtolower($header[0]) == strtolower($sb_not_spam_header_name . ':')
          && preg_match($sb_not_spam_header_value, trim($header[1])))
            return TRUE;

   }

   return FALSE;

}



/**
  * Retrieve All Message Headers
  *
  * When called more than once in the same page request against the same
  * message, a cached set of headers is returned for efficiency.
  *
  * @param int    $passed_id     UID of the desired message
  * @param string $passed_ent_id Entity ID of the desired message attachment
  *
  * @return array An array of all message headers
  *
  */
function get_message_headers($passed_id, $passed_ent_id)
{

   static $parsed_headers = array();
   static $id = NULL;
   static $ent_id = NULL;

   if (!empty($parsed_headers) && $passed_id == $id && $passed_ent_id == $ent_id)
      return $parsed_headers;

   $id = $passed_id;
   $ent_id = $passed_ent_id;

   global $imapConnection, $username, $key, $uid_support,
          $mbx_response, $imapServerAddress, $imapPort, $mailbox; 

   if (check_sm_version(1, 5, 2)) { $key = FALSE; $uid_support = TRUE; }

   if (!is_resource($imapConnection))
      $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   if (empty($mbx_response))
      $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);

   if (empty($ent_id))
      $headers = sqimap_run_command($imapConnection, "FETCH $id BODY[HEADER]", true, $response, $message, $uid_support);
   else
      $headers = sqimap_run_command($imapConnection, "FETCH $id BODY[$ent_id.HEADER]", true, $response, $message, $uid_support);


   // based on src/view_header.php...
   //
   $first = $second = array();
   $cnum = 0;

   for ($i=1; $i < count($headers); $i++) 
   {
      $line = $headers[$i];
      switch (true) 
      {
         case (eregi("^&gt;", $line)):
            $second[$i] = $line;
            $first[$i] = '&nbsp;';
            $cnum++;
            break;
         case (eregi("^[ |\t]", $line)):
            $second[$i] = $line;
            $first[$i] = '';
            break;
         case (eregi("^([^:]+):(.+)", $line, $regs)):
            $first[$i] = $regs[1] . ':';
            $second[$i] = $regs[2];
            $cnum++;
            break;
         default:
            $second[$i] = trim($line);
            $first[$i] = '';
            break;
      }
   }

   for ($i=0; $i < count($second); $i = $j) 
   {
      $f = (isset($first[$i]) ? $first[$i] : '');
      $s = (isset($second[$i]) ? $second[$i] : '');
      $j = $i + 1;
      while (($first[$j] == '') && ($j < count($first))) 
      {
         $s .= ' ' . $second[$j];
         $j++;
      }
      if ($f) 
         $parsed_headers[] = array($f,$s);
   }

   return $parsed_headers;

}



