<?php

/**
  * SquirrelMail Spam Buttons Plugin
  * Copyright (c) 2005-2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage spam_buttons
  *
  * See below, starting with "GENERAL OPTIONS" for the beginning 
  * of the configuration section.
  *
  */

global $show_spam_buttons_on_read_body, $show_spam_buttons_on_message_list,
       $show_spam_link_on_read_body, $is_spam_shell_command, $is_spam_resend_destination,
       $is_not_spam_shell_command, $is_not_spam_resend_destination,
       $show_not_spam_button, $spam_button_text, $not_spam_button_text,
       $spam_report_email_method, $is_spam_subject_prefix, $is_not_spam_subject_prefix,
       $show_is_spam_button, $spam_report_smtpServerAddress, $spam_report_smtpPort,
       $spam_report_useSendmail, $spam_report_smtp_auth_mech, $spam_report_use_smtp_tls,
       $sb_debug, $sb_reselect_messages, $sb_reselect_messages_allow_override,
       $sb_delete_after_report, $sb_delete_after_report_allow_override,
       $sb_move_after_report_spam, $sb_move_after_report_spam_allow_override,
       $sb_move_after_report_not_spam, $sb_move_after_report_not_spam_allow_override,
       $sb_report_spam_by_move_to_folder, $sb_report_not_spam_by_move_to_folder,
       $sb_copy_after_report_spam_allow_override, $sb_copy_after_report_spam,
       $sb_copy_after_report_not_spam_allow_override, $sb_copy_after_report_not_spam,
       $sb_report_spam_by_copy_to_folder, $sb_report_not_spam_by_copy_to_folder,
       $sb_suppress_spam_button_folder, $sb_suppress_not_spam_button_folder,
       $sb_suppress_spam_button_folder_allow_override,
       $sb_suppress_not_spam_button_folder_allow_override,
       $sb_spam_header_name, $sb_not_spam_header_name,
       $sb_spam_header_value, $sb_not_spam_header_value,
       $sb_show_spam_button_folder, $sb_show_spam_button_folder_allow_override,
       $sb_show_not_spam_button_folder, $sb_show_not_spam_button_folder_allow_override,
       $reported_spam_text, $reported_not_spam_text,
       $sb_move_to_other_message_after_report, $sb_auto_create_destination_folder,
       $sb_move_to_other_message_after_report_allow_override;



// -------------------------------------------------------------------
//
// GENERAL OPTIONS
//


// You may change the button text, but if you do, there is a good
// chance that those buttons will ONLY be displayed in one language
// (unless you add your own translations to your locale files)
//
$spam_button_text = 'Spam';
$not_spam_button_text = 'Not Spam';



// You may change the report confirmation text, but if you do, there 
// is a good chance that those buttons will ONLY be displayed in one 
// language (unless you add your own translations to your locale files)
//
$reported_spam_text = 'Successfully reported as spam';
$reported_not_spam_text = 'Successfully reported as non-spam';



// You can turn either of the buttons on/off as needed
//
// 0 = don't display button, 1 = display button
//
$show_not_spam_button = 1;
$show_is_spam_button = 1;



// Show spam buttons on message list page?
//
// 0 = no, 1 = yes
//
$show_spam_buttons_on_message_list = 1;



// Show spam link when reading a message?
//
// 0 = no, 1 = yes
//
$show_spam_link_on_read_body = 1;



// Show spam buttons when reading a message?
//
// NOTE: This is only functional as of 
//       SquirrelMail 1.5.0
//
// 0 = no, 1 = yes
//
$show_spam_buttons_on_read_body = 1;



// When viewing an individual message, this plugin can determine if
// it was tagged as spam or ham by your anti-spam scanner if a certain
// header ($sb_spam_header_name) is added to the message.  By comparing 
// the value of that header to what is configured here 
// ($sb_spam_header_value), this plugin can display only the HAM (not 
// spam) button on messages marked as spam, or the SPAM button on messages 
// marked as ham (not spam), or both buttons otherwise.
//
// When in use, this functionality will override 
// $sb_suppress_spam_button_folder, $sb_suppress_not_spam_button_folder
// $sb_show_spam_button_folder and $sb_show_not_spam_button_folder
// (buttons/links displayed in the read-message screen will be based on
// the message headers and NOT what folder the message is in).
//
// Note that $sb_spam_header_name and $sb_not_spam_header_name are usually 
// the same thing in most spam scanner systems.
//
// The values for $sb_spam_header_value and $sb_not_spam_header_value
// are regular expressions that will be used to compare the actual 
// message header values.
//
// $sb_spam_header_name = 'X-Spam-Status';
// $sb_spam_header_value = '/^Yes/i';
// $sb_not_spam_header_name = 'X-Spam-Status';
// $sb_not_spam_header_value = '/^No/i';
//
$sb_spam_header_name = '';
$sb_spam_header_value = '';
$sb_not_spam_header_name = '';
$sb_not_spam_header_value = '';



// When any one of the report-by-move/copy or move/copy-after-report
// options is set to a folder that does not exist for any one user,
// should it be created automatically?  If not, an error will occur
// when the user reports spam/ham.
//
// 0 = don't create folders automatically
// 1 = create folders if they do not exist upon spam/ham report
//
$sb_auto_create_destination_folder = 0;



// Debugging: Turning this on will dump out the command text, the
//            message body and the results of the spam report if
//            done using a shell command.
//            If reported via email (attachment method only), you 
//            currently only get the destination address and a 
//            parsed version of the message body being reported.
//
// Note that you will get more verbose output from a sa-learn
// command if you add the -D flag to the commands below (make sure
// to remove it when you are done debugging!).
//
// 0 = off, 1 = on
//
$sb_debug = 0;



// -------------------------------------------------------------------
//
// BUTTON/LINK SUPPRESSION OPTIONS
//


// When the user is in this folder (or folders), suppress
// all SPAM button/links
//
// Set to an empty list to show the spam button in all folders, 
// or the exact name of the specified spam folder(s) (the format
// of which may depend on your IMAP server).
//
// In the case of collision with $sb_show_spam_button_folder 
// (see below), this setting will lose.
//
// $sb_suppress_spam_button_folder = array('INBOX.Spam');
// $sb_suppress_spam_button_folder = array('INBOX.Spam', 'INBOX.Junk');
//
$sb_suppress_spam_button_folder = array();



// Should users be able to choose what the value
// of $sb_suppress_spam_button_folder is?  Set to 1
// if so, or set to 0 (zero) if the administrator's
// setting above goes for all users.
//
$sb_suppress_spam_button_folder_allow_override = 1;



// When the user is in this folder (or folders), suppress 
// all HAM (not spam) button/links
//
// Set to an empty list to show the ham button in all folders,
// or the exact name of the specified ham folder(s) (the format
// of which may depend on your IMAP server).
//
// In the case of collision with $sb_show_not_spam_button_folder 
// (see below), this setting will lose.
//
// $sb_suppress_not_spam_button_folder = array('INBOX.Ham');
// $sb_suppress_not_spam_button_folder = array('INBOX.Ham', 'INBOX.Personal');
//
$sb_suppress_not_spam_button_folder = array();



// Should users be able to choose what the value
// of $sb_suppress_not_spam_button_folder is?  Set to 1 
// if so, or set to 0 (zero) if the administrator's 
// setting above goes for all users.
// 
$sb_suppress_not_spam_button_folder_allow_override = 0;



// -------------------------------------------------------------------
//
// BUTTON/LINK INCLUSION OPTIONS
//


// Only when the user is in this folder (or folders), 
// show SPAM button/links
//
// When this option is set to anything other than an
// empty list, spam buttons/links won't be shown in
// any folder other than the one(s) specified here.
//
// In the case of collision with 
// $sb_suppress_spam_button_folder, this setting will win.
//
// If set, this value must contain the exact name(s) 
// of the specified folder(s) (the format of which 
// may depend on your IMAP server).
//
// $sb_show_spam_button_folder = array('INBOX.Ham');
// $sb_show_spam_button_folder = array('INBOX.Ham', 'INBOX.Personal');
//
$sb_show_spam_button_folder = array();



// Should users be able to choose what the value
// of $sb_show_spam_button_folder is?  Set to 1
// if so, or set to 0 (zero) if the administrator's
// setting above goes for all users.
//
$sb_show_spam_button_folder_allow_override = 0;



// Only when the user is in this folder (or folders), 
// show HAM (not spam) button/links
//
// When this option is set to anything other than an
// empty list, ham buttons/links won't be shown in
// any folder other than the one(s) specified here.
//
// In the case of collision with 
// $sb_suppress_not_spam_button_folder, this setting will win.
//
// If set, this value must contain the exact name(s) 
// of the specified folder(s) (the format of which 
// may depend on your IMAP server).
//
// $sb_show_not_spam_button_folder = array('INBOX.Spam');
// $sb_show_not_spam_button_folder = array('INBOX.Spam', 'INBOX.Junk');
//
$sb_show_not_spam_button_folder = array();



// Should users be able to choose what the value
// of $sb_show_not_spam_button_folder is?  Set to 1
// if so, or set to 0 (zero) if the administrator's
// setting above goes for all users.
//
$sb_show_not_spam_button_folder_allow_override = 1;



// -------------------------------------------------------------------
//
// POST-REPORT OPTIONS
//


// When reporting spam (NOT ham), should messages
// be deleted afterward?
//
// NOTE that this will be ignored if $sb_move_after_report_spam
// (or the user-overridden value for such) is turned on.
//
// NOTE that when using the move-to-folder type 
// reporting method, this feature will be disabled.
//
// 0 = no, 1 = yes
//
$sb_delete_after_report = 0;



// Should users be able to choose what the value
// of $sb_delete_after_report is?  Set to 1 if so,
// or set to 0 (zero) if the administrator's 
// setting above goes for all users.
// 
$sb_delete_after_report_allow_override = 1;



// When reporting spam, should messages be moved
// to another folder afterward?
//
// Set to an empty string to disable, or the exact
// name of the target folder (the format of which
// may depend on your IMAP server).
//
// NOTE that this will take precedence over 
// $sb_delete_after_report.
//
// NOTE that when using the move-to-folder type 
// reporting method, this feature will be disabled.
//
// $sb_move_after_report_spam = 'INBOX.Spam';
//
$sb_move_after_report_spam = '';



// Should users be able to choose what the value
// of $sb_move_after_report_spam is?  Set to 1 if so,
// or set to 0 (zero) if the administrator's 
// setting above goes for all users.
// 
$sb_move_after_report_spam_allow_override = 1;



// Should $sb_move_after_report_spam COPY reported
// messages instead of moving them?
//
// 0 = no, just move messages, 1 = yes, copy messages
//
// This setting has no effect when 
// $sb_move_after_report_spam is not enabled.
//
$sb_copy_after_report_spam = 0;



// Should users be able to choose what the value
// of $sb_copy_after_report_spam is?  Set to 1 if so,
// or set to 0 (zero) if the administrator's 
// setting above goes for all users.
// 
$sb_copy_after_report_spam_allow_override = 1;



// When reporting non-spam, should messages be moved
// to another folder afterward?
//
// Set to an empty string to disable, or the exact
// name of the target folder (the format of which
// may depend on your IMAP server).
//
// NOTE that when using the move-to-folder type 
// reporting method, this feature will be disabled.
//
// $sb_move_after_report_not_spam = 'INBOX.Ham';
//
$sb_move_after_report_not_spam = '';



// Should users be able to choose what the value
// of $sb_move_after_report_not_spam is?  Set to 1 if so,
// or set to 0 (zero) if the administrator's
// setting above goes for all users.
//
$sb_move_after_report_not_spam_allow_override = 1;



// Should $sb_move_after_report_not_spam COPY reported
// messages instead of moving them?
//
// 0 = no, just move messages, 1 = yes, copy messages
//
// This setting has no effect when 
// $sb_move_after_report_not_spam is not enabled.
//
$sb_copy_after_report_not_spam = 0;



// Should users be able to choose what the value
// of $sb_copy_after_report_not_spam is?  Set to 1 if so,
// or set to 0 (zero) if the administrator's 
// setting above goes for all users.
// 
$sb_copy_after_report_not_spam_allow_override = 1;



// When selecting messages to report from the
// message list page, the messages will be re-
// selected after they are reported (as of 
// SquirrelMail 1.4.11 and 1.5.2).  You can turn
// this functionality off by setting this to zero.
//
$sb_reselect_messages = 1;



// Should users be able to choose what the value
// of $sb_reselect_messages is?  Set to 1 if so,
// or set to 0 (zero) if the administrator's 
// setting above goes for all users.
// 
$sb_reselect_messages_allow_override = 1;



// When either report-by-move or delete-after-report is
// enabled, should the user be directed to the next or
// previous message after the report, or just back to
// the message list?
//
// Acceptable values are "next", "previous" and "" (empty),
// which indicates that the user will be returned to the
// message list.
//
// $sb_move_to_other_message_after_report = 'next';
// $sb_move_to_other_message_after_report = 'previous';
// $sb_move_to_other_message_after_report = '';
//
$sb_move_to_other_message_after_report = '';



// Should users be able to choose what the value
// of $sb_move_to_other_message_after_report is?  
// Set to 1 if so, or set to 0 (zero) if the 
// administrator's setting above goes for all users.
//
$sb_move_to_other_message_after_report_allow_override = 1;



// -------------------------------------------------------------------
//
// REPORT BY MOVE-TO-FOLDER OPTIONS
//
// Be sure if you use this that you have NOT turned on 
// reporting by email or by shell command.
//


// This reporting method does not acutually make any reports itself.
// Instead, the message is moved to the specified folder and some
// other process is assumed to examine the messages in that folder
// on a regular basis.  
//
// If you enable this reporting method, the report-and-delete and
// report-and-move functions above will be automatically disabled.
//
// You will need to set these values to the exact name of the target
// folders where messages will be moved.  The format of the folder
// names may depend on your IMAP server.
//
// $sb_report_spam_by_move_to_folder = 'INBOX.Spam';
// $sb_report_not_spam_by_move_to_folder = 'INBOX.Ham';
//
$sb_report_spam_by_move_to_folder = '';
$sb_report_not_spam_by_move_to_folder = '';



// If messages should be copied instead of moved, set either of these
// settings to 1.  Leave as 0 (zero) if messages should be moved.
//
// Note that these settings have no effect if their counterparts
// above are not enabled. 
//
$sb_report_spam_by_copy_to_folder = 0;
$sb_report_not_spam_by_copy_to_folder = 0;



// -------------------------------------------------------------------
//
// REPORT-BY-SHELL COMMAND OPTIONS
//
// Be sure if you use this that you have NOT turned on 
// reporting by email or by move-to-folder.
//


// If you use a command-line utility for reporting spam/non-spam, 
// this is where you set it up.  This plugin will append " < message"
// to the end of such a command (without the quotes), where "message" 
// will be a file containing the full message as it was originally 
// received.
//
// If you need to include any information about the user for which
// the report is being made, you can use these constants in your command:
//
//    ###EMAIL_ADDRESS###            Will be replaced with the user's 
//                                   full email address
//
//    ###USERNAME###                 Will be replaced with the username
//                                   portion of the user's email address
//
//    ###DOMAIN###                   Will be replaced with the domain
//                                   portion of the user's email address
//
//
//
// Note that you are not necessarily limited to just calling a spam
// reporting application; you can also do clever things such as dump
// the message to a file that can be used to do cron-based reporting
// at a later time.  For example:
//
// $is_spam_shell_command     = 'cat >> /path/to/spam-###EMAIL_ADDRESS###';
// $is_not_spam_shell_command = 'cat >> /path/to/ham-###EMAIL_ADDRESS###';
//
//
//
// Sample for Bogofilter:
//
// $is_spam_shell_command = 'HOME=/home/###USERNAME### sudo -u ###USERNAME### /usr/bin/bogofilter -s';
// $is_not_spam_shell_command = 'HOME=/home/###USERNAME### sudo -u ###USERNAME### /usr/bin/bogofilter -n';
//
//
//
// Sample for CRM114:
//
// $is_spam_shell_command = '/usr/bin/crm -u /home/crm114 mailfilter.crm --learnspam';
// $is_not_spam_shell_command = '/usr/bin/crm -u /home/crm114 mailfilter.crm --learnnonspam';
//
//
//
// Sample for DSPAM:
//
// $is_spam_shell_command = '/usr/local/bin/dspam --user ###EMAIL_ADDRESS### --mode=teft --class=spam --source=error --client';
// $is_not_spam_shell_command = '/usr/local/bin/dspam --user ###EMAIL_ADDRESS### --mode=teft --class=innocent --source=error --client';
//
//
//
// Sample for SpamAssassin:
//
// $is_spam_shell_command = '/usr/bin/sa-learn --spam --configpath=/etc/spamassassin -p /root/.spamassassin/user_prefs';
// $is_not_spam_shell_command = '/usr/bin/sa-learn --ham --configpath=/etc/spamassassin -p /root/.spamassassin/user_prefs';
//
//
//
// Sample for SpamAssassin per-user configuration:
//
// $is_spam_shell_command = '/usr/bin/sa-learn --spam --username=###EMAIL_ADDRESS###';
// $is_not_spam_shell_command = '/usr/bin/sa-learn --ham --username=###EMAIL_ADDRESS###';
//
//
//
// Sample for SpamAssassin per-user configuration using spamc/spamd:
//
// $is_spam_shell_command = '/usr/bin/spamc -L spam -d localhost -u ###EMAIL_ADDRESS###';
// $is_not_spam_shell_command = '/usr/bin/spamc -L ham -d localhost -u ###EMAIL_ADDRESS###';
//
//
//
// Advanced sample for SpamAssassin:
//
// In order to make sure you are running sa-learn (or equivalent) as the correct user 
// (else it will be run as the user that your web server runs as), you may need to run 
// the command with sudo.  In /etc/sudoers, you will want to set this:
//
// web_server_user   ALL=(sa_user) NOPASSWD: /usr/bin/sa-learn, /usr/bin/spamassassin, /usr/bin/spamc
//
// Where you need to change "web_server_user" to the actual userID of the user running
// your web server, and "sa_user" to the user that should run sa-learn (or spamassasin
// or spamc).
//
// After that, one of the following command pairs should work for you (remember to 
// replace "sa_user" with the correct username):
//
// $is_spam_shell_command = 'sudo -u sa_user /usr/bin/sa-learn --spam';
// $is_not_spam_shell_command = 'sudo -u sa_user /usr/bin/sa-learn --ham';
//
// $is_spam_shell_command = 'sudo -u sa_user /usr/bin/spamassassin -r --configpath=/etc/spamassassin -p /root/.spamassassin/user_prefs';
// $is_not_spam_shell_command = 'sudo -u sa_user /usr/bin/spamassassin -k --configpath=/etc/spamassassin -p /root/.spamassassin/user_prefs';
//
// $is_spam_shell_command = 'sudo -u sa_user /usr/bin/spamc -L spam';
// $is_not_spam_shell_command = 'sudo -u sa_user /usr/bin/spamc -L ham';
//
//
//
$is_spam_shell_command = '';
$is_not_spam_shell_command = '';



// -------------------------------------------------------------------
//
// REPORT-BY-EMAIL OPTIONS
//
// Be sure if you use this that you have NOT turned on 
// reporting by shell command or by move-to-folder.
//


// If you resend the message in order to report it as spam/non-spam,
// specify the destination address here.
//
// If you need to include any information about the user for which
// the report is being made, you can use these constants in the 
// destination address:
//
//    ###EMAIL_ADDRESS###            Will be replaced with the user's 
//                                   full email address
//
//    ###USERNAME###                 Will be replaced with the username
//                                   portion of the user's email address
//
//    ###DOMAIN###                   Will be replaced with the domain
//                                   portion of the user's email address
//
//
// $is_spam_resend_destination = 'spam_report';  // let SM append user's domain automatically
// $is_not_spam_resend_destination = 'not_spam_report';
//
// $is_spam_resend_destination = 'spam-###USERNAME###@###DOMAIN###'; 
// $is_not_spam_resend_destination = 'ham-###USERNAME###@###DOMAIN###';
//
$is_spam_resend_destination = '';
$is_not_spam_resend_destination = '';



// When reporting via email, should the message be resent (leaving
// all message headers intact), or should it be sent as an attachment?
//
// resend = 'bounce'
// attach = 'attachment'
//
// $spam_report_email_method = 'bounce';
//
$spam_report_email_method = 'attachment';



// When reporting via email (at least when sending as attachment), you
// may indicate any extra subject information here (default empty)
//
// When set to "SPAM", the subject might end up looking like "[SPAM: Buy our product!]"
//
$is_spam_subject_prefix = 'SPAM';
$is_not_spam_subject_prefix = 'HAM';



// You may also specify overrides for the SMTP server for the 
// email only (see SquirrelMail's main configuration file or
// use config/conf.pl to understand what these settings normally
// are).
//
// Set to empty strings to use system defaults.
//
$spam_report_smtpServerAddress = '';
$spam_report_smtpPort = '';
$spam_report_useSendmail = '';
$spam_report_smtp_auth_mech = '';
$spam_report_use_smtp_tls = '';



