<?php

/**
  * SquirrelMail Spam Buttons Plugin
  * Copyright (c) 2005-2007 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage spam_buttons
  *
  */



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function spam_buttons_init()
{

   if (!@include_once(SM_PATH . 'plugins/spam_buttons/config.php'))
      return FALSE;

   return TRUE;

}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function spam_buttons_check_configuration_do()
{

   global $is_spam_resend_destination, $is_not_spam_resend_destination,
          $is_spam_shell_command, $is_not_spam_shell_command,
          $show_not_spam_button, $show_is_spam_button,
          $sb_report_spam_by_move_to_folder,
          $sb_report_not_spam_by_move_to_folder;


   // make sure base config is available
   //
   if (!spam_buttons_init())
   {
      do_err('Spam Buttons plugin is missing its main configuration file', FALSE);
      return TRUE;
   }


   $spam_methods = 0;
   if (!empty($sb_report_spam_by_move_to_folder)) $spam_methods++;
   if (!empty($is_spam_shell_command)) $spam_methods++;
   if (!empty($is_spam_resend_destination)) $spam_methods++;

   $ham_methods = 0;
   if (!empty($sb_report_not_spam_by_move_to_folder)) $ham_methods++;
   if (!empty($is_not_spam_shell_command)) $ham_methods++;
   if (!empty($is_not_spam_resend_destination)) $ham_methods++;


   // make sure "Is Spam" reporting method is properly configured
   //
   if ($show_is_spam_button && $spam_methods == 0)
   {
      do_err('Spam Buttons plugin is configured to show the "Is Spam" button, but there is no reporting method configured.  Please specify either $sb_report_spam_by_move_to_folder, $is_spam_shell_command or $is_spam_resend_destination', FALSE);
      return TRUE;
   }


   // make sure "Is Not Spam" reporting method is properly configured
   //
   if ($show_not_spam_button && $ham_methods == 0)
   {
      do_err('Spam Buttons plugin is configured to show the "Is Not Spam" button, but there is no reporting method configured.  Please specify either $sb_report_not_spam_by_move_to_folder, $is_not_spam_shell_command or $is_not_spam_resend_destination', FALSE);
      return TRUE;
   }


   // make sure "Is Spam" reporting method is not "overly" configured
   //
   if ($show_is_spam_button && $spam_methods > 1)
   {
      do_err('Spam Buttons plugin is configured to show the "Is Spam" button, but more than one reporting method has been specified.  Please choose $sb_report_spam_by_move_to_folder, $is_spam_shell_command or $is_spam_resend_destination, but not more than one', FALSE);
      return TRUE;
   }


   // make sure "Is Not Spam" reporting method is not "overly" configured
   //
   if ($show_not_spam_button && $ham_methods > 1)
   {
      do_err('Spam Buttons plugin is configured to show the "Is Not Spam" button, but more than one reporting method has been specified.  Please choose $sb_report_not_spam_by_move_to_folder, $is_not_spam_shell_command or $is_not_spam_resend_destination, but not more than one', FALSE);
      return TRUE;
   }



   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // 1.4.10+ gets a pass on Compatibility plugin
      //
      if (check_sm_version(1, 5, 0) || !check_sm_version(1, 4, 10))
      {

         // try to find Compatibility, and then that it is v2.0.7+
         //
         if (function_exists('check_plugin_version')
          && check_plugin_version('compatibility', 2, 0, 7, TRUE))
            return FALSE;


         // something went wrong
         //
         do_err('Spam Buttons plugin requires the Compatibility plugin version 2.0.7+', FALSE);
         return TRUE;

      }

   }


   // check for exec being disabled
   //
   $disable_functions = explode(',', ini_get('disable_functions'));
   if (in_array('exec', $disable_functions)
    && (!empty($is_spam_shell_command) || !empty($is_not_spam_shell_command)))
   {
      do_err('You have disabled the "exec" command in your PHP configuration and are using the report-by-shell-command method for the Spam Buttons plugin.  Spam and/or Ham reports will not work until you fix one or the other.', FALSE);
      return TRUE;
   }


   // check for problems when in safe_mode
   //
   if (ini_get('safe_mode') 
    && (!empty($is_spam_shell_command) || !empty($is_not_spam_shell_command)))
   {
      $safe_mode_exec_dir = ini_get('safe_mode_exec_dir');
      do_err('You have safe_mode enabled in your PHP configuration and are using the report-by-shell-command method for the Spam Buttons plugin.  Please double check that your reporting command is in an allowable directory and has ownership that allows access by the web server.  (Your safe_mode_exec_dir is "' . $safe_mode_exec_dir . '".)', FALSE);
      return FALSE;
   }


   return FALSE;

}



/**
  * Display user configuration options on display preferences page
  *
  */
function spam_buttons_display_options_do()
{

   global $data_dir, $username, $sb_reselect_messages, 
          $sb_reselect_messages_allow_override, $optpage_data,
          $sb_delete_after_report, $sb_delete_after_report_allow_override,
          $sb_move_after_report_spam, $sb_move_after_report_spam_allow_override,
          $sb_move_after_report_not_spam, 
          $sb_move_after_report_not_spam_allow_override,
          $sb_report_spam_by_move_to_folder, 
          $sb_report_not_spam_by_move_to_folder,
          $sb_copy_after_report_spam_allow_override, $sb_copy_after_report_spam,
          $sb_copy_after_report_not_spam_allow_override, 
          $sb_copy_after_report_not_spam, $sb_suppress_spam_button_folder,
          $sb_suppress_not_spam_button_folder,
          $sb_suppress_spam_button_folder_allow_override,
          $sb_suppress_not_spam_button_folder_allow_override;

   spam_buttons_init();

   sq_change_text_domain('spam_buttons');

   $my_optpage_values = array();

   if ($sb_reselect_messages_allow_override 
    && check_sm_version(1, 4, 11)
    && (empty($sb_report_spam_by_move_to_folder) 
      || empty($sb_report_not_spam_by_move_to_folder)))
   {
      $sb_reselect_messages = getPref($data_dir, $username, 
                                      'sb_reselect_messages', $sb_reselect_messages);
      $my_optpage_values[] = array(
         'name'          => 'sb_reselect_messages',
         'caption'       => _("Reselect Messages After Reporting"),
         'type'          => SMOPT_TYPE_BOOLEAN,
         'initial_value' => $sb_reselect_messages,
         'refresh'       => SMOPT_REFRESH_NONE,
      );
   }


   if ($sb_delete_after_report_allow_override 
    && empty($sb_report_spam_by_move_to_folder))
   {
      $sb_delete_after_report = getPref($data_dir, $username, 
                                        'sb_delete_after_report', $sb_delete_after_report);
      $my_optpage_values[] = array(
         'name'          => 'sb_delete_after_report',
         'caption'       => _("Delete Spam After Reporting"),
         'type'          => SMOPT_TYPE_BOOLEAN,
         'initial_value' => $sb_delete_after_report,
         'refresh'       => SMOPT_REFRESH_NONE,
      );
   }


   $boxes = array();
   if ($sb_move_after_report_spam_allow_override 
    && empty($sb_report_spam_by_move_to_folder))
   {

      // Get folder list
      //
      global $username, $key, $imapServerAddress, $imapPort, $data_dir;
      if (check_sm_version(1, 5, 2))
      { 
         $key = FALSE; 
         include_once(SM_PATH . 'functions/imap_general.php'); 
      }
      $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
      $boxes = sqimap_mailbox_list($imapConnection);
      array_unshift($boxes, array('unformatted-disp' => _("[Do not move]"),
                                  'formatted' => _("[Do not move]"),
                                  'unformatted-dm' => 0,
                                  'unformatted' => 0,
                                  'raw' => '', 
                                  'id' => 0, 
                                  'flags' => array()));
      sqimap_logout($imapConnection);

      $sb_move_after_report_spam = getPref($data_dir, $username, 
                                           'sb_move_after_report_spam', 
                                           $sb_move_after_report_spam);

      if ($sb_copy_after_report_spam && !$sb_copy_after_report_spam_allow_override)
         $opt_caption = _("Copy Spam After Reporting To");
      else
         $opt_caption = _("Move Spam After Reporting To");

      $my_optpage_values[] = array(
         'name'          => 'sb_move_after_report_spam',
         'caption'       => $opt_caption,
         'type'          => SMOPT_TYPE_FLDRLIST,
         'posvals'       => array('ignore' => $boxes),
         'initial_value' => $sb_move_after_report_spam,
         'refresh'       => SMOPT_REFRESH_NONE,
      );


      // add "copy instead of move" selection if needed
      //
      if ($sb_copy_after_report_spam_allow_override) 
      {
         $sb_copy_after_report_spam = getPref($data_dir, $username, 
                                              'sb_copy_after_report_spam', 
                                              $sb_copy_after_report_spam);
         $my_optpage_values[] = array(
            'name'          => 'sb_copy_after_report_spam',
            'caption'       => _("Copy Instead of Moving"),
            'type'          => SMOPT_TYPE_BOOLEAN,
            'initial_value' => $sb_copy_after_report_spam,
            'refresh'       => SMOPT_REFRESH_NONE,
         );
      }

   }


   if ($sb_move_after_report_not_spam_allow_override 
    && empty($sb_report_not_spam_by_move_to_folder))
   {

      // Get folder list
      //
      if (empty($boxes))
      {
         global $username, $key, $imapServerAddress, $imapPort, $data_dir;
         if (check_sm_version(1, 5, 2)) 
         { 
            $key = FALSE; 
            include_once(SM_PATH . 'functions/imap_general.php'); 
         }
         $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
         $boxes = sqimap_mailbox_list($imapConnection);
         array_unshift($boxes, array('unformatted-disp' => _("[Do not move]"),
                                     'formatted' => _("[Do not move]"),
                                     'unformatted-dm' => 0,
                                     'unformatted' => 0,
                                     'raw' => '', 
                                     'id' => 0, 
                                     'flags' => array()));
         sqimap_logout($imapConnection);
      }

      $sb_move_after_report_not_spam = getPref($data_dir, $username, 
                                               'sb_move_after_report_not_spam', 
                                               $sb_move_after_report_not_spam);

      if ($sb_copy_after_report_not_spam && !$sb_copy_after_report_not_spam_allow_override)
         $opt_caption = _("Copy Non-Spam After Reporting To");
      else
         $opt_caption = _("Move Non-Spam After Reporting To");

      $my_optpage_values[] = array(
         'name'          => 'sb_move_after_report_not_spam',
         'caption'       => $opt_caption,
         'type'          => SMOPT_TYPE_FLDRLIST,
         'posvals'       => array('ignore' => $boxes),
         'initial_value' => $sb_move_after_report_not_spam,
         'refresh'       => SMOPT_REFRESH_NONE,
      );


      // add "copy instead of move" selection if needed
      //
      if ($sb_copy_after_report_not_spam_allow_override) 
      {
         $sb_copy_after_report_not_spam = getPref($data_dir, $username, 
                                                  'sb_copy_after_report_not_spam', 
                                                  $sb_copy_after_report_not_spam);
         $my_optpage_values[] = array(
            'name'          => 'sb_copy_after_report_not_spam',
            'caption'       => _("Copy Instead of Moving"),
            'type'          => SMOPT_TYPE_BOOLEAN,
            'initial_value' => $sb_copy_after_report_not_spam,
            'refresh'       => SMOPT_REFRESH_NONE,
         );
      }

   }


   if ($sb_suppress_spam_button_folder_allow_override) 
   {

      // Get folder list
      //
      if (empty($boxes))
      {
         global $username, $key, $imapServerAddress, $imapPort, $data_dir;
         if (check_sm_version(1, 5, 2)) 
         { 
            $key = FALSE; 
            include_once(SM_PATH . 'functions/imap_general.php'); 
         }
         $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
         $boxes = sqimap_mailbox_list($imapConnection);
         array_unshift($boxes, array('unformatted-disp' => _("[Always Display]"),
                                     'formatted' => _("[Always Display]"),
                                     'unformatted-dm' => 0,
                                     'unformatted' => 0,
                                     'raw' => '', 
                                     'id' => 0, 
                                     'flags' => array()));
         sqimap_logout($imapConnection);
      }
      else // remove the "Do Not Move" entry
      {
         array_shift($boxes);
         array_unshift($boxes, array('unformatted-disp' => _("[Always Display]"),
                                     'formatted' => _("[Always Display]"),
                                     'unformatted-dm' => 0,
                                     'unformatted' => 0,
                                     'raw' => '', 
                                     'id' => 0, 
                                     'flags' => array()));
      }

      $sb_suppress_spam_button_folder = getPref($data_dir, $username, 
                                                'sb_suppress_spam_button_folder', 
                                                $sb_suppress_spam_button_folder);

      $my_optpage_values[] = array(
         'name'          => 'sb_suppress_spam_button_folder',
         'caption'       => _("Don't Display Spam Button in Folder"),
         'type'          => SMOPT_TYPE_FLDRLIST,
         'posvals'       => array('ignore' => $boxes),
         'initial_value' => $sb_suppress_spam_button_folder,
         'refresh'       => SMOPT_REFRESH_NONE,
      );

   }


   if ($sb_suppress_not_spam_button_folder_allow_override)
   {

      // Get folder list
      //
      if (empty($boxes))
      {
         global $username, $key, $imapServerAddress, $imapPort, $data_dir;
         if (check_sm_version(1, 5, 2))
         {
            $key = FALSE;
            include_once(SM_PATH . 'functions/imap_general.php');
         }
         $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
         $boxes = sqimap_mailbox_list($imapConnection);
         array_unshift($boxes, array('unformatted-disp' => _("[Always Display]"),
                                     'formatted' => _("[Always Display]"),
                                     'unformatted-dm' => 0,
                                     'unformatted' => 0,
                                     'raw' => '', 
                                     'id' => 0, 
                                     'flags' => array()));
         sqimap_logout($imapConnection);
      }

      // remove the "Do Not Move" entry (but only if it's there)
      else if (!$sb_suppress_spam_button_folder_allow_override) 
      {
         array_shift($boxes);
         array_unshift($boxes, array('unformatted-disp' => _("[Always Display]"),
                                     'formatted' => _("[Always Display]"),
                                     'unformatted-dm' => 0,
                                     'unformatted' => 0,
                                     'raw' => '', 
                                     'id' => 0, 
                                     'flags' => array()));
      }

      $sb_suppress_not_spam_button_folder = getPref($data_dir, $username,
                                                'sb_suppress_not_spam_button_folder',
                                                $sb_suppress_not_spam_button_folder);

      $my_optpage_values[] = array(
         'name'          => 'sb_suppress_not_spam_button_folder',
         'caption'       => _("Don't Display Non-Spam Button in Folder"),
         'type'          => SMOPT_TYPE_FLDRLIST,
         'posvals'       => array('ignore' => $boxes),
         'initial_value' => $sb_suppress_not_spam_button_folder,
         'refresh'       => SMOPT_REFRESH_NONE,
      );

   }


   if (!empty($my_optpage_values))
   {
      $optpage_data['grps']['spam_buttons'] = _("Spam Reporting");
      $optpage_data['vals']['spam_buttons'] = $my_optpage_values;
   }

   sq_change_text_domain('squirrelmail');

}



/**
  * Takes care of spam/ham button click 
  *
  */
function sb_button_action_do($args)
{

   global $is_spam_shell_command, $is_spam_resend_destination,
          $is_not_spam_shell_command, $is_not_spam_resend_destination,
          $is_spam_subject_prefix, $is_not_spam_subject_prefix,
          $sb_reselect_messages, $sb_delete_after_report,
          $sb_reselect_messages_allow_override, $username, $data_dir,
          $sb_delete_after_report_allow_override,
          $sb_move_after_report_spam, $sb_move_after_report_spam_allow_override,
          $sb_move_after_report_not_spam, $note,
          $sb_move_after_report_not_spam_allow_override,
          $sb_report_spam_by_move_to_folder, 
          $sb_report_not_spam_by_move_to_folder,
          $sb_copy_after_report_spam_allow_override, $sb_copy_after_report_spam,
          $sb_copy_after_report_not_spam_allow_override, 
          $sb_copy_after_report_not_spam, $sb_report_spam_by_copy_to_folder, 
          $sb_report_not_spam_by_copy_to_folder,
          $reported_spam_text, $reported_not_spam_text;

   spam_buttons_init();


   if ($sb_reselect_messages_allow_override)
   {
      $sb_reselect_messages = getPref($data_dir, $username, 
                                      'sb_reselect_messages', $sb_reselect_messages);
   }
   if ($sb_delete_after_report_allow_override)
   {
      $sb_delete_after_report = getPref($data_dir, $username, 
                                        'sb_delete_after_report', $sb_delete_after_report);
   }
   if ($sb_move_after_report_spam_allow_override)
   {
      $sb_move_after_report_spam = getPref($data_dir, $username, 
                                           'sb_move_after_report_spam', 
                                           $sb_move_after_report_spam);

   }
   if ($sb_move_after_report_not_spam_allow_override)
   {
      $sb_move_after_report_not_spam = getPref($data_dir, $username, 
                                               'sb_move_after_report_not_spam', 
                                               $sb_move_after_report_not_spam);
   }
   if ($sb_copy_after_report_spam_allow_override)
   {
      $sb_copy_after_report_spam = getPref($data_dir, $username, 
                                           'sb_copy_after_report_spam', 
                                           $sb_copy_after_report_spam);
   }
   if ($sb_copy_after_report_not_spam_allow_override)
   {
      $sb_copy_after_report_not_spam = getPref($data_dir, $username, 
                                               'sb_copy_after_report_not_spam', 
                                               $sb_copy_after_report_not_spam);
   }


//sm_print_r($_GET, $_POST, $_SERVER);
//sm_print_r($_SESSION);
//exit;


   // determine if the report was done from the message view screen
   //
   // the use of get_current_hook_name() means the Compatibility plugin is required
   //
   $hook_name = get_current_hook_name($args);
   if ($hook_name == 'read_body_header' || $hook_name == 'template_construct_read_headers.tpl')
      $reporting_from_message_view = TRUE;
   else
      $reporting_from_message_view = FALSE;


   $passed_ent_id = 0;
   if (!sqgetGlobalVar('location', $location, SQ_FORM)) $location = php_self();
   sqgetGlobalVar('passed_id',       $passed_id,      SQ_FORM);
   sqgetGlobalVar('passed_ent_id',   $passed_ent_id,  SQ_FORM);
   sqgetGlobalVar('msg',             $msg,            SQ_FORM);
   sqgetGlobalVar('REQUEST_METHOD',  $method,         SQ_SERVER);


   // if in 1.4.x we need to print message 
   // to user after report, do that here
   //
   if (!check_sm_version(1, 5, 0) && sqgetGlobalVar('sb_note', $sb_note, SQ_SESSION))
   {
      echo html_tag('div', '<b>' . $sb_note .'</b>', 'center') . "<br />\n";
      sqsession_unregister('sb_note');
   }


   // pull button/link flags differently since during 
   // POST submissions, the $_GET array sticks around 
   //
   $isSpam = NULL;
   $notSpam = NULL;
   if (strtoupper($method) == 'POST')
   {
      sqgetGlobalVar('isSpam',  $isSpam,  SQ_POST);
      sqgetGlobalVar('notSpam', $notSpam, SQ_POST);
   }
   else
   {
      sqgetGlobalVar('isSpam',  $isSpam,  SQ_GET);
      sqgetGlobalVar('notSpam', $notSpam, SQ_GET);
   }


   // build message ID array if user came from one of the 
   // links on the message view page
   //
   if ($isSpam == 'yslnk' || $notSpam == 'yslnk')
      $msg = array($passed_id);


   // build list of checkboxes to be pre-selected when
   // returning to message list
   //
   $prechecked = array();
   if ($sb_reselect_messages)
// could add the following, but not absolutely necessary
//    && (empty($sb_report_spam_by_move_to_folder)
//     || empty($sb_report_not_spam_by_move_to_folder)))
   {
      if (is_array($msg)) foreach ($msg as $messageID)
         $prechecked[$messageID] = TRUE;
   }



   // if no messages were selected or spam buttons were not clicked on
   // this request, just return and let SM handle the error, if any
   //
   if (empty($msg) || (empty($isSpam) && empty($notSpam)))
      return;


   sq_change_text_domain('spam_buttons');



   $note = '';
   $success = FALSE;



//TODO: if we implement "dont_wait" functionality, we can fork a child process here; then the child uses the reporting code below and exits, but the parent needs to skip to the section a few hundred lines down where it redirects back to the message list or read-message page ("DONE, WHERE DO WE RETURN TO?").  See the TODO section of the README file for some issues regarding this kind of functioality



   // -----------------------------------------------------------------
   //
   // SPAM
   //


   // mark as spam!
   // 
   if (!empty($isSpam))
   {
   
      // move-to-folder (only when target mailbox is not the same as source mailbox)
      //
      // note that we don't have to to check for $passed_ent_id because the report
      // links/buttons are not shown when $passed_ent_id is non-zero, so we can never
      // get here
      //
      global $mailbox;
      if (!empty($sb_report_spam_by_move_to_folder)
       && $mailbox != $sb_report_spam_by_move_to_folder
       && is_array($msg))
      {

         global $auto_expunge, $imapConnection, $username, $key,
                $imapServerAddress, $imapPort;
         if (check_sm_version(1, 5, 2)) $key = FALSE; 
         if (!is_resource($imapConnection))
            $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);

         if (check_sm_version(1, 5, 2))
         {
            global $aMailbox;
            sqGetGlobalVar('lastTargetMailbox', $lastTargetMailbox, SQ_SESSION);
            if ($sb_report_spam_by_copy_to_folder)
               $note = handleMessageListForm($imapConnection, $aMailbox, 'copy', $msg, $sb_report_spam_by_move_to_folder);
            else
               $note = handleMessageListForm($imapConnection, $aMailbox, 'move', $msg, $sb_report_spam_by_move_to_folder);
            sqsession_register($lastTargetMailbox,'lastTargetMailbox');
         }
         else
         {
//TODO -- how to populate $note if an error occurs?  sqimap_msgs_list_copy() doesn't have a return value...
            if ($sb_report_spam_by_copy_to_folder)
               spam_buttons_sqimap_msgs_list_copy($imapConnection, $msg, $sb_report_spam_by_move_to_folder);
            else
               sqimap_msgs_list_copy($imapConnection, $msg, $sb_report_spam_by_move_to_folder);
            if ($auto_expunge) 
               $cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
            else 
               $cnt = 0;
         }


         if (empty($note))
         {
            $success = TRUE;
            $note = _($reported_spam_text);
//TODO? include something that identifies the message(s) that were reported(have to add it up in the loop above)?  might take too much screen real estate....?


            global $javascript_on, $username, $mbx_response, $mailbox,
                   $startMessage, $show_num, $sort, $imapConnection,
                   $key, $imapServerAddress, $imapPort, $account;
            if (check_sm_version(1, 5, 2)) $key = FALSE;
            if (empty($mbx_response))
            {
               if (!is_resource($imapConnection))
                  $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
               $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);
            }


            // when reading message itself, redirect back to
            // message list after having moved it
            //
            if ($reporting_from_message_view && $javascript_on)
            {

//TODO: this may cause problems in 1.4.x, where output is probably already started
               sqsession_register($note, 'sb_note');


               // when viewing a message in the preview pane,
               // need to clear pane after delete as well as
               // refresh message list
               //
               global $data_dir, $PHP_SELF;
               if (is_plugin_enabled('preview_pane')
                && getPref($data_dir, $username, 'use_previewPane', 0) == 1)
               {

                  // refresh message list & close
                  //
                  if (check_sm_version(1, 5, 2))
                  {
                     global $oTemplate;
                     $output = $oTemplate->fetch('plugins/spam_buttons/redirect_preview_pane.tpl');
                     return array('read_body_header' => $output);
                  }
                  else
                  {
                     global $base_uri, $t;
                     $t = array(); // no need to put config vars herein, they are already globalized
                     include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_preview_pane.tpl');
                  }

               }


               // otherwise, just calculate redirect locaiton
               // and redirect with javascript
               //
               else
               {
                  $location = sqm_baseuri() . "src/right_main.php?mailbox="
                            . urlencode($mailbox)
                            . (!empty($sort) ? "&sort=$sort" : '')
                            . (!empty($account) ? "&account=$account" : '')
                            . (!empty($startMessage) ? "&startMessage=$startMessage" : '');
                  if (check_sm_version(1, 5, 2))
                  {
                     global $oTemplate;
                     $oTemplate->assign('location', $location);
                     $output = $oTemplate->fetch('plugins/spam_buttons/redirect_standard.tpl');
                     return array('read_body_header' => $output);
                  }
                  else
                  {
                     global $t;
                     $t = array($location);
                     include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_standard.tpl');
                  }

               }

            }


            // otherwise make sure we didn't move ourselves
            // off the last page or anything like that (code copied from
            // 1.4.11 src/move_messages.php)
            //
            else if (!$reporting_from_message_view)
            {
               if (($startMessage + $cnt - 1) >= $mbx_response['EXISTS'])
               {
                  if ($startMessage > $show_num)
                     $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
                  else
                     $location = set_url_var($location,'startMessage',1, false);
               }
            }

         }

      }


      // shell command
      //
      else if (!empty($is_spam_shell_command))
      {

         $note = report_by_shell_command($is_spam_shell_command, $msg, $passed_ent_id);

         if (empty($note))
         {
            $success = TRUE;
            $note = _($reported_spam_text);
//TODO? include something that identifies the message(s) that were reported(have to add it up in the loop above)?  might take too much screen real estate....?
         }

      }


      // or just re-send elsewhere
      //
      else if (!empty($is_spam_resend_destination))
      {

         $note = report_by_email($is_spam_resend_destination, $msg, $passed_ent_id, $is_spam_subject_prefix);

         if (empty($note))
         {
            $success = TRUE;
            $note = _($reported_spam_text);
//TODO? include something that identifies the message(s) that were reported(have to add it up in the loop above)?  might take too much screen real estate....?
         }

      }


      else
//TODO: we could put a warning here for the sysadmin... (but note that it is possible to get here when report-by-move-to-folder is correctly configured but no messages were selected by the user before pressing the report button)
         $note = '';

   }



   // -----------------------------------------------------------------
   //
   // HAM
   //


   // mark as ham!
   // 
   else if (!empty($notSpam))
   {

      // move-to-folder (only when target mailbox is not the same as source mailbox)
      //
      // note that we don't have to to check for $passed_ent_id because the report
      // links/buttons are not shown when $passed_ent_id is non-zero, so we can never
      // get here
      //
      global $mailbox;
      if (!empty($sb_report_not_spam_by_move_to_folder)
       && $mailbox != $sb_report_not_spam_by_move_to_folder
       && is_array($msg))
      {

         global $auto_expunge, $imapConnection, $username, $key,
                $imapServerAddress, $imapPort;
         if (check_sm_version(1, 5, 2)) $key = FALSE;
         if (!is_resource($imapConnection))
            $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);

         if (check_sm_version(1, 5, 2))
         {
            global $aMailbox;
            sqGetGlobalVar('lastTargetMailbox', $lastTargetMailbox, SQ_SESSION);
            if ($sb_report_not_spam_by_copy_to_folder)
               $note = handleMessageListForm($imapConnection, $aMailbox, 'copy', $msg, $sb_report_not_spam_by_move_to_folder);
            else
               $note = handleMessageListForm($imapConnection, $aMailbox, 'move', $msg, $sb_report_not_spam_by_move_to_folder);
            sqsession_register($lastTargetMailbox,'lastTargetMailbox');
         }
         else
         {
//TODO -- how to populate $note if an error occurs?  sqimap_msgs_list_copy() doesn't have a return value...
            if ($sb_report_not_spam_by_copy_to_folder)
               spam_buttons_sqimap_msgs_list_copy($imapConnection, $msg, $sb_report_not_spam_by_move_to_folder);
            else
               sqimap_msgs_list_copy($imapConnection, $msg, $sb_report_not_spam_by_move_to_folder);
            if ($auto_expunge) 
               $cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
            else 
               $cnt = 0;
         }


         if (empty($note))
         {
            $success = TRUE;
            $note = _($reported_not_spam_text);
//TODO? include something that identifies the message(s) that were reported(have to add it up in the loop above)?  might take too much screen real estate....?


            global $javascript_on, $username, $mbx_response, $mailbox,
                   $startMessage, $show_num, $sort, $imapConnection,
                   $key, $imapServerAddress, $imapPort, $account;
            if (check_sm_version(1, 5, 2)) $key = FALSE;
            if (empty($mbx_response))
            {
               if (!is_resource($imapConnection))
                  $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
               $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);
            }


            // when reading message itself, redirect back to
            // message list after having moved it
            //
            if ($reporting_from_message_view && $javascript_on)
            {

//TODO: this may cause problems in 1.4.x, where output is probably already started
               sqsession_register($note, 'sb_note');


               // when viewing a message in the preview pane,
               // need to clear pane after delete as well as
               // refresh message list
               //
               global $data_dir, $PHP_SELF;
               if (is_plugin_enabled('preview_pane')
                && getPref($data_dir, $username, 'use_previewPane', 0) == 1)
               {

                  // refresh message list & close
                  //
                  if (check_sm_version(1, 5, 2))
                  {
                     global $oTemplate;
                     $output = $oTemplate->fetch('plugins/spam_buttons/redirect_preview_pane.tpl');
                     return array('read_body_header' => $output);
                  }
                  else
                  {
                     global $base_uri, $t;
                     $t = array(); // no need to put config vars herein, they are already globalized
                     include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_preview_pane.tpl');
                  }

               }


               // otherwise, just calculate redirect locaiton
               // and redirect with javascript
               //
               else
               {
                  $location = sqm_baseuri() . "src/right_main.php?mailbox="
                            . urlencode($mailbox)
                            . (!empty($sort) ? "&sort=$sort" : '')
                            . (!empty($account) ? "&account=$account" : '')
                            . (!empty($startMessage) ? "&startMessage=$startMessage" : '');
                  if (check_sm_version(1, 5, 2))
                  {
                     global $oTemplate;
                     $oTemplate->assign('location', $location);
                     $output = $oTemplate->fetch('plugins/spam_buttons/redirect_standard.tpl');
                     return array('read_body_header' => $output);
                  }
                  else
                  {
                     global $t;
                     $t = array($location);
                     include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_standard.tpl');
                  }

               }

            }


            // otherwise make sure we didn't move ourselves
            // off the last page or anything like that (code copied from
            // 1.4.11 src/move_messages.php)
            //
            else if (!$reporting_from_message_view)
            {
               if (($startMessage + $cnt - 1) >= $mbx_response['EXISTS'])
               {
                  if ($startMessage > $show_num)
                     $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
                  else
                     $location = set_url_var($location,'startMessage',1, false);
               }
            }

         }

      }


      // shell command
      //
      else if (!empty($is_not_spam_shell_command))
      {

         $note = report_by_shell_command($is_not_spam_shell_command, $msg, $passed_ent_id);


         if (empty($note))
         {
            $success = TRUE;
            $note = _($reported_not_spam_text);
//TODO? include something that identifies the message(s) that were reported(have to add it up in the loop above)?  might take too much screen real estate....?
         }

      }


      // or just re-send elsewhere
      //
      else if (!empty($is_not_spam_resend_destination))
      {

         $note = report_by_email($is_not_spam_resend_destination, $msg, $passed_ent_id, $is_not_spam_subject_prefix);

         if (empty($note)) 
         {
            $success = TRUE;
            $note = _($reported_not_spam_text);
//TODO? include something that identifies the message(s) that were reported(have to add it up in the loop above)?  might take too much screen real estate....?
         }

      }


      else
//TODO: we could put a warning here for the sysadmin... (but note that it is possible to get here when report-by-move-to-folder is correctly configured but no messages were selected by the user before pressing the report button)
         $note = '';

   }


   sq_change_text_domain('squirrelmail');



   // -----------------------------------------------------------------
   //
   // REPORTED... NOW MOVE?
   //


   // move spam
   //
   if ($success && !empty($isSpam) && $sb_move_after_report_spam
    && empty($sb_report_spam_by_move_to_folder)   // not if already moved!
    && empty($passed_ent_id)  // not if reporting an attachment!
    && is_array($msg))
   {

      global $auto_expunge, $imapConnection, $username, $key, $show_num,
             $mbx_response, $imapServerAddress, $imapPort, $mailbox, 
             $startMessage, $sort, $account, $javascript_on;
      if (check_sm_version(1, 5, 2)) $key = FALSE;
      if (!is_resource($imapConnection))
         $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
      if (empty($mbx_response))
         $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);

      // move messages only when target mailbox is not the same as source mailbox
      //
      if ($mailbox != $sb_move_after_report_spam) 
      {

         if (check_sm_version(1, 5, 2))
         {
            global $aMailbox;
            sqGetGlobalVar('lastTargetMailbox', $lastTargetMailbox, SQ_SESSION);
            if ($sb_copy_after_report_spam)
               $note = handleMessageListForm($imapConnection, $aMailbox, 'copy', $msg, $sb_move_after_report_spam);
            else
               $note = handleMessageListForm($imapConnection, $aMailbox, 'move', $msg, $sb_move_after_report_spam);
            sqsession_register($lastTargetMailbox,'lastTargetMailbox');
         }
         else
         {
            if ($sb_copy_after_report_spam)
               spam_buttons_sqimap_msgs_list_copy($imapConnection, $msg, $sb_move_after_report_spam);
            else
               sqimap_msgs_list_copy($imapConnection, $msg, $sb_move_after_report_spam);
            if ($auto_expunge) 
               $cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
            else 
               $cnt = 0;
         }


         // when reading message itself, redirect back to 
         // message list after having moved it
         //
         if ($reporting_from_message_view && $javascript_on)
         {

//TODO: this may cause problems in 1.4.x, where output is probably already started
            sqsession_register($note, 'sb_note');


            // when viewing a message in the preview pane,
            // need to clear pane after delete as well as
            // refresh message list
            //
            global $data_dir, $PHP_SELF;
            if (is_plugin_enabled('preview_pane')
             && getPref($data_dir, $username, 'use_previewPane', 0) == 1)
            {

               // refresh message list & close
               //
               if (check_sm_version(1, 5, 2))
               {
                  global $oTemplate;
                  $output = $oTemplate->fetch('plugins/spam_buttons/redirect_preview_pane.tpl');
                  return array('read_body_header' => $output);
               }
               else
               {
                  global $base_uri, $t;
                  $t = array(); // no need to put config vars herein, they are already globalized
                  include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_preview_pane.tpl');
               }

            }


            // otherwise, just calculate redirect locaiton
            // and redirect with javascript
            //
            else
            {
               $location = sqm_baseuri() . "src/right_main.php?mailbox="
                         . urlencode($mailbox)
                         . (!empty($sort) ? "&sort=$sort" : '')
                         . (!empty($account) ? "&account=$account" : '')
                         . (!empty($startMessage) ? "&startMessage=$startMessage" : '');
               if (check_sm_version(1, 5, 2))
               {
                  global $oTemplate;
                  $oTemplate->assign('location', $location);
                  $output = $oTemplate->fetch('plugins/spam_buttons/redirect_standard.tpl');
                  return array('read_body_header' => $output);
               }
               else
               {
                  global $t;
                  $t = array($location);
                  include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_standard.tpl');
               }

            }

         }


         // otherwise make sure we didn't move ourselves 
         // off the last page or anything like that (code copied from 
         // 1.4.11 src/move_messages.php)
         //
         else if (!$reporting_from_message_view)
         {
            if (($startMessage + $cnt - 1) >= $mbx_response['EXISTS']) 
            {
               if ($startMessage > $show_num) 
                  $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
               else
                  $location = set_url_var($location,'startMessage',1, false);
            }
         }

      }

   }


   // move ham
   //
   if ($success && !empty($notSpam) && $sb_move_after_report_not_spam
    && empty($sb_report_not_spam_by_move_to_folder)   // not if already moved!
    && empty($passed_ent_id)  // not if reporting an attachment!
    && is_array($msg))
   {

      global $auto_expunge, $imapConnection, $username, $key, $show_num,
             $mbx_response, $imapServerAddress, $imapPort, $mailbox, 
             $startMessage, $sort, $account, $javascript_on;
      if (check_sm_version(1, 5, 2)) $key = FALSE;
      if (!is_resource($imapConnection))
         $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
      if (empty($mbx_response))
         $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);

      // move messages only when target mailbox is not the same as source mailbox
      //
      if ($mailbox != $sb_move_after_report_not_spam) 
      {

         if (check_sm_version(1, 5, 2))
         {
            global $aMailbox;
            sqGetGlobalVar('lastTargetMailbox', $lastTargetMailbox, SQ_SESSION);
            if ($sb_copy_after_report_not_spam)
               $note = handleMessageListForm($imapConnection, $aMailbox, 'copy', $msg, $sb_move_after_report_not_spam);
            else
               $note = handleMessageListForm($imapConnection, $aMailbox, 'move', $msg, $sb_move_after_report_not_spam);
            sqsession_register($lastTargetMailbox,'lastTargetMailbox');
         }
         else
         {
            if ($sb_copy_after_report_not_spam)
               spam_buttons_sqimap_msgs_list_copy($imapConnection, $msg, $sb_move_after_report_not_spam);
            else
               sqimap_msgs_list_copy($imapConnection, $msg, $sb_move_after_report_not_spam);
            if ($auto_expunge) 
               $cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
            else 
               $cnt = 0;
         }


         // when reading message itself, redirect back to 
         // message list after having moved it
         //
         if ($reporting_from_message_view && $javascript_on)
         {

//TODO: this may cause problems in 1.4.x, where output is probably already started
            sqsession_register($note, 'sb_note');


            // when viewing a message in the preview pane,
            // need to clear pane after delete as well as
            // refresh message list
            //
            global $data_dir, $PHP_SELF;
            if (is_plugin_enabled('preview_pane')
             && getPref($data_dir, $username, 'use_previewPane', 0) == 1)
            {

               // refresh message list & close
               //
               if (check_sm_version(1, 5, 2))
               {
                  global $oTemplate;
                  $output = $oTemplate->fetch('plugins/spam_buttons/redirect_preview_pane.tpl');
                  return array('read_body_header' => $output);
               }
               else
               {
                  global $base_uri, $t;
                  $t = array(); // no need to put config vars herein, they are already globalized
                  include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_preview_pane.tpl');
               }

            }


            // otherwise, just calculate redirect locaiton
            // and redirect with javascript
            //
            else
            {
               $location = sqm_baseuri() . "src/right_main.php?mailbox="
                         . urlencode($mailbox)
                         . (!empty($sort) ? "&sort=$sort" : '')
                         . (!empty($account) ? "&account=$account" : '')
                         . (!empty($startMessage) ? "&startMessage=$startMessage" : '');
               if (check_sm_version(1, 5, 2))
               {
                  global $oTemplate;
                  $oTemplate->assign('location', $location);
                  $output = $oTemplate->fetch('plugins/spam_buttons/redirect_standard.tpl');
                  return array('read_body_header' => $output);
               }
               else
               {
                  global $t;
                  $t = array($location);
                  include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_standard.tpl');
               }

            }

         }


         // otherwise make sure we didn't move ourselves 
         // off the last page or anything like that (code copied from 
         // 1.4.11 src/move_messages.php)
         //
         else if (!$reporting_from_message_view)
         {
            if (($startMessage + $cnt - 1) >= $mbx_response['EXISTS']) 
            {
               if ($startMessage > $show_num) 
                  $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
               else
                  $location = set_url_var($location,'startMessage',1, false);
            }
         }

      }

   }



   // -----------------------------------------------------------------
   //
   // OR DELETE?
   //


   // delete spam if needed (but not if already moved)
   //
   if ($success && $sb_delete_after_report && !empty($isSpam) 
    && !$sb_move_after_report_spam  // not if already moved!
    && empty($passed_ent_id)  // not if reporting an attachment!
    && empty($sb_report_spam_by_move_to_folder))  // not if already moved!
   {
      if (is_array($msg))
      {
         global $auto_expunge, $imapConnection, $username, $key, $show_num,
                $mbx_response, $imapServerAddress, $imapPort, $mailbox, 
                $startMessage, $sort, $account, $javascript_on;
         if (check_sm_version(1, 5, 2)) $key = FALSE;
         if (!is_resource($imapConnection))
            $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
         if (empty($mbx_response))
            $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);

         if (check_sm_version(1, 5, 2))
         {
            global $aMailbox;
            handleMessageListForm($imapConnection, $aMailbox, 'setDeleted', $msg);
         }
         else
         {
            sqimap_msgs_list_delete($imapConnection, $mailbox, $msg);
            if ($auto_expunge) 
            {
               $cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
            }
         }

         
         // when reading message itself, redirect back to 
         // message list after deletion
         //
         if ($reporting_from_message_view && $javascript_on)
         {

//TODO: this may cause problems in 1.4.x, where output is probably already started
            sqsession_register($note, 'sb_note');


            // when viewing a message in the preview pane, 
            // need to clear pane after delete as well as
            // refresh message list
            //
            global $data_dir, $PHP_SELF;
            if (is_plugin_enabled('preview_pane') 
             && getPref($data_dir, $username, 'use_previewPane', 0) == 1)
            {

               // refresh message list & close
               //
               if (check_sm_version(1, 5, 2))
               {
                  global $oTemplate;
                  $output = $oTemplate->fetch('plugins/spam_buttons/redirect_preview_pane.tpl');
                  return array('read_body_header' => $output);
               }
               else
               {
                  global $base_uri, $t;
                  $t = array(); // no need to put config vars herein, they are already globalized
                  include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_preview_pane.tpl');
               }

            }


            // otherwise, just calculate redirect locaiton 
            // and redirect with javascript
            //
            else
            {
               $location = sqm_baseuri() . "src/right_main.php?mailbox="
                         . urlencode($mailbox)
                         . (!empty($sort) ? "&sort=$sort" : '')
                         . (!empty($account) ? "&account=$account" : '')
                         . (!empty($startMessage) ? "&startMessage=$startMessage" : '');
               if (check_sm_version(1, 5, 2))
               {
                  global $oTemplate;
                  $oTemplate->assign('location', $location);
                  $output = $oTemplate->fetch('plugins/spam_buttons/redirect_standard.tpl');
                  return array('read_body_header' => $output);
               }
               else
               {
                  global $t;
                  $t = array($location);
                  include(SM_PATH . 'plugins/spam_buttons/templates/default/redirect_standard.tpl');
               }

            }

         }


         // otherwise make sure we didn't delete ourselves 
         // off the last page or anything like that (code copied from 
         // 1.4.11 src/move_messages.php)
         //
         else if (!$reporting_from_message_view)
         {
            if (($startMessage + $cnt - 1) >= $mbx_response['EXISTS']) 
            {
               if ($startMessage > $show_num) 
                  $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
               else
                  $location = set_url_var($location,'startMessage',1, false);
            }
         }
      }
   }



   // -----------------------------------------------------------------
   //
   // DONE, WHERE DO WE RETURN TO?
   //


   // if no note, then we shouldn't do anything at all
   //
   if (empty($note)) 
   {
      if (check_sm_version(1, 5, 0))
         return;
      else
      {
         header('Location: ' . $location);
         exit;
      }
   }


   // when reading message itself, print message 
   // in header and continue (unless message has been deleted)
   //
   if ($reporting_from_message_view)
   {
      if (check_sm_version(1, 5, 2))
      {
         global $oTemplate;
         $oTemplate->assign('note', $note);
         $output = $oTemplate->fetch('plugins/spam_buttons/confirmation_note.tpl');
         return array('read_body_header' => $output);
      }
      else
      {
         echo html_tag('tr', html_tag('td', "<strong>$note</strong>", 'center', '', ' colspan="2"'));
         return;
      }
   }



   //
   // behavior is different when button on message list was clicked
   //


   // SM 1.5.2+: $note will be displayed automatically, so 
   // all we need to do is return
   //
   if (check_sm_version(1, 5, 2))
   {
      global $preselected;
      $preselected = array_keys($prechecked);
      return;
   }


   // SM 1.5: just display note and let go
   //
   else if (check_sm_version(1, 5, 0))
   {
      global $preselected;
      $preselected = array_keys($prechecked);
      echo html_tag('div', '<b>' . $note .'</b>', 'center') . "<br />\n";
      return;
   }


   // For SM 1.4.x, redirect to message list so SM 
   // doesn't try to do something else funny (1.4.x 
   // assumes it has to delete messages... yikes)
   //
   else
   {
      // put note in session so we can display it when back in 
      // message list, without putting $note in the location, since
      // it is hard to remove from there, even on subsequent requests
      //
      sqsession_register($note, 'sb_note');

      // compress prechecked array and pass it along
      //
      $query = '';
      foreach ($prechecked as $msgid => $ignore)
         $query .= '&preselected[' . $msgid . ']=1';
      if (strpos($location, '?') === FALSE)
         $query{0} = '?';

      //header('Location: ' . $location . $query . '&note=' . urlencode($note));
      header('Location: ' . $location . $query);
      exit;
   }
       

}



/**
  * Reports one or more spam/non-spam using email redirection.
  *
  * @param string $destination The email address to which the
  *                            message should be redirected.
  * @param array $msg An array of message IDs to be reported.
  * @param array $passed_ent_id The message entity being reported
  *                             (zero if the message itself is being
  *                             reported (only applicable when there
  *                             is just one element in the $msg array))
  * @param string $subjectPrefix Any extra subject info for 
  *                              redirected mail's subject.
  *                              (optional; default is empty 
  *                              string, nothing is done to subject)
  *
  * @return string An error message if an error occurred,
  *                empty string otherwise
  *
  */
function report_by_email($destination, $msg, $passed_ent_id, $subjectPrefix='')
{

   global $spam_report_email_method, $spam_report_smtpServerAddress, 
          $spam_report_smtpPort, $spam_report_useSendmail, 
          $spam_report_smtp_auth_mech, $spam_report_use_smtp_tls,
          $smtpServerAddress, $smtpPort, $useSendmail, $smtp_auth_mech, 
          $use_smtp_tls, $sb_debug, $username, $domain;
   $at_sign = '@';

   spam_buttons_init();


   // do replacements on destination
   //
   if (strpos($username, $at_sign) !== FALSE)
      list($user, $dom) = explode($at_sign, $username);
   else
   {
      $user = $username;
      $dom = $domain;
   }
   $destination = str_replace(array('###EMAIL_ADDRESS###', '###USERNAME###', '###DOMAIN###'), 
                              array($user . $at_sign . $dom, $user, $dom), 
                              $destination);


   // take care of overrides for SMTP server
   //
   if (!empty($spam_report_smtpServerAddress))
      $smtpServerAddress = $spam_report_smtpServerAddress;
   if (!empty($spam_report_smtpPort))
      $smtpPort = $spam_report_smtpPort;
   if ($spam_report_useSendmail !== '')
      if (strtolower($spam_report_useSendmail) === 'false')
         $useSendmail = FALSE;
      else
         $useSendmail = $spam_report_useSendmail;
   if (!empty($spam_report_smtp_auth_mech))
      $smtp_auth_mech = $spam_report_smtp_auth_mech;
   if (!empty($spam_report_use_smtp_tls))
      $use_smtp_tls = $spam_report_use_smtp_tls;


   $note = '';


   // redirect by bouncing message and preserving headers
   //
   if ($spam_report_email_method == 'bounce')
   {

      global $imapServerAddress, $imapPort, $useSendmail;


      // we will be manually manipulating $_GET, so...
      //
      global $_GET;
      if (!check_php_version(4,1)) 
      {
         global $HTTP_GET_VARS;
         $_GET = $HTTP_GET_VARS;
      }


      if (is_array($msg)) foreach ($msg as $messageID)
      {
         $_GET['bounce_send_to'] = $destination;
         $_GET['passed_id'] = $messageID;
         $_GET['passed_ent_id'] = $passed_ent_id;
         require(SM_PATH . 'plugins/spam_buttons/bounce_send.php');
      }

   }


   // redirect by including message as an attachment
   //
   else
   {

      sqgetGlobalVar('mailbox', $mailbox);
      if (check_sm_version(1, 5, 2))
         include_once(SM_PATH . 'plugins/spam_buttons/compose_functions-1.5.2.php');
      else if (check_sm_version(1, 4, 11))
         include_once(SM_PATH . 'plugins/spam_buttons/compose_functions-1.4.11.php');
      else
         include_once(SM_PATH . 'plugins/spam_buttons/compose_functions-1.4.10.php');


      if (is_array($msg)) foreach ($msg as $messageID)
      {

         global $composeMessage, $send_to, $subject;

         $composeMessage = new Message();
         $rfc822_header = new Rfc822Header();
         $composeMessage->rfc822_header = $rfc822_header;
         $composeMessage->reply_rfc822_header = '';

         $message = newMail($mailbox, $messageID, $passed_ent_id, 'forward_as_attachment', '');
         $subject = $message['subject'];
         if (!empty($subjectPrefix))
            $subject = preg_replace('/fwd/i', $subjectPrefix, $subject);

         $send_to = $destination;

         $Result = deliverMessage($composeMessage);
         if (! $Result) 
         {
            sq_change_text_domain('spam_buttons');
            $note = _("ERROR: Report could not be delivered");
            sq_change_text_domain('squirrelmail');
            break; 
         }

         // dump stuff out if debugging
         //
         if ($sb_debug)
         {
            echo '<hr /><strong>EMAIL ADDRESS USED TO REPORT:</strong> ' . $destination . '<br /><br />';
            echo '<hr /><strong>MESSAGE BODY AS REPORTED:</strong> (note that this is a parsed representation thereof)';
            sm_print_r($composeMessage);
            echo '<br /><br />';
            exit;
         }

      }

   }


   return $note;

}



/**
  * Reports one or more spam/non-spam using the shell
  * command provided.
  *
  * @param string $command The shell command to be used.
  * @param array $msg An array of message IDs to be reported.
  * @param array $passed_ent_id The message entity being reported
  *                             (zero if the message itself is being
  *                             reported (only applicable when there
  *                             is just one element in the $msg array))
  *
  * @return string An error message if an error occurred, 
  *                empty string otherwise
  *
  */
function report_by_shell_command($command, $msg, $passed_ent_id)
{

   global $attachment_dir, $username, $domain, $sb_debug;
   $at_sign = '@';

   spam_buttons_init();


   $passed_ent_id = 0;
   sqgetGlobalVar('passed_ent_id',   $passed_ent_id,  SQ_FORM);
   sqgetGlobalVar('mailbox', $mailbox);


   // do replacements on command
   //
   if (strpos($username, $at_sign) !== FALSE)
      list($user, $dom) = explode($at_sign, $username);
   else
   {
      $user = $username;
      $dom = $domain;
   }
   $command = str_replace(array('###EMAIL_ADDRESS###', '###USERNAME###', '###DOMAIN###'), 
                          array($user . $at_sign . $dom, $user, $dom), 
                          $command);


   $note = '';
   $timestamp = time();


   if (is_array($msg)) foreach ($msg as $messageID)
   {
      
      // get message body, correctly formatted
      //
      global $uid_support, $imapConnection, $username, $key, 
             $mbx_response, $imapServerAddress, $imapPort, $mailbox; 
      if (check_sm_version(1, 5, 2)) { $key = FALSE; $uid_support = TRUE; }

      if (!is_resource($imapConnection))
         $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
      if (empty($mbx_response))
         $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);
      $response = '';
      $message = '';

      if (empty($passed_ent_id))
         $raw_message = sqimap_run_command($imapConnection, "FETCH $messageID RFC822", true, $response, $message, $uid_support);
      else
         $raw_message = sqimap_run_command($imapConnection, "FETCH $messageID BODY[$passed_ent_id]", true, $response, $message, $uid_support);

      if ($response != 'OK')
      {
         global $color;
         sq_change_text_domain('spam_buttons');
         $msg = sprintf(_("Could not find requested message: %s"), $message);
         sq_change_text_domain('squirrelmail');
         $ret = plain_error_message($msg, $color);
         if (check_sm_version (1, 5, 2)) 
         {
            echo $ret;
            global $oTemplate;
            $oTemplate->display('footer.tpl');
         }
         exit;
      }

      // rebuild the message exactly as it comes from the IMAP server
      // (except first and last array entries are command wrappers, so skip them)
      //
      array_shift($raw_message);
      array_pop($raw_message);
      $raw_message = implode('', $raw_message);


      // store message in attachments directory in temp file
      //
      $tempFile = $attachment_dir . '/sb_tmp_' . $messageID . '_' . $timestamp;
      $tempFileOK = FALSE;
      if ($FILE = @fopen($tempFile, 'w'))
      {

         fwrite($FILE, $raw_message);
         fclose($FILE);
         $tempFileOK = TRUE;


         // run command
         // 
         $cmd = $command . ' < ' . $tempFile;
//sm_print_r($cmd, $raw_message);exit;
         $lastLineOfOutput = exec($cmd, $allOutput, $retValue);
//sm_print_r($allOutput);exit;


         // remove temp file
         //
         unlink($tempFile);


         // dump stuff out if debugging
         //
         if ($sb_debug)
         {
            echo '<hr /><strong>COMMAND USED TO REPORT:</strong> ' . $cmd . '<br /><br />';
            echo '<hr /><strong>MESSAGE BODY AS REPORTED:</strong> ';
            sm_print_r($raw_message);
            echo '<br /><br />';
            echo '<hr /><strong>RESULTS FROM REPORT:</strong> (' . $retValue . ')';
            sm_print_r($allOutput);
            echo '<br /><br />';
            exit;
         }

      }


      // couldn't open temp file
      //
      if (!$tempFileOK)
      {
         $note = _("ERROR: Could not open temp file; check attachments directory permissions");
         break; 
      }
      
      
      // oops, command failed 
      //
      else if ($retValue !== 0)
      {
//TODO: use str_replace() instead of sprintf()
//TODO: include $passed_ent_id in message if it is non-zero
         $note = sprintf(_("ERROR %d: Problem reporting message ID %d: %s"),
                         $retValue, $messageID, $lastLineOfOutput);
         break;
      }

   }

   return $note;

}



/**
  * Constructs spam button text
  *
  * @param array $buttons The list of buttons being added to under 1.5.2+
  *                       NOTE that this parameter is passed by reference
  *                       and is potentially modified herein.  Because it
  *                       is passed by reference, PHP 4 doesn't like a default
  *                       value being specified, so callers should pass an
  *                       empty string when it is not needed (usually only
  *                       needed under 1.5.2 during the relevant hooks, such 
  *                       as "message_list_controls").
  * @param boolean $dont_show_if_report_by_move_to_folder When true, and the
  *                                                       report-by-move-to-
  *                                                       folder method is
  *                                                       configured, don't
  *                                                       show the corresponding
  *                                                       button if the message
  *                                                       in question is an
  *                                                       attachment to another
  *                                                       message, otherwise all
  *                                                       buttons are shown no
  *                                                       matter what (OPTIONAL;
  *                                                       default = FALSE).
  */
function get_spam_buttons(&$buttons, 
                          $dont_show_if_report_by_move_to_folder=FALSE)
{

   global $show_not_spam_button, $spam_button_text, $not_spam_button_text,
          $show_is_spam_button, $username, $data_dir,
          $sb_report_spam_by_move_to_folder, 
          $sb_report_not_spam_by_move_to_folder,
          $sb_suppress_spam_button_folder,
          $sb_suppress_spam_button_folder_allow_override,
          $sb_suppress_not_spam_button_folder,
          $sb_suppress_not_spam_button_folder_allow_override;
 
   $passed_ent_id = 0;
   sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
   sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);

   spam_buttons_init();

   if ($sb_suppress_spam_button_folder_allow_override)
   {
      $sb_suppress_spam_button_folder = getPref($data_dir, $username, 
                                                'sb_suppress_spam_button_folder', 
                                                $sb_suppress_spam_button_folder);
   }
   if ($sb_suppress_not_spam_button_folder_allow_override)
   {
      $sb_suppress_not_spam_button_folder = getPref($data_dir, $username, 
                                                    'sb_suppress_not_spam_button_folder', 
                                                    $sb_suppress_not_spam_button_folder);
   }

//TODO: create tooltip with more verbose explanation 
   $ret = '';

   if ($show_is_spam_button || $show_not_spam_button)
      $ret .= ' ';
   
   sq_change_text_domain('spam_buttons');


   // 1) is button turned on in the first place?
   // 2) if in the spam folder, don't show spam button
   // 3) if current message is tagged as spam, don't show spam button
   // 4) can't show button if caller doesn't want it shown
   //    when report method is move-to-folder and we're 
   //    looking at a message that is an attachment to another
   // 
   if ($show_is_spam_button
    && $mailbox != $sb_suppress_spam_button_folder
    && !current_message_is_tagged(TRUE)
    && (!$dont_show_if_report_by_move_to_folder
     || !($sb_report_spam_by_move_to_folder && !empty($passed_ent_id))))
   {
      if (check_sm_version(1, 5, 2))
         $buttons['isSpam'] = array('value' => _($spam_button_text), 'type' => 'submit');
      else
         $ret .= '<input type="submit" name="isSpam" value="' . _($spam_button_text) . '" />';
   }


   // 1) is button turned on in the first place?
   // 2) if in the ham folder, don't show ham button
   // 3) if current message is tagged as ham, don't show ham button
   // 4) can't show button if caller doesn't want it shown
   //    when report method is move-to-folder and we're 
   //    looking at a message that is an attachment to another
   // 
   if ($show_not_spam_button
    && $mailbox != $sb_suppress_not_spam_button_folder
    && !current_message_is_tagged(FALSE)
    && (!$dont_show_if_report_by_move_to_folder
     || !($sb_report_not_spam_by_move_to_folder && !empty($passed_ent_id))))
   {
      if (check_sm_version(1, 5, 2))
         $buttons['notSpam'] = array('value' => _($not_spam_button_text), 'type' => 'submit');
      else
         $ret .= '<input type="submit" name="notSpam" value="' . _($not_spam_button_text) . '" />';
   }

   sq_change_text_domain('squirrelmail');

   return $ret;

}



/**
  * Adds spam/ham links to message options list on read body page
  *
  */
function sb_read_message_links_do(&$links)
{

   global $show_spam_link_on_read_body, $show_not_spam_button, 
          $spam_button_text, $not_spam_button_text, $show_is_spam_button,
          $sb_report_spam_by_move_to_folder, $username,
          $sb_report_not_spam_by_move_to_folder,
          $sb_suppress_spam_button_folder, $data_dir,
          $sb_suppress_spam_button_folder_allow_override,
          $sb_suppress_not_spam_button_folder,
          $sb_suppress_not_spam_button_folder_allow_override;

   spam_buttons_init();

   if (!$show_spam_link_on_read_body)
      return;

   if ($sb_suppress_spam_button_folder_allow_override)
   {
      $sb_suppress_spam_button_folder = getPref($data_dir, $username, 
                                                'sb_suppress_spam_button_folder', 
                                                $sb_suppress_spam_button_folder);
   }
   if ($sb_suppress_not_spam_button_folder_allow_override)
   {
      $sb_suppress_not_spam_button_folder = getPref($data_dir, $username, 
                                                    'sb_suppress_not_spam_button_folder', 
                                                    $sb_suppress_not_spam_button_folder);
   }


   $spam_links = array();
   $passed_ent_id = 0;
   sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
   sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
   sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
   sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
   sqgetGlobalVar('view_as_html',  $view_as_html,  SQ_FORM);
   sqgetGlobalVar('account',       $account,       SQ_FORM);


   sq_change_text_domain('spam_buttons');

//TODO: create tooltip with more verbose explanation 
   // do not show buttons if the report-by-move-to-folder method
   // has been configured and $passed_ent_id is non-zero (can't
   // move an attachment)... and of course, not if in spam/ham folder
   // or if message is tagged as spam/ham
   //
   if ($show_is_spam_button 
    && $mailbox != $sb_suppress_spam_button_folder
    && !current_message_is_tagged(TRUE)
    && !($sb_report_spam_by_move_to_folder && !empty($passed_ent_id)))
      $spam_links[] = array('URL' => sqm_baseuri() 
         . 'src/read_body.php?isSpam=yslnk&mailbox=' 
         . urlencode($mailbox) . '&passed_id=' . $passed_id . '&view_as_html='
         . $view_as_html . '&startMessage=' . $startMessage . '&passed_ent_id=' 
         . $passed_ent_id . '&account=' . $account, 
         'Text' => _($spam_button_text));
   
   if ($show_not_spam_button
    && $mailbox != $sb_suppress_not_spam_button_folder
    && !current_message_is_tagged(FALSE)
    && !($sb_report_not_spam_by_move_to_folder && !empty($passed_ent_id)))
      $spam_links[] = array('URL' => sqm_baseuri() 
         . 'src/read_body.php?notSpam=yslnk&mailbox='
         . urlencode($mailbox) . '&passed_id=' . $passed_id . '&view_as_html='
         . $view_as_html . '&startMessage=' . $startMessage . '&passed_ent_id=' 
         . $passed_ent_id . '&account=' . $account, 
         'Text' => _($not_spam_button_text));

   if (check_sm_version(1, 5, 2))
      $links = array_merge($links, $spam_links);

   else
   {
      foreach ($spam_links as $link)
         echo ' | <a href="' . $link['URL'] . '">' . $link['Text'] . '</a>';
   }

   sq_change_text_domain('squirrelmail');

}



/**
  * Adds spam/ham buttons to mailbox listing
  *
  */
function sb_mailbox_list_buttons_do(&$buttons)
{

   global $show_spam_buttons_on_message_list;

   spam_buttons_init();

   if (!$show_spam_buttons_on_message_list)
      return;

   if (check_sm_version(1, 5, 2))
   {
      get_spam_buttons($buttons);
   }
   else
   {
      $temp = '';
      echo get_spam_buttons($temp);
   }

}



/**
  * Adds spam/ham buttons to message display 
  * (currently only useful in 1.5.x)
  *
  */
function sb_read_message_buttons_do($args)
{

   global $show_spam_buttons_on_read_body;

   spam_buttons_init();

   if (!$show_spam_buttons_on_read_body)
      return;


   if (check_sm_version(1, 5, 2))
   {
//TODO: 1.5.2 should change the API for the buttons on the read message screen, then this code will have to change to suit
      global $oTemplate;

      sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
      sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
      sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
      sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
      sqgetGlobalVar('view_as_html',  $view_as_html,  SQ_FORM);
      sqgetGlobalVar('account',       $account,       SQ_FORM);

      $buttons = array();
      get_spam_buttons($buttons, TRUE); 

      $oTemplate->assign('buttons', $buttons);
      $oTemplate->assign('mailbox', $mailbox);
      $oTemplate->assign('passed_id', $passed_id);
      $oTemplate->assign('passed_ent_id', $passed_ent_id);
      $oTemplate->assign('startMessage', $startMessage);
      $oTemplate->assign('view_as_html', $view_as_html);
      $oTemplate->assign('account', $account);

      $output = $oTemplate->fetch('plugins/spam_buttons/read_menubar_buttons.tpl');

      return array('read_body_menu_buttons_bottom' => $output,
                   'read_body_menu_buttons_top' => $output);
   }


   // as of SM version 1.5.0, this works a little differently
   //
   else if (check_sm_version(1, 5, 0))
   {

      sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
      sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
      sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
      sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
      sqgetGlobalVar('view_as_html',  $view_as_html,  SQ_FORM);

      // add spam buttons after delete stuff
      //
      $temp = '';
      $args[1] = preg_replace('/<\/td>/', 
                 '<form method="post" style="display: inline">' 
               . get_spam_buttons($temp, TRUE) 
               . '<input type="hidden" name="mailbox" value="' . $mailbox . '" />'
               . '<input type="hidden" name="msg[0]" value="' . $passed_id . '" />'
               . '<input type="hidden" name="passed_ent_id" value="' . $passed_ent_id . '" />'
               . '<input type="hidden" name="view_as_html" value="' . $view_as_html . '" />'
               . '<input type="hidden" name="startMessage" value="' . $startMessage . '" />'
               . '</form></td>', $args[1], 1);
   
      return $args;

   }


   // all older versions...  way too much trouble, especially if 
   // preview pane is in use; read_body_header_right will be 
   // sufficient
   //
   else
   {

      return;

   }


}



/**
  * Determine if the current message being viewed is spam or ham
  *
  * If the configuration items related to this functionality are
  * not set, or we are not on a message view screen, this always 
  * returns FALSE.
  *
  * @param boolean $spam When TRUE, check if the message is spam,
  *                      when FALSE, check if the message is ham.
  *
  * @return boolean TRUE if the message has been tagged as inquired
  *
  */
function current_message_is_tagged($spam)
{

   if (defined('PAGE_NAME'))
   {
      if (PAGE_NAME != 'read_body') return FALSE;
   }
   else
   {
      global $PHP_SELF;
      if (strpos($PHP_SELF, '/src/read_body') === FALSE) 
         return FALSE;
   }

   global $sb_spam_header_name, $sb_not_spam_header_name,
          $sb_spam_header_value, $sb_not_spam_header_value;

   spam_buttons_init();

   sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
   sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);

   if ($spam && !empty($sb_spam_header_name) 
    && !empty($sb_spam_header_value))
   {

      $headers = get_message_headers($passed_id, $passed_ent_id);
      foreach ($headers as $header)
         if (strtolower($header[0]) == strtolower($sb_spam_header_name . ':')
          && preg_match($sb_spam_header_value, trim($header[1])))
            return TRUE;

   }
   else if (!$spam && !empty($sb_not_spam_header_name) 
    && !empty($sb_not_spam_header_value))
   {

      $headers = get_message_headers($passed_id, $passed_ent_id);
      foreach ($headers as $header)
         if (strtolower($header[0]) == strtolower($sb_not_spam_header_name . ':')
          && preg_match($sb_not_spam_header_value, trim($header[1])))
            return TRUE;

   }

   return FALSE;

}



/**
  * Retrieve All Message Headers
  *
  * When called more than once in the same page request against the same
  * message, a cached set of headers is returned for efficiency.
  *
  * @param int    $passed_id     UID of the desired message
  * @param string $passed_ent_id Entity ID of the desired message attachment
  *
  * @return array An array of all message headers
  *
  */
function get_message_headers($passed_id, $passed_ent_id)
{

   static $parsed_headers = array();
   static $id = NULL;
   static $ent_id = NULL;

   if (!empty($parsed_headers) && $passed_id == $id && $passed_ent_id == $ent_id)
      return $parsed_headers;

   $id = $passed_id;
   $ent_id = $passed_ent_id;

   global $imapConnection, $username, $key, $uid_support,
          $mbx_response, $imapServerAddress, $imapPort, $mailbox; 

   if (check_sm_version(1, 5, 2)) { $key = FALSE; $uid_support = TRUE; }

   if (!is_resource($imapConnection))
      $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   if (empty($mbx_response))
      $mbx_response = sqimap_mailbox_select($imapConnection, $mailbox);

   if (empty($ent_id))
      $headers = sqimap_run_command($imapConnection, "FETCH $id BODY[HEADER]", true, $response, $message, $uid_support);
   else
      $headers = sqimap_run_command($imapConnection, "FETCH $id BODY[$ent_id.HEADER]", true, $response, $message, $uid_support);


   // based on src/view_header.php...
   //
   $first = $second = array();
   $cnum = 0;

   for ($i=1; $i < count($headers); $i++) 
   {
      $line = $headers[$i];
      switch (true) 
      {
         case (eregi("^&gt;", $line)):
            $second[$i] = $line;
            $first[$i] = '&nbsp;';
            $cnum++;
            break;
         case (eregi("^[ |\t]", $line)):
            $second[$i] = $line;
            $first[$i] = '';
            break;
         case (eregi("^([^:]+):(.+)", $line, $regs)):
            $first[$i] = $regs[1] . ':';
            $second[$i] = $regs[2];
            $cnum++;
            break;
         default:
            $second[$i] = trim($line);
            $first[$i] = '';
            break;
      }
   }

   for ($i=0; $i < count($second); $i = $j) 
   {
      $f = (isset($first[$i]) ? $first[$i] : '');
      $s = (isset($second[$i]) ? $second[$i] : '');
      $j = $i + 1;
      while (($first[$j] == '') && ($j < count($first))) 
      {
         $s .= ' ' . $second[$j];
         $j++;
      }
      if ($f) 
         $parsed_headers[] = array($f,$s);
   }

   return $parsed_headers;

}



// some versions of SM need this when using some compose functions
//
if (!function_exists('addressbook_init'))
   include_once(SM_PATH . 'functions/addressbook.php');



//
// ripped from functions/auth.php (merged both STABLE and DEVEL;
// the only difference being how the hook is handled)
//

/**
 * Fillin user and password based on SMTP auth settings.
 *
 * @param string $user Reference to SMTP username
 * @param string $pass Reference to SMTP password (unencrypted)
 */
if (!function_exists('get_smtp_user'))
{
function get_smtp_user(&$user, &$pass) {
    global $username, $smtp_auth_mech,
           $smtp_sitewide_user, $smtp_sitewide_pass;

    if ($smtp_auth_mech == 'none') {
        $user = '';
        $pass = '';
    } elseif ( isset($smtp_sitewide_user) && isset($smtp_sitewide_pass) &&
               !empty($smtp_sitewide_user)) {
        $user = $smtp_sitewide_user;
        $pass = $smtp_sitewide_pass;
    } else {
        $user = $username;
        $pass = sqauth_read_password();
    }

    if (check_sm_version(1, 5, 2)) {
        do_hook('smtp_auth', $temp=array(&$user, &$pass));
    } else {
        $ret = do_hook_function('smtp_auth', array($user, $pass));
        if (!empty($ret[0]))
            $user = $ret[0];
        if (!empty($ret[1]))
            $pass = $ret[1];
    }
}
}



// modified version of sqimap_msgs_list_copy from 1.4.11 core
// (functions/imap_messages.php)
// this function actually performs a real copy action, unlike 
// the one from core that copies and deletes (move action)
//
function spam_buttons_sqimap_msgs_list_copy($imap_stream, $id, $mailbox) {
    global $uid_support;
    $msgs_id = sqimap_message_list_squisher($id);
    $read = sqimap_run_command ($imap_stream, "COPY $msgs_id \"$mailbox\"", true, $response, $message, $uid_support);
}



