<?php
    /* $Id: bounce_identity.php,v 1.2 2004/04/15 18:41:20 indiri69 Exp $ */
    /*
     * bounce_identity.php
     * duplicates functions/identity.php in versions
     * of SquirrelMail that don't have it
     */

if(!file_exists(SM_PATH . 'functions/identity.php')) {
    include_once(SM_PATH . 'include/load_prefs.php');
    function get_identities() {

        global $username, $data_dir;

        $num_ids = getPref($data_dir,$username,'identities');
        $identities = array();
        /* We always have this one, even if the user doesn't use multiple identities */
        $identities[] = array('full_name' => getPref($data_dir,$username,'full_name'),
            'email_address' => getPref($data_dir,$username,'email_address'),
            'reply_to' => getPref($data_dir,$username,'reply_to'),
            'signature' => getSig($data_dir,$username,'g'),
            'index' => 0 );

        /* If there are any others, add them to the array */
        if (!empty($num_ids) && $num_ids > 1) {
            for ($i=1;$i<$num_ids;$i++) {
                $identities[] = array('full_name' => getPref($data_dir,$username,'full_name' . $i),
                'email_address' => getPref($data_dir,$username,'email_address' . $i),
                'reply_to' => getPref($data_dir,$username,'reply_to' . $i),
                'signature' => getSig($data_dir,$username,$i),
                'index' => $i );
            }
        }

        return $identities;
    }
} else {
    require_once(SM_PATH . 'functions/identity.php');
}
?>
