<?php


/**
  * SquirrelMail Spam Buttons Plugin
  * Copyright (c) 2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage spam_buttons
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_spam_buttons()
{

   global $squirrelmail_plugin_hooks;


   $squirrelmail_plugin_hooks['mailbox_display_buttons']['spam_buttons']  = 'sb_mailbox_list_buttons';

   // SM 1.4.x
   $squirrelmail_plugin_hooks['move_before_move']['spam_buttons']         = 'sb_button_action';

   // SM 1.5.x
   $squirrelmail_plugin_hooks['right_main_after_header']['spam_buttons']  = 'sb_button_action';



   $squirrelmail_plugin_hooks['read_body_menu_top']['spam_buttons']       = 'sb_read_message_buttons';
   $squirrelmail_plugin_hooks['read_body_header']['spam_buttons']         = 'sb_button_action';



   $squirrelmail_plugin_hooks['read_body_header_right']['spam_buttons']   = 'sb_read_message_links';

}


/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns version info about this plugin
  *
  */
function spam_buttons_version()
{
   return '1.0';
}



/**
  * Takes care of spam/ham button click from mailbox list
  *
  */
function sb_button_action($args)
{

   include_once(SM_PATH . 'plugins/spam_buttons/functions.php');
   sb_button_action_do($args);

}



/**
  * Adds spam/ham buttons to mailbox listing
  *
  */
function sb_mailbox_list_buttons()
{

   include_once(SM_PATH . 'plugins/spam_buttons/functions.php');
   sb_mailbox_list_buttons_do();

}



/**
  * Adds spam/ham buttons to message display
  *
  */
function sb_read_message_buttons($args)
{

   include_once(SM_PATH . 'plugins/spam_buttons/functions.php');
   return sb_read_message_buttons_do($args);

}



/**
  * Adds spam/ham links to message options list on read body page
  *
  */
function sb_read_message_links()
{

   include_once(SM_PATH . 'plugins/spam_buttons/functions.php');
   sb_read_message_links_do();

}



?>
