<?php

/**
  * SquirrelMail SMTP Authentication Plugin
  *
  * Copyright (c) 2011-2012 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2011 Emmanuel Dreyfus <manu@netbsd.org>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage smtp_auth
  *
  */

global $smtp_auth_type, $saml_assertion_environment_variable,
       $compress_saml_assertion;


// What kind of SMTP authentication needs to be performed?  This will
// depend on your specific environment.
//
// Currently, this plugin provides authentication SAML SASL authentication.
// Other methods can be added by implementing your own function below, but
// you are also encouraged to share/contribute any authentication code that
// may be useful to others (contact the plugin authors to have new modules
// added).
//
// You may also use the SquirrelMail $smtp_auth_mech configuration variable
// to choose your authentication mechanism instead, leaving this value empty.
// Note that this setting always overrides SquirrelMail's $smtp_auth_mech.
//
//
//
// Set this to "saml_sasl" to use SAML SASL authentication.  This
// module will detect a SAML assertion provided by a SAML-compliant
// authentication module in the web server (such as mod_auth_mellon -
// see https://code.google.com/p/modmellon/ ) and pass it to the SMTP
// server instead of a password.  The SMTP server will need to use an
// authentication mechanism that knows how to validate the assertion -
// one package that provides such mechanisms is crudesaml
// (see http://ftp.espci.fr/pub/crudesaml/README )
// (Note that you must set all this up before using this plugin).
//
//
//
// Any other value is assumed to be the name of a custom function that
// you've defined at the bottom of this file.  That function will be given
// one parameter: an array consisting of these key value pairs (these
// are the keys): "auth_mech" (which has already been handled and can be
// ignored), "user", "pass", "host", "port" and "stream" (which is the open
// stream to the SMTP server).  The function must return TRUE if it was
// able to authenticate the user or FALSE otherwise.  An example of such a
// function is included herein.
//
//
// 
// $smtp_auth_type = '';  // use SquirrelMail's $smtp_auth_mech
// $smtp_auth_type = 'saml_sasl';
// $smtp_auth_type = 'custom_smtp_authenticate'; // see below for example
//
$smtp_auth_type = 'saml_sasl';



// For the SAML SASL authentication module, you can specify the name of
// the server environment variable that will hold the SAML assertion
//
$saml_assertion_environment_variable = 'MELLON_SAML_RESPONSE';



// For the SAML SASL authentication module, you can have the SAML
// assertion zlib-compressed (RFC 1950), which may be necessary
// if the assertion is somewhat large (includes many attributes?)
//
// Note that you'll need to make sure PHP has Zlib support enabled
// (compile with --with-zlib) to use this feature.
// See: http://php.net/manual/en/zlib.installation.php
//
//    0  =  Do not change the SAML assertion
//    1  =  Zlib-compress the SAML assertion before
//          authentication with SMTP server
//
$compress_saml_assertion = 0;



/**
  * This is an example of a custom SMTP authentication module 
  *
  * @param array $args An array consisting of these key value pairs (these
  *                    are the keys): "auth_mech" (which has already been
  *                    handled and can be ignored), "user", "pass", "host",
  *                    "port" and "stream" (which is the open stream to the
  *                    SMTP server)
  *
  * @return boolean TRUE if the user has been authenticated, FALSE otherwise
  *
  */
function custom_smtp_authenticate($args)
{

   // simple example - we'll just send some jibberish to the SMTP server
   // and check its response.  this won't work unless you SMTP server
   // understands jibberish
   //
   $bytes_written = fwrite($args['stream'], "AUTH JIBBERISH\r\n");
   if (!$bytes_written || !check_smtp_response($args['stream']))
      return FALSE;

   $bytes_written = fwrite($args['stream'], "more jibberish\r\n");
   if (!$bytes_written || !check_smtp_response($args['stream']))
      return FALSE;


   // no errors means authentication succeeded
   //
   return TRUE;

}



