<?php

/**
  * SquirrelMail SMTP Authentication Plugin
  *
  * Copyright (c) 2011-2012 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2011 Emmanuel Dreyfus <manu@netbsd.org>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage smtp_auth
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_smtp_auth()
{

   global $squirrelmail_plugin_hooks;


   // authenticate user to the SMTP server in order to send email
   //
   $squirrelmail_plugin_hooks['smtp_authenticate']['smtp_auth']
      = 'smtp_auth_authenticate_stub';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['smtp_auth']
      = 'smtp_auth_check_configuration_stub';

}



/**
  * Returns info about this plugin
  *
  */
function smtp_auth_info()
{

   return array(
                 'english_name' => 'SMTP Authentication',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                    'Emmanuel Dreyfus' => array(
                       'email' => 'manu@netbsd.org',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.23',
                 'requires_configuration' => 1,
                 'requires_source_patch' => 0,
                 'summary' => 'Provides additional SMTP authentication mechanisms.', 
                 'details' => 'This plugin provides additional SMTP authentication mechanisms to SquirrelMail.  It provides a SAML SASL built-in mechanism and allows you to easily create custom modules for any other mechanism.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function smtp_auth_version()
{
   $info = smtp_auth_info();
   return $info['version'];
}



/**
  * Authenticate user to the SMTP server in order to send email
  *
  */
function smtp_auth_authenticate_stub($args)
{
   include_once(SM_PATH . 'plugins/smtp_auth/functions.php');
   return smtp_auth_authenticate($args);
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function smtp_auth_check_configuration_stub()
{
   include_once(SM_PATH . 'plugins/smtp_auth/functions.php');
   return smtp_auth_check_configuration();
}



