<?PHP

   /*
    *  S/MIME 0.5
    *  this release Wouter Teepe <wouter@teepe.com> and Antonio Vasconcelos
    *  (c) 2003 (GNU GPL - see ../../COPYING)
    *
    *  This plugin enables the viewing of s/mime signed messages of the
    *  mime "multipart/signed" format.
    *  It enables the user to verify the message, the sender's certificate, to
    *  view and to download the certificate.
    *
    *  Adjust the ./config.php file to your local setup!
    *
    *  Although the subject of the plugin is secirity, I offer no guarantee
    *  at all for fitness for any particular purpose.
    *
    *  This plugin requires openssl 0.9.6 to be installed, it does not use
    *  the openssl extensions of php (that is a *feature*, since they're buggy)
    *
    *  Some paths of executables are needed, they are stored in config.php
    *
    *  This plugin has been built with squirrelmail 1.2.0rc1 as testing
    *  platform, but should (I think) work happily from squirrelmail version
    *  1.1.1.
    *  Testing software environment was Linux 2.4.4, php 4.0.6 and openssl 0.9.6
    *
    *  The plugin has not yet been intentionally adjusted for platform portability
    *  Any suggestions on this subject are welcome.
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  [vasco@threatconn.com] - 2003.04.10
    *  modified to work with squirrelmail 1.2.11, PHP 4.3.1, openssl 0.9.7a in
    *  linux with kernel 2.4.18
    *
    */

   chdir("..");
   if (!defined('SM_PATH'))
      define('SM_PATH','../');

   if (file_exists(SM_PATH . 'include/validate.php')) {
      include_once(SM_PATH . 'include/validate.php');
   } else {
      if (file_exists(SM_PATH . 'src/validate.php'))
         include_once(SM_PATH . 'src/validate.php');
   }
   include_once("../plugins/smime/functions.php");

# [vasco]
	if(!isset($cert)) $cert=$_GET['cert'];

   header("Pragma: ");
   header("Cache-Control: cache");

   
   // This function is verified to work with Netscape and the *very latest*
   // version of IE.  I don't know if it works with Opera, but it should now.
   function DumpHeaders($type0, $type1, $filename, $force)
   {
      global $HTTP_USER_AGENT;
      
      $isIE = 0;
      if (strstr($HTTP_USER_AGENT, 'compatible; MSIE ') !== false &&
          strstr($HTTP_USER_AGENT, 'Opera') === false) {
        $isIE = 1;
      }
      
      $filename = ereg_replace('[^-a-zA-Z0-9\.]', '_', $filename);
      
      // A Pox on Microsoft and it's Office!
      if (! $force)
      {
          // Try to show in browser window
          header("Content-Disposition: inline; filename=\"$filename\"");
	  header("Content-Type: $type0/$type1; name=\"$filename\"");
      }
      else
      {
          // Try to pop up the "save as" box
	  // IE makes this hard.  It pops up 2 save boxes, or none.
	  // http://support.microsoft.com/support/kb/articles/Q238/5/88.ASP
	  // But, accordint to Microsoft, it is "RFC compliant but doesn't
	  // take into account some deviations that allowed within the
	  // specification."  Doesn't that mean RFC non-compliant?
	  // http://support.microsoft.com/support/kb/articles/Q258/4/52.ASP
	  //
	  // The best thing you can do for IE is to upgrade to the latest
	  // version
          if ($isIE) {
	     // http://support.microsoft.com/support/kb/articles/Q182/3/15.asp
	     // Do not have quotes around filename, but that applied to
	     // "attachment"... does it apply to inline too?
	     //
	     // This combination seems to work mostly.  IE 5.5 SP 1 has
	     // known issues (see the Microsoft Knowledge Base)
             header("Content-Disposition: inline; filename=$filename");
             
	     // This works for most types, but doesn't work with Word files
             header("Content-Type: application/download; name=\"$filename\"");

             // These are spares, just in case.  :-)
             //header("Content-Type: $type0/$type1; name=\"$filename\"");
             //header("Content-Type: application/x-msdownload; name=\"$filename\"");
             //header("Content-Type: application/octet-stream; name=\"$filename\"");
	  } else {
             header("Content-Disposition: attachment; filename=\"$filename\"");
	     // application/octet-stream forces download for Netscape
             header("Content-Type: application/octet-stream; name=\"$filename\"");
	  }
      }
   }

   if (isset($cert)) {
      DumpHeaders("application", "octet-stream", "cert.pem", 1);
      $fd = fopen($cert_in_dir . $cert, "r");
      while (!feof ($fd)) {
         $buffer = fgets($fd, 4096);
         echo $buffer;
      }
      fclose ($fd);
   }
?>
