<?php

   /*
    *  S/MIME 0.5
    *  this release Wouter Teepe <wouter@teepe.com> and Antonio Vasconcelos
    *  (c) 2003 (GNU GPL - see ../../COPYING)
    *
    *  This plugin enables the viewing of s/mime signed messages of the
    *  mime "multipart/signed" format.
    *  It enables the user to verify the message, the sender's certificate, to
    *  view and to download the certificate.
    *
    *  Adjust the ./config.php file to your local setup!
    *
    *  Although the subject of the plugin is secirity, I offer no guarantee
    *  at all for fitness for any particular purpose.
    *
    *  This plugin requires openssl 0.9.6 to be installed, it does not use
    *  the openssl extensions of php (that is a *feature*, since they're buggy)
    *
    *  Some paths of executables are needed, they are stored in config.php
    *
    *  This plugin has been built with squirrelmail 1.2.0rc1 as testing
    *  platform, but should (I think) work happily from squirrelmail version
    *  1.1.1.
    *  Testing software environment was Linux 2.4.4, php 4.0.6 and openssl 0.9.6
    *
    *  The plugin has not yet been intentionally adjusted for platform portability
    *  Any suggestions on this subject are welcome.
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    * 2003.04: vasco@all-2-it.com, vasco@threatconn.com
    *          a) Updated to work with current versions of Squirrel Mail (1.2.11),
    *          Openssl (0.9.7a) and PHP (4.3.1) (w/o register_globals).
    *
    *          b) Changed a rename() to copy()+unlink() as rename() doesn't work
    *          when /tmp and $cert_in_dir are in different filesystems. THIS IS
    *          A QUICK HACK TO MAKE IT WORK ON MY SYSTEM, IT MAY BREAK SOMETHING
    *          AS copy()+unlink() IS NOT ATOMIC LIKE rename().
    *
    *          c) Added some text explaining a few facts of life with openssl.
    *          
    */

   global $data_dir;		// existing global, the squirrelmail data dir

   // The path to the the openssl executable [new var]
   global $openssl;
   $openssl = "/usr/bin/openssl";

   // The path to echo [new var]
   global $echo;
   $echo = '/bin/echo';

   // The directory where the root CA's certificates live
   // Read the README file for info about adding you own (private) CA to this directory
   global $cadir;
   $cadir = "/etc/ssl/certs";

   // Easy root certificate setup [new var]
   // Might conflict with $cadir above, openssl docs are unclear.  I've
   //   tested with  both defined and have had no probs, but i have no
   //   certificates in $cadir.
   // Pointer to a file containing trusted root certificates, one is
   //   included with the smime plugin, update $easycerts below to
   //   include the full path to your plugin directory (it will be
   //   used by an external command).
   global $easycerts;
   $easycerts = "";
   // $easycerts = "-CAfile /opt/squirrelmail/plugins/smime/ca-bundle.crt";

   // The directory where signer's ceritificates are stored
   // must be readable and writeable by the user httpd runs as.
   global $cert_in_dir;
   $cert_in_dir = $data_dir . "certs-in/";

?>
