<?php
   /*
    *  Small Calendar
    *  By Nick Rosenberg <nick@dolphins-angels.com>
    *  This is an implementation of the calendar script
    *  at http://www.cascade.org.uk/software/php/calendar
    *  by David Wilkinson with a few mods to make it work 
    *  with Squirrelmail.
    *
    *  NOTE: This script requires the calendar module to work 
    *  properly as the days link directly to it. 
    *
    */

   function squirrelmail_plugin_init_smallcal() {
      global $squirrelmail_plugin_hooks;
      $squirrelmail_plugin_hooks["left_main_after"]["smallcal"] = "addsmallcal_left";
   }

   include_once('../plugins/smallcal/Calendar.php');

   // Function to pad dates for compatability with calendar.
   function pad($var, $len)
   {
	while (strlen($var) < $len)
	{
	   $var = "0".$var;
	}

	return $var;
   }

   class SmallCalendar extends Calendar
   {    
	function getCalendarLink($month, $year)    
	{        
	    $s = getenv('SCRIPT_NAME');        
	    return "$s?month=$month&year=$year";    
	}
 
    	function getDateLink($day, $month, $year)    
	{        
	    // Pad date vars
	    $day = pad($day, 2);
	    $month = pad ($month, 2);
	    $year = pad ($year, 4);

	    $s = '../plugins/calendar/day.php';        
	    return "$s?day=$day&month=$month&year=$year";
	}
    }

    function addsmallcal_left() 
    {
	global $year, $month, $todayis, $calendardata;

	$d = getdate(time());

	if ($month == "")
	{
	    $month = $d["mon"];
	}

	if ($year == "")
	{
	    $year = $d["year"];
	}

	echo '<style type="text/css">';
	echo '<!--.calendarHeader { font-weight: bolder; color: #770000; }.calendarToday { font-weight: bolder; }--></style>';

	$cal = new SmallCalendar;
	echo "<br>";
	echo "<br>";
	echo $cal->getMonthView($month, $year);
   }
?>
