<?php
  /*********************************************************
   * $Id: options.php,v 1.2 2004/01/17 23:35:08 dwight Exp $
   * 
   * Handle the options settings for the Sigtag plugin.
   *********************************************************/
include_once( SM_PATH . 'plugins/sigtag/functions.php' );

/*********************************************************
 * s i g t a g O p t i o n s H a n d l e r
 *
 * Build the array members to be added to the Squirrelmail
 * Personal Info page.  I only need to add a 'Activate'
 * boolean and textarea where the user can enter/edit his
 * taglines.  I'll probably want to come up with a way to
 * give the user the option to just upload a text file of
 * taglines instead of using the textarea.
 *********************************************************/
function sigtagOptionsHandler() {
  global $username, $data_dir, $optpage_data;

  $sigtagEnabled = getPref( $data_dir, $username, 'sigtagEnabled' );
  $tagarray = sigtagGetTags( $data_dir, $username );
  $tagcount = sizeof($tagarray);

  $optpage_data['grps']['SIGTAGS_PLUGIN'] = _('Random Signature Taglines');
  $sigtagVals = array();
  $sigtagVals[] = array(
			'name' => 'sigtagEnabled',
			'caption' => _("Enable"),
			'initial_value' => $sigtagEnabled,
			'type' => SMOPT_TYPE_BOOLEAN,
			'refresh' => SMOPT_REFRESH_NONE
			);

  $initial = ($tagcount ? implode( "", $tagarray ) : ' ' );
  $sigtagVals[] = array(
			'name' => 'sigtag_taglines',
			'caption' => _('Taglines'),
			'type' => SMOPT_TYPE_TEXTAREA,
			'initial_value' => $initial,
			'save' => 'sigtagSaveOptions',
			'size' => SMOPT_SIZE_LARGE,
			'refresh' => SMOPT_REFRESH_NONE
			);

  // Let the user know how may taglines he currently has saved.
  if( $tagcount ) {
    $comment = _('There are') . ' ' . $tagcount . ' ' . _('taglines saved');
  } else {
    $comment = _('No taglines saved');
  }
  $sigtagVals[] = array(
			'name' => 'sigtag_count',
			'caption' => '',
			'type' => SMOPT_TYPE_COMMENT,
			'comment' => $comment,
			'refresh' => SMOPT_REFRESH_NONE
			);

  $optpage_data['vals']['SIGTAGS_PLUGIN'] = $sigtagVals;
} // function sigtagOptionsHandler


/*********************************************************
 * s i g t a g S a v e O p t i o n s
 *
 * Saves the user's settings from the options page.  Since
 * the sigtagEnabled setting is saved by Squirrelmail
 * directly, the only thing that I really need to deal with
 * here is the current contents of the taglines textarea.
 *********************************************************/
function sigtagSaveOptions( $option ) {
  global $username, $data_dir;

  $tagarray = array();
  $taglines = explode( "\r\n", rtrim( $option->new_value ));
  // Remove newlines and empty lines.
  for( $l = 0; $l < count( $taglines ); $l++ ) {
    $line = rtrim( $taglines[$l] );
    if( $line != "" ) {
      $tagarray[] = $line;
    }
  }

  // Save the tag lines
  sigtagSaveTags( $data_dir, $username, $tagarray );

  // If taglines are enabled, qppend a tag now so that the sig will be
  // ready for the first compose.
  $sigtagEnabled = getPref( $data_dir, $username, 'sigtagEnabled' );
  if( $sigtagEnabled ) {
    sigtagAppendTag();
  }
} // function sigtagSaveOptions

?>