<?php
  /*********************************************************
   * $Id: functions.php,v 1.2 2004/01/17 23:35:08 dwight Exp $
   *
   * This file contains the meat of the sigtag plugin
   *********************************************************/
define( 'TAGSFX', ".sigtags" );

/*********************************************************
 * s i g t a g A p p e n d T a g
 *
 * Select a random line from the user's sigtag file and
 * replace the current last line of the existing signature.
 *********************************************************/
function sigtagAppendTag() {
  global $username, $data_dir;

  $sigtagEnabled = getPref( $data_dir, $username, 'sigtagEnabled' );
  if( !$sigtagEnabled ) { return; } 

  $sigtagArray = sigtagGetTags( $data_dir, $username );
  $sigtagSize = sizeof( $sigtagArray );
  if( $sigtagSize == 0 ) {
    return;
  }
  srand((double) microtime() * 1000000);
  $tagNum = rand(0, count($sigtagArray)-1);
  $tag = $sigtagArray[$tagNum];
  if( strlen( $signature = getSig( $data_dir, $username, 'g' )) == 0 ) {
    $sig = array();
  } else {
    $sig = explode( "\r\n", $signature );
  }
  
  // Remove empty lines at the end of the sig.
  for( $i = sizeof($sig) - 1; $i >= 0 && $sig[$i] == ""; $i-- ) {
    unset( $sig[$i] );
  }
  array_splice( $sig, -1, 1, $tag );
  $sigString = implode( "\r\n", $sig );
  setSig( $data_dir, $username, 'g', $sigString );
} // function sigtagAppendTag


/*********************************************************
 * s i g t a g S a v e T a g s
 *
 * Save a list of sigtag lines in a file in the data
 * directory.  I save this in a file separate from the
 * user options file because I don't know how many sigtags
 * the user will have (could be several hundred) and
 * besides making the options file kind of ugly, having a
 * line too long could potentially cause problems for the
 * other option parsing routines.
 *********************************************************/
function sigtagSaveTags( $data_dir, $username, $taglist ) {
  $filename = getHashedFile( $username, $data_dir, "$username" . TAGSFX );
  /* Open the file for writing, or display an error to the user. */
  if( !$file = @fopen( "$filename.tmp", 'w' )) {
    logout_error( sprintf( _( "Sigtag file \"%s.tmp\" could not be opened.  Contact your system administrator to resolve this issue." ), $filename ));
    exit;
  }
  for( $i = 0; $i < count($taglist); $i++ ) {
    if( @fwrite( $file, sprintf("%s\n", $taglist[$i])) === FALSE ) {
      logout_error( sprintf( _( "Sigtag file \"%s.tmp\" could not be written.  Contact your system administrator to resolve this issue." ), $filename ));
      exit;
    }
  }
  fclose( $file );
  @unlink( $filename );
  @rename( $filename . '.tmp', $filename );
  @chmod( $filename, 0600 );
} // function sigtagSaveTags


/*********************************************************
 * s i g t a g G e t T a g s
 *
 * Reads in the user's signature tags and returns them in
 * an array.
 *********************************************************/
function sigtagGetTags( $data_dir, $username ) {
  $filename = getHashedFile( $username, $data_dir, "$username" . TAGSFX );
  $fileresults = @file( $filename );
  if( $fileresults ) {
    return( $fileresults );
  }
  return( array() );
} // function sigtagGetTags
?>