<?php

/**
  * SquirrelMail Show SSL Link Plugin
  * Copyright (c) 2002 Jeff W. <venge@lokalsound.com>
  * Copyright (c) 2003-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage show_ssl_link
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_show_ssl_link() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_cookie']['show_ssl_link'] = 'ssl_link_set_session_vars';
   $squirrelmail_plugin_hooks['login_form']['show_ssl_link'] = 'show_ssl_link';
   $squirrelmail_plugin_hooks['login_verified']['show_ssl_link'] = 'ssl_get_extra_form_vars';
   $squirrelmail_plugin_hooks['webmail_top']['show_ssl_link'] = 'log_out_of_https';

}



/** @ignore */
if (!defined('SM_PATH')) define('SM_PATH', '../../');



/**
  * Returns version info about this plugin
  *
  */
function show_ssl_link_version() 
{

   return '2.2';

}



/**
  * Figure out if user came in using HTTPS, or by clicking
  * on secure link, etc.
  *
  */
function ssl_link_set_session_vars() 
{

   include_once(SM_PATH . 'plugins/show_ssl_link/functions.php');
   ssl_link_set_session_vars_do();

}



/**
  * Grab extra variables sent with login information
  *
  * Specifically grabs the value of the "stay in ssl" checkbox
  *
  */
function ssl_get_extra_form_vars() 
{

   include_once(SM_PATH . 'plugins/show_ssl_link/functions.php');
   ssl_get_extra_form_vars_do();

}



/**
  * Show the SSL link on the page bottom (or checkbox
  * for user to remain in SSL after login)
  *
  */
function show_ssl_link() 
{

   include_once(SM_PATH . 'plugins/show_ssl_link/functions.php');
   show_ssl_link_do();

}



/**
  * Return to HTTP protocol after login if necessary
  *
  */
function log_out_of_https() 
{

   include_once(SM_PATH . 'plugins/show_ssl_link/functions.php');
   log_out_of_https_do();

}



?>
