<?php


/**
  * SquirrelMail Show SSL Link Plugin
  * Copyright (c) 2002 Jeff W. <venge@lokalsound.com>
  * Copyright (c) 2003-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage show_ssl_link
  *
  */



   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



/**
  * Figure out if user came in using HTTPS, or by clicking
  * on secure link, etc.
  *
  */
function ssl_link_set_session_vars_do() 
{

   global $https_logoff_count, $plugin_show_ssl_link_cameInUnencrypted,
          $show_ssl_link_orig_url, $mySecurePort;

   $https_logoff_count = 0;
   compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');


   include_once (SM_PATH . 'plugins/show_ssl_link/config.php');


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS, $HTTP_GET_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
      $_GET = $HTTP_GET_VARS;
   }


   // grab port the user came in on
   //
   if (isset($_SERVER['SERVER_PORT']))
      $serverPort = $_SERVER['SERVER_PORT'];
   else
      $serverPort = 0;


   // figure out what port we should be comparing
   //
   if (isset($mySecurePort))
      $targetHttpsPort = $mySecurePort;
   else
      $targetHttpsPort = '443';


   if ( $serverPort == $targetHttpsPort && isset($_GET['do_secure_login'])) 
//   if ( isset($_SERVER['HTTPS']) && isset($_GET['do_secure_login'])) 
   {
      $plugin_show_ssl_link_cameInUnencrypted = 'yes';
      compatibility_sqsession_register($plugin_show_ssl_link_cameInUnencrypted, 
                                       'plugin_show_ssl_link_cameInUnencrypted');
      if (isset($_GET['orig_url']))
      {
         $show_ssl_link_orig_url = $_GET['orig_url'];
         compatibility_sqsession_register($show_ssl_link_orig_url,
                                          'show_ssl_link_orig_url');
      }
   }

}



/**
  * Show the SSL link on the page bottom (or checkbox
  * for user to remain in SSL after login)
  *
  */
function show_ssl_link_do() 
{

   global $my_ssl_url, $my_ssl_extra,
          $allVirtualDomainsAreUnderOneSSLHost, $mySecurePort, 
          $https_logoff_count;


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS, $HTTP_COOKIE_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
      $_COOKIE = $HTTP_COOKIE_VARS;
   }


   include_once (SM_PATH . 'plugins/show_ssl_link/config.php');


   if (empty($my_ssl_url)) {

      $requestHost = $_SERVER['HTTP_HOST'];

      if (isset($mySecurePort))
      {
         if (!empty($mySecurePort))
            $mySecurePort = ':' . $mySecurePort;

         list($host, $port) = preg_split('/:/', $requestHost);
         $newRequestHost = $host . $mySecurePort;
      }
      else
         $newRequestHost = $requestHost;


      $pathURI = $_SERVER['REQUEST_URI'];
      $paramsURI = '';
      if (preg_match('/(.*)\?(.*)/', $_SERVER['REQUEST_URI'], $matches))
      {
         if (isset($matches[1])) $pathURI = $matches[1];
         if (isset($matches[2])) $paramsURI = $matches[2];
      }

      $my_ssl_url = 'https://'
                . $newRequestHost . $pathURI . '?do_secure_login=yes';

      if (!empty($allVirtualDomainsAreUnderOneSSLHost))
         $my_ssl_url = 'https://' . $allVirtualDomainsAreUnderOneSSLHost
                   . $newRequestHost . $pathURI . '?do_secure_login=yes';

      if (!empty($paramsURI))
         $my_ssl_url = $my_ssl_url . '&' . $paramsURI;

   }

   // if we have a secure URL already defined, need to save the
   // current URL in case we have to come back to it under http
   // after login
   //
   else
   {
      // note that we assume that this URL doesn't 
      // already have any query string on the end
      //
      $my_ssl_url .= '?do_secure_login=yes&orig_url=' 
                   . urlencode($_SERVER['HTTP_HOST']);
   }


   // grab port the user came in on
   //
   if (isset($_SERVER['SERVER_PORT']))
      $serverPort = $_SERVER['SERVER_PORT'];
   else
      $serverPort = 0;


   // figure out what port we should be comparing
   //
   if (isset($mySecurePort))
      $targetHttpsPort = $mySecurePort;
   else
      $targetHttpsPort = '443';


   bindtextdomain ('show_ssl_link', SM_PATH . 'locale');
   textdomain ('show_ssl_link');


// old way...
//   if ( ! isset($_SERVER['HTTPS']) ) {
   if ( $serverPort != $targetHttpsPort ) {
      $show_secure_login = "<center><br><a href=\"$my_ssl_url\"> "
      . _("Secure Login") . " </a><br> "
      . (!empty($my_ssl_extra) ? _($my_ssl_extra) : '') . " </center> \n";
      echo $show_secure_login;
   }
   else
   {
      $show_secure_login = "<center><br /><input type='checkbox' "
      . ((isset($_COOKIE['smstaysecure']) && $_COOKIE['smstaysecure'] == 1)
      ? ' CHECKED ' : '')
      . "value='1' name='stayInSSL' id='stayCheckbox'><label for='stayCheckbox'> "
      . _("Remain Secure After Login") . " </label><br /> "
      . (!empty($my_ssl_in_ssl_extra) ? _($my_ssl_in_ssl_extra) : '') . " </center> \n";
      echo $show_secure_login;
   }


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/**
  * Grab extra variables sent with login information
  *
  * Specifically grabs the value of the "stay in ssl" checkbox
  *
  */
function ssl_get_extra_form_vars_do()
{

   global $stayInSSL;
   compatibility_sqextractGlobalVar('stayInSSL');
   compatibility_sqsession_register($stayInSSL, 'stayInSSL');

   // set a cookie to remember this setting that expires in 30 days
   //
   @setcookie('smstaysecure', $stayInSSL, (time()+60*60*24*30));

}



/**
  * Return to HTTP protocol after login if necessary
  *
  */
function log_out_of_https_do() 
{

   global $go_back_to_http_after_login, $stay_in_https_if_logged_in_using_https,
          $plugin_show_ssl_link_cameInUnencrypted, $show_ssl_link_orig_url,
          $mySecurePort;


   include_once (SM_PATH . 'plugins/show_ssl_link/config.php');


   if ($go_back_to_http_after_login == 0) return;


   if (!compatibility_sqsession_is_registered('plugin_show_ssl_link_cameInUnencrypted')
       && $stay_in_https_if_logged_in_using_https)
      return;


   global $stayInSSL;
   compatibility_sqextractGlobalVar('stayInSSL');
   if ($stayInSSL)
      return;


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   global $https_logoff_count;
   compatibility_sqextractGlobalVar('https_logoff_count');
   if (!isset($https_logoff_count))
   {
      $https_logoff_count = 0;
      compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');
   }


   // need to fix the sq_base_url session varible, since
   // it is put in the session in redirect.php with
   // the https protocol before we get here 
   //
   global $sq_base_url, $notStandardHttpPort;
   compatibility_sqextractGlobalVar('sq_base_url');
   $sq_base_url = str_replace('https://', 'http://', $sq_base_url);
   if (isset($notStandardHttpPort) && !empty($notStandardHttpPort))
      $sq_base_url = preg_replace('/:\d\//', ":$notStandardHttpPort/", $sq_base_url);
   else
      $sq_base_url = preg_replace('/:\d\//', '', $sq_base_url);
   compatibility_sqsession_register($sq_base_url, 'sq_base_url');

  
   // grab port the user came in on
   //
   if (isset($_SERVER['SERVER_PORT']))
      $serverPort = $_SERVER['SERVER_PORT'];
   else
      $serverPort = 0;


   // figure out what port we should be comparing
   //
   if (isset($mySecurePort))
      $targetHttpsPort = $mySecurePort;
   else
      $targetHttpsPort = '443';


// old way...
//   if ( ! isset($_SERVER['HTTP']) && $https_logoff_count == 0)
   if ( $serverPort == $targetHttpsPort && $https_logoff_count == 0)
   {

      global $show_ssl_link_orig_url;
      compatibility_sqextractGlobalVar('show_ssl_link_orig_url');
      if (isset($show_ssl_link_orig_url))
         $originalHost = urldecode($show_ssl_link_orig_url);
      else
         $originalHost = $_SERVER['HTTP_HOST'];


      $https_logoff_count++;
      compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');
      $location = 'http://' . $originalHost . $notStandardHttpPort 
         . $_SERVER['PHP_SELF'];

      displayHtmlHeader('',
         "\n<META HTTP-EQUIV=\"REFRESH\" CONTENT=\"0;URL=$location\">\n");

      // note that this causes a pop-up in some browsers
      // that notifies you you are leaving a secure site
      //
      //header("Location: $location");

      exit();

   }

} 



?>
