<?php
/* HTTPS link by venge@lokalsound.com
         expanded by pdontthink@angrynerds.com */



   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



function ssl_link_set_session_vars_do() {

   global $https_logoff_count, $plugin_show_ssl_link_cameInUnencrypted;

   $https_logoff_count = 0;
   compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS, $HTTP_GET_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
      $_GET = $HTTP_GET_VARS;
   }

   if ( isset($_SERVER['HTTPS']) && isset($_GET['do_secure_login'])) {
      $plugin_show_ssl_link_cameInUnencrypted = 'yes';
      compatibility_sqsession_register($plugin_show_ssl_link_cameInUnencrypted, 
                                       'plugin_show_ssl_link_cameInUnencrypted');
   }

}



function show_ssl_link_do() {

   global $my_ssl_url, $my_ssl_text, $my_ssl_extra,
          $allVirtualDomainsAreUnderOneSSLHost, $mySecurePort, 
          $https_logoff_count;


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/show_ssl_link/config.php');
   else
      include_once ('../plugins/show_ssl_link/config.php');


   if (empty($my_ssl_url)) {

      $requestHost = $_SERVER['HTTP_HOST'];

      if (isset($securePort))
      {
         if (!empty($securePort))
            $securePort = ':' . $securePort;

         list($host, $port) = preg_split('/:/', $requestHost);
         $newRequestHost = $host . $securePort;
      }
      else
         $newRequestHost = $requestHost;


      $my_ssl_url = 'https://'
                . $newRequestHost . $_SERVER['REQUEST_URI'] . '?do_secure_login=yes';

      if (!empty($allVirtualDomainsAreUnderOneSSLHost))
         $my_ssl_url = 'https://' . $allVirtualDomainsAreUnderOneSSLHost
                   . $newRequestHost . $_SERVER['REQUEST_URI'] . '?do_secure_login=yes';

   }


   if ( ! isset($_SERVER['HTTPS']) ) {
      $show_secure_login = "<center><br><a href=\"$my_ssl_url\"> "
      . _($my_ssl_text) . " </a><br> "
      . (!empty($my_ssl_extra) ? _($my_ssl_extra) : '') . " </center> \n";
      echo $show_secure_login;
   }
}



function log_out_of_https_do() {

   global $go_back_to_http_after_login, $stay_in_https_if_logged_in_using_https,
          $plugin_show_ssl_link_cameInUnencrypted;


   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/show_ssl_link/config.php');
   else
      include_once ('../plugins/show_ssl_link/config.php');


   if ($go_back_to_http_after_login == 0) return;


   if (!compatibility_sqsession_is_registered('plugin_show_ssl_link_cameInUnencrypted')
       && $stay_in_https_if_logged_in_using_https)
      return;


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   global $https_logoff_count;
   compatibility_sqextractGlobalVar('https_logoff_count');
   if (!isset($https_logoff_count))
   {
      $https_logoff_count = 0;
      compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');
   }


   if ( ! isset($_SERVER['HTTP']) && $https_logoff_count == 0)
   {

      $https_logoff_count++;
      compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');
      $location = 'http://' . $_SERVER['HTTP_HOST']
         . $_SERVER['PHP_SELF'];
      displayHtmlHeader('',
         "\n<META HTTP-EQUIV=\"REFRESH\" CONTENT=\"0;URL=$location\">\n");
      exit();

   }

}

?>
