<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

function approve_todo_admin() {
    global $username;

/**********************************************************************
   Users that have access to the shared todo administration interface
    should be entered into the following array.
***********************************************************************/

    $admins = array(	"bjarne.maschoreck@satconsulting.dk",
			"bjarne@maschoreck.dk",
			"bjarne.maschoreck@satdevelopment.dk",
			"bjarne@tvpc.dk",
			"jan.iversen@satconsulting.dk");

/**********************************************************************   
 *    Then those users can go to Options->Shared Todo List
 *    Administration.  
**********************************************************************/


    $approved = false; 
    if (isset($_SESSION['username'])) {
        $username = $_SESSION['username'];
    }
    foreach ($admins as $admin) {
        if (isset($username)) {
            if (strtolower($username) == strtolower($admin)) {
                $approved = true;
            }
        }
    }
    return $approved;
}

function squirrelmail_plugin_init_todo() {
    global $squirrelmail_plugin_hooks;
    $approved = approve_todo_admin();
    $squirrelmail_plugin_hooks["menuline"]["todo"] = "todo";
    if ($approved == true) { 
        $squirrelmail_plugin_hooks['optpage_register_block']['todo'] = 'todo_admin_block';
    }
}

function todo() {
    //Add Todo link to upper menu
    displayInternalLink("plugins/todo/todo_check.php",_("Todo"),"right");
    echo "&nbsp;&nbsp\n";
}

function todo_admin_block() {
    global $optpage_blocks;
    $optpage_blocks[] = array(
        'name' => _("Shared Todo List Administration"),
        'url'  => '../plugins/todo/admin_options.php',
        'desc' => _("Create and maintain shared todo lists. Assign access by user or create publicly available todo lists"),
        'js'   => false
        );
}

?>
