<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

$tododata = array();
    
//read events into array

function readtododata() {
    global $tododata, $username, $data_dir, $todo;

    if ($todo != 'Personal') {
        $todo_name = $todo;
    }
    else {
        $todo_name = $username;
    }

    $filename = getHashedFile($username, $data_dir, "$todo_name.todo");

    $lastidx = 0;

    if (file_exists($filename)){
        $fp = fopen ($filename,'r');

        if ($fp){
            while ($fdata = fgetcsv ($fp, 4096, '|')) {
                $tododata[$fdata[0]] = array( 'idx' => $fdata[0],
                                              'startdate' => $fdata[1],
                                              'title' => $fdata[2],
                                              'duration' => $fdata[3],
                                              'description' => $fdata[4],
                                              'priority' => $fdata[5],
                                              'nick' => $fdata[6] );
		if ($fdata[0] > $lastidx)
			$lastidx = $fdata[0];
            }
            fclose ($fp);
        }
    }

    return($lastidx);
}

//read user events into array and return it

function readtododata_array($t,$n) {
    global $username, $data_dir;

    $tarr = array();

    if ($t != 'Personal') {
        $todo_name = $t;
    }
    else {
        $todo_name = $username;
    }

    $filename = getHashedFile($username, $data_dir, "$todo_name.todo");

    if (file_exists($filename)){
        $fp = fopen ($filename,'r');

        if ($fp){
            while ($fdata = fgetcsv ($fp, 4096, '|')) {
                $tarr[$fdata[0]] = array( 'idx' => $fdata[0],
                                         	'startdate' => $fdata[1],
                                         	'title' => $fdata[2],
                                         	'duration' => $fdata[3],
                                         	'description' => $fdata[4],
                                         	'priority' => $fdata[5],
                                         	'nick' => $fdata[6],
                                          	'listname' => $t );
            }
            fclose ($fp);
        }
    }

    return($tarr);
}

//makes events persistant

function writetododata() {
    global $tododata, $username, $data_dir, $todo;

    if ($todo != 'Personal') {
        $todo_name = $todo;
    }
    else {
        $todo_name = $username;
    }

    $filetmp = getHashedFile($username, $data_dir, "$todo_name.todo.tmp");
    $filename = getHashedFile($username, $data_dir, "$todo_name.todo");

    $fp = fopen ($filetmp,"w");
    if ($fp) {
	foreach ($tododata as $t)
	{
		if ($t[idx] != -1)
		{
			$todstr = "$t[idx]|$t[startdate]|$t[title]|$t[duration]|$t[description]|$t[priority]|$t[nick]\n";
			fwrite($fp, $todstr, 4096);
		}
	}
        fclose ($fp);
        rename($filetmp,$filename);
    }
}

function writetododata_array($t,$tdata)
{
	global $todo, $tododata;

	$tmp = $todo;
	$tmpdata = $tododata;

	$todo = $t;
	$tododata = $tdata;

	writetododata();

	$todo = $tmp;
	$tododata = $tmpdata;
}

//deletes event from file

function delete_event($idx) {
    global $tododata, $username, $data_dir, $todo;

    if ($todo != 'Personal') {
        $todo_name = $todo;
    }
    else {
        $todo_name = $username;
    }

    $filename = getHashedFile($username, $data_dir, "$todo_name.todo");
    $fp = fopen ($filename,'r');
    if ($fp){
        while ($fdata = fgetcsv ($fp, 4096, "|")) {
            if ($fdata[0]==$idx) {
            // do nothing
            } else {
                $tododata[$fdata[0]] = array( 'idx' => $fdata[0],
                                              'startdate' => $fdata[1],
                                              'title' => $fdata[2],
                                              'duration' => $fdata[3],
                                              'description' => $fdata[4],
                                              'priority' => $fdata[5],
                                              'nick' => $fdata[6] );
            }
        }
        fclose ($fp);
    }
    writetododata();

}

?>
