<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

 include_once ("todo_data.php");
 include_once ("functions.php");
 include_once ("shared_functions.php");
 chdir("..");
 include_once ("../src/validate.php");
 include_once('../functions/strings.php');
 include_once('../config/config.php');
 include_once('../functions/page_header.php');
 include_once('../src/load_prefs.php');

global $username, $data_dir, $color, $todo;

extract($_POST);

$mynick = get_user_nick($data_dir, $username);

if (isset($chgsel) || isset($delsel))
{
	$usedlists = array();
	$lcnt = 0;

	// Build list of changes.

	for ($c=0; $c<$maxcnt; $c++)
	{
		if (isset(${"cb$c"}))
		{
			$l = split("_",${"cb$c"});
			$usedlists[$l[1]] = $usedlists[$l[1]] . $l[0] .";";
		}
	}

	// Do the changes.

	$darr = split("/",$newdate);

	if (checkdate($darr[1],$darr[2],$darr[0]))
	{
		$newdate = date("Ymd", mktime(0,0,0,$darr[1],$darr[2],($darr[0] > 100) ? $darr[0] : $darr[0]+1900));
		$tarr = array();
		foreach($usedlists as $k => $v)
		{
			$tarr = readtododata_array(urldecode($k),$mynick);
			$ids = split(";",$v);
			foreach ($ids as $id)
			{
				if ($id != "")
					if (isset($chgsel))
						$tarr[$id][startdate] = $newdate;
					else
						$tarr[$id][idx] = -1;
			}
				
			writetododata_array(urldecode($k),$tarr);
		}
	}

	Header("Location:todo_check.php");
	exit();
} else
if (isset($addnew))
{
	Header("Location:event_create.php?fromtoday=1");
	exit();
} else
if (isset($showall))
	$showall = 1;

displayPageHeader($color, "None");

$shared_list = read_todo_list($data_dir, 'shared');
$public_list = read_todo_list($data_dir, 'public');

$ccode = get_user_code($data_dir, $username);
if ($ccode == '') {
    $todo_num = count($shared_list);
    $ccode = str_repeat("0", $todo_num);
}

// Find content for each list and build arrays.

$tlists = array();

$count = count($public_list); 
for ($x=0;$x<$count;$x++)
	$tlists[$public_list[$x]] = readtododata_array($public_list[$x],$mynick);

$code = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
for ($x=0;$x<count($shared_list);$x++)
	if ($code[$x] > 0)
		$tlists[$shared_list[$x]] = readtododata_array($shared_list[$x],$mynick);

$tlists["Personal"] = readtododata_array("Personal",$mynick);

// Expand the lists to single array and sort.

$cnt = 0;
$mts = array();
foreach ($tlists as $tlist)
	foreach ($tlist as $t)
	{
		$mts[$cnt] = array('idx' => $t[idx], 'startdate' => $t[startdate], 'title' => $t[title], 'priority' => $t[priority], 'nick' => $t[nick], 'tlist' => $t[listname]);
		$cnt++;
	}

usort($mts,sortbydatepri);

// Print header for global task list.

print "<form action=\"todo_check.php\" method=post>";
print "<br><table width=\"60%\" bgcolor=\"$color[9]\"align=center>\n";
print "<tr><td align=center><b>Todays Personal Tasklist</b></td></tr><tr><td>\n";
print "<table width=\"100%\" align=center bgcolor=\"$color[4]\">\n";

print "<tr>";
print "<td width=\"70px\"><h4>Start date</h4></td>";
print "<td width=\"240px\"><h4>Title</h4></td>";
print "<td width=\"60px\"><h4>Priority</h4></td>";
print "<td width=\"160px\"><h4>Todo list</h4></td>";
print "</tr>";

// Display the entries.

$today_dstr = date( 'Y' ) .  date( 'm' ) . date( 'd' );
$cnt = 0;
foreach ($mts as $mt)
{
	if ((($mt[startdate] <= $today_dstr) || $showall) && ($mt[nick] == $mynick))
	{

		if ($curcol == $color[0])
			$curcol = $color[4];
		else
			$curcol = $color[0];

		$dstr = substr($mt[startdate],0,4)."/".substr($mt[startdate],4,2)."/".substr($mt[startdate],6,2);
		switch ($mt[priority])
		{
			case 0: $pri = "Low"; break;
			case 1: $pri = "Normal"; break;
			case 2: $pri = "High"; break;
		}
		$link = "event_edit.php?todo=".urlencode($mt[tlist])."&idx=".$mt[idx]."&fromtoday=1";
		$cblink = $mt[idx]."_".urlencode($mt[tlist]);
		printf("<tr bgcolor=\"$curcol\"><td valign=top><input type=\"checkbox\" name=\"cb$cnt\" value=\"$cblink\"><a href=\"$link\">$dstr</a></td><td valign=top>$mt[title]</td><td valign=top>$pri</td><td valign=top>$mt[tlist]</td></tr>");
		$cnt++;
	}
}

// Complete first table.

print "</table></td></tr></table>\n";

// Print command buttons.

$now = date( 'Y' ) ."/".  date( 'm' ) ."/". date( 'd' );
print "<table width=\"60%\" bgcolor=\"$color[9]\"align=center>\n";
print "<tr><td></td><td align=right>New start date:<input type=text name=newdate value=\"$now\" size=10 style=\"background-color:$color[9]\"><input type=submit name=chgsel value=\"Change\" style=\"width=80; height=22; background-color:$color[9]\">&nbsp;&nbsp;";
print "<input type=submit name=addnew value=\"Add new\" style=\"width=80; height=22; background-color:$color[9]\">&nbsp;&nbsp;";
print "<input type=submit name=delsel value=\"Delete\" style=\"width=80; height=22; background-color:$color[9]\">&nbsp;&nbsp;";
if ($showall)
	print "<input type=submit name=showtoday value=\"Today\" style=\"width=80; height=22; background-color:$color[9]\"></td></tr>";
else
	print "<input type=submit name=showall value=\"Show All\" style=\"width=80; height=22; background-color:$color[9]\"></td></tr>";
print "</table>";
print "<input type=hidden name=maxcnt value=\"$cnt\">";
print "</form>";

// Print avaiable accounts.

print "<br><br><table width=\"60%\" bgcolor=\"$color[9]\"align=center>\n";
print "<tr><td align=center><b>Available todo lists</b></td></tr><tr><td>\n";
print "<table width=\"100%\" align=center bgcolor=\"$color[4]\">\n";
$count = count($public_list); 
for ($x=0;$x<$count;$x++) {
    $url_todo=urlencode($public_list[$x]);
    print "<tr><td align=center nowrap><a href=\"todo.php?todo=$url_todo&showall=1\">$public_list[$x]</a></td></tr>";
}
$code = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
for ($x=0;$x<count($shared_list);$x++) {
    $url_todo = urlencode($shared_list[$x]);
	switch ($code[$x]) {
		case 0:
		break;
		case 1:
		case 2:
		print "<tr><td align=center nowrap><a href=\"todo.php?todo=$url_todo&showall=1\">$shared_list[$x]</a></td></tr>";
		break;
		default:
		break;
	}
}
print "<tr><td nowrap align=center><a href=\"todo.php?todo=Personal&showall=1\">Personal</a></big></td></tr>";
print "</table></td></tr></table>\n";

?>
