<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Displays generic header for all calendar screens
  *
  * @param object $calendar The calendar being viewed
  * @param string $viewType The current calendar view mode, 
  *                         which should correspond to one
  *                         of the constants in {@link constants.php}
  * @param int $year The year being viewed
  * @param int $month The month being viewed
  * @param int $day The day being viewed
  *
  */
function showCalendarHeader($calendar, $viewType, $year, $month, $day)
{

   global $color, $calendar_theme;


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   echo html_tag('table', '', '', '', 'width="100%" border="0" cellpadding="0" cellspacing="0"')
      . html_tag('tr') . "\n"
      . html_tag('td', '', 'left') . "\n";

   displayInternalLink("plugins/calendar/year.php?year=$year&amp;month=$month&amp;day=$day&amp;calID=" . urlencode($calendar->getID()) . "#month$month", _("Year View"));

   echo "&nbsp;&nbsp\n";

   displayInternalLink("plugins/calendar/month.php?year=$year&amp;month=$month&amp;day=$day&amp;calID=" . urlencode($calendar->getID()), _("Month View"));

   echo "&nbsp;&nbsp\n";

   displayInternalLink("plugins/calendar/day.php?year=$year&amp;month=$month&amp;day=$day&amp;calID=" . urlencode($calendar->getID()), _("Day View"));

   echo "&nbsp;&nbsp\n";

   // displayInternalLink("plugins/calendar/event_create.php?year=$year&amp;month=$month&amp;day=$day", _("Add Event"), 'right');

   // echo "&nbsp;&nbsp\n";

   echo "</td>\n";

   echo html_tag('td', '', 'right') . "\n";

   echo '<a href="#">' . _("Tasks") . '</a>';
//LEFT OFF HERE: the above is temporary; the below is for real, once it's ready
//   displayInternalLink("plugins/calendar/todo.php?calID=" . $calendar->getID(), _("Tasks"));

   echo '</td></tr></table>';



   echo "<table bgcolor=\"" . $calendar_theme['month_view_title_background'] 
      . "\" border=\"0\" width=\"100%\" cellspacing=\"0\" "
      . "cellpadding=\"2\">"
      . "<tr><td width=\"15%\"></td><td align=\"center\"><h3>" . $calendar->getName()
      . "</h3></td><td valign=\"top\" width=\"15%\" align=\"right\">"
      . ($calendar->getCalendarType() == SM_CAL_TYPE_PERSONAL 
      ? "<small><a href=\"admin_options.php?cal_action="
      . SM_CAL_EDIT_HOLIDAYS . "&calID=" . urlencode($calendar->getID()) . "\">" ._("Edit Holidays") 
      . "</a></small>" : '') . "</td></tr></table>\n";


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');


}



?>
