<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


define('SM_PATH','../../');



if (file_exists(SM_PATH . 'include/validate.php')) 
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');
include_once(SM_PATH . 'functions/date.php');
include_once(SM_PATH . 'functions/url_parser.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/interface/calendar.php');
include_once(SM_PATH . 'plugins/calendar/load_prefs.php');



// get calendar...
//
sqgetGlobalVar('calID', $calID, SQ_FORM);
$calID = urldecode($calID);
$calendar = get_calendar($calID);



// check that user has access rights
//
global $username;
if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
   exit;




// personal calendar: get ID from backend, then get calendar
//
if ($calID == 'personal') 
{
   $calID = get_personal_cal_id($username, $domain);
   $calendar = get_calendar($calID);
}


// for any other type of calendar, we should check 
// that user has access rights 
// 
else
{
   $calendar = get_calendar($calID);
   if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
      exit;
}



sqgetGlobalVar('allday', $allDay, SQ_FORM);
if ($allDay == 'yes') $allDay = TRUE; else $allDay = FALSE;



sqgetGlobalVar('year', $year, SQ_FORM);
sqgetGlobalVar('month', $month, SQ_FORM);
sqgetGlobalVar('day', $day, SQ_FORM);
list($todaysYear, $todaysMonth, $todaysDay) = explode('-', date('Y-n-j'));



// make sure we have viewing day
//
if (empty($year) || empty($month) || empty($day))
{
   $year = $todaysYear;
   $month = $todaysMonth;
   $day = $todaysDay;
}



// make sure day number isn't greater than the 
// number of days in the requested month
//
$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
if ($day > $daysInMonth) $day = $daysInMonth;



// print standard SM page header
// and generic calendar header
//
global $color;
if (!isset($color[12])) $color[12] = '';
displayPageHeader($color, 'None');
showCalendarHeader($calendar, SM_CAL_VIEW_MODE_MONTH, $year, $month, $day);



// show the calendar
//
$calendar->showDay($year, $month, $day, $username, $allDay);



echo '</body></html>';

?>
