<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


define('SM_PATH','../../');



if (file_exists(SM_PATH . 'include/validate.php')) 
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');
include_once(SM_PATH . 'functions/date.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/interface/calendar.php');



global $username, $color, $week_start_day;



// get calendar...
//
sqgetGlobalVar('calID', $calID, SQ_FORM);
$calID = urldecode($calID);
$calendar = get_calendar($calID);



// check that user has access rights
//
if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
   exit;



sqgetGlobalVar('year', $year, SQ_FORM);
list($todaysYear, $todaysMonth, $todaysDay) = explode('-', date('Y-n-j'));
$month = $todaysMonth;
$day = $todaysDay;



// make sure we have viewing year
//
if (empty($year))
{
   $year = $todaysYear;
}



// print standard SM page header
// and generic calendar header
//
if (!isset($color[12])) $color[12] = '';
displayPageHeader($color, 'None');
showCalendarHeader($calendar, SM_CAL_VIEW_MODE_MONTH, $year, $month, $day);



// show the calendar
//
$calendar->showAllMonths($year, $username, $week_start_day);



echo '</body></html>';

?>
