#!/bin/sh

# Fixes badly formatted RRULES with semicolon separating
# RRULE name and its value and optional colon on the end
# of the line
#
# Usage: fix_rrule [calendar data directory]
#
# If no calendar data directory is given, it assumes 
# the current working directory 
#

echo "Fixing RRULES"
echo


DIRNAME=$1
shift
if test -z "$DIRNAME" -o ! -d "$DIRNAME"; then
   
   DIRNAME=`pwd`

fi



#==================================================================================

function fixrrule
{


local MYDIR=$1
shift

pushd $MYDIR > /dev/null


#for FILENAME in *     # Traverse all files in directory.
for FILENAME in `ls`     # Traverse all files in directory.

do

#echo -n "FILE IS "
#echo $FILENAME
#continue


   # recurse
   #
   if test -d "$FILENAME"; then

      fixrrule "$FILENAME"
      continue

   fi


SEARCH=`grep -iE "^RRULE;" "$FILENAME"`

# fix if needed
#
if test -z "$SEARCH"; then

   continue

else

   echo -n "  Fixing file $FILENAME..."

   sed 's/^RRULE;/RRULE:/' "$FILENAME" > /tmp/temp_sed_stuff_delete_me.$$

   sed 's/^\(RRULE:.*\):\s*$/\1/' /tmp/temp_sed_stuff_delete_me.$$ > /tmp/temp_sed_stuff_delete_me_2.$$

   rm -f /tmp/temp_sed_stuff_delete_me.$$

   mv -f /tmp/temp_sed_stuff_delete_me_2.$$ "$FILENAME"

   echo "done"

fi


done

popd > /dev/null

}

fixrrule $DIRNAME

