<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



/**
  * Loads all calendar user preferences
  *
  */
function cal_load_prefs_do()
{

   // these should already be taken care of by now
   //include_once(SM_PATH . 'plugins/calendar/constants.php');
   //include_once(SM_PATH . 'plugins/calendar/data/config.php');

   global $username, $data_dir, $cal_user_can_override_defaults,
          $month_view_show_event_start_time, $month_view_show_event_start_time_default,
          $month_view_show_daily_add_buttons, $month_view_show_daily_add_buttons_default,
          $day_view_short_time, $day_view_short_time_default,
          $day_view_show_hourly_add_buttons, $day_view_show_hourly_add_buttons_default,
          $highlight_threshold, $highlight_threshold_default,
          $day_view_start_time, $day_view_start_time_default,
          $day_view_end_time, $day_view_end_time_default,
          $event_click_to_day_view, $event_click_to_day_view_default,
          $show_small_calendar, $show_small_calendar_default,
          $small_calendar_size, $small_calendar_size_default,
          $small_calendar_calID, $small_calendar_calID_default,
          $week_start_day, $week_start_day_default,
          $small_calendar_header_color, $small_calendar_header_color_default,
          $small_calendar_today_color, $small_calendar_today_color_default,
          $small_calendar_event_italic_style, $small_calendar_event_italic_style_default,
          $small_calendar_event_color, $small_calendar_event_color_default,
          $small_calendar_day_color, $small_calendar_day_color_default,
          $small_calendar_separator, $small_calendar_separator_default,
          $small_calendar_show_year, $small_calendar_show_year_default,
          $small_calendar_show_today_link, $small_calendar_show_today_link_default,
          $small_calendar_show_day_titles, $small_calendar_show_day_titles_default,
          $small_calendar_inherit_day_background_colors,
          $small_calendar_inherit_day_background_colors_default,
          $max_events_per_day_on_month_view,
          $max_events_per_day_on_month_view_default,
          $show_week_numbers_in_month_view_override,
          $show_week_numbers_in_month_view_override_default,
          $external_calendar_clock_skew, $external_calendar_clock_skew_default;


   // always OK for user
   //
   $external_calendar_clock_skew = getPref($data_dir, $username,
              'external_calendar_clock_skew', $external_calendar_clock_skew_default);


   // overrides not allowed
   //
   if (!$cal_user_can_override_defaults)
   {
      $month_view_show_event_start_time = $month_view_show_event_start_time_default;
      $month_view_show_daily_add_buttons = $month_view_show_daily_add_buttons_default;
      $day_view_short_time = $day_view_short_time_default;
      $day_view_show_hourly_add_buttons = $day_view_show_hourly_add_buttons_default;
      $highlight_threshold = $highlight_threshold_default;
      $day_view_start_time = $day_view_start_time_default;
      $day_view_end_time = $day_view_end_time_default;
      $event_click_to_day_view = $event_click_to_day_view_default;
      $show_small_calendar = $show_small_calendar_default;
      $small_calendar_size = $small_calendar_size_default;
      $small_calendar_calID = $small_calendar_calID_default;
      $week_start_day = $week_start_day_default;
      $small_calendar_header_color = $small_calendar_header_color_default;
      $small_calendar_today_color = $small_calendar_today_color_default;
      $small_calendar_event_italic_style = $small_calendar_event_italic_style_default;
      $small_calendar_event_color = $small_calendar_event_color_default;
      $small_calendar_day_color = $small_calendar_day_color_default;
      $small_calendar_separator = $small_calendar_separator_default;
      $small_calendar_show_year = $small_calendar_show_year_default;
      $small_calendar_show_today_link = $small_calendar_show_today_link_default;
      $small_calendar_show_day_titles = $small_calendar_show_day_titles_default;
      $small_calendar_inherit_day_background_colors =
       $small_calendar_inherit_day_background_colors_default;
      $max_events_per_day_on_month_view =
       $max_events_per_day_on_month_view_default;
      $show_week_numbers_in_month_view_override =
       $show_week_numbers_in_month_view_override_default;
   }


   // overrides OK
   //
   else
   {
      $month_view_show_event_start_time = getPref($data_dir, $username,
              'month_view_show_event_start_time', $month_view_show_event_start_time_default);
      $month_view_show_daily_add_buttons = getPref($data_dir, $username,
              'month_view_show_daily_add_buttons', $month_view_show_daily_add_buttons_default);
      $day_view_short_time = getPref($data_dir, $username,
              'day_view_short_time', $day_view_short_time_default);
      $day_view_show_hourly_add_buttons = getPref($data_dir, $username,
              'day_view_show_hourly_add_buttons', $day_view_show_hourly_add_buttons_default);
      $highlight_threshold = getPref($data_dir, $username,
              'highlight_threshold', $highlight_threshold_default);
      $day_view_start_time = getPref($data_dir, $username,
              'day_view_start_time', $day_view_start_time_default);
      $day_view_end_time = getPref($data_dir, $username,
              'day_view_end_time', $day_view_end_time_default);
      $event_click_to_day_view = getPref($data_dir, $username,
              'event_click_to_day_view', $event_click_to_day_view_default);
      $show_small_calendar = getPref($data_dir, $username,
              'show_small_calendar', $show_small_calendar_default);
      $small_calendar_size = getPref($data_dir, $username,
              'small_calendar_size', $small_calendar_size_default);
      $small_calendar_calID = getPref($data_dir, $username,
              'small_calendar_calID', $small_calendar_calID_default);
      $week_start_day = getPref($data_dir, $username,
              'week_start_day', $week_start_day_default);
      $small_calendar_header_color = getPref($data_dir, $username,
              'small_calendar_header_color', $small_calendar_header_color_default);
      $small_calendar_today_color = getPref($data_dir, $username,
              'small_calendar_today_color', $small_calendar_today_color_default);
      $small_calendar_event_italic_style = getPref($data_dir, $username,
              'small_calendar_event_italic_style',
              $small_calendar_event_italic_style_default);
      $small_calendar_event_color = getPref($data_dir, $username,
              'small_calendar_event_color', $small_calendar_event_color_default);
      $small_calendar_day_color = getPref($data_dir, $username,
              'small_calendar_day_color', $small_calendar_day_color_default);
      $small_calendar_separator = getPref($data_dir, $username,
              'small_calendar_separator', $small_calendar_separator_default);
      $small_calendar_show_year = getPref($data_dir, $username,
              'small_calendar_show_year', $small_calendar_show_year_default);
      $small_calendar_show_day_titles = getPref($data_dir, $username,
              'small_calendar_show_day_titles',
              $small_calendar_show_day_titles_default);
      $small_calendar_show_today_link = getPref($data_dir, $username,
              'small_calendar_show_today_link',
              $small_calendar_show_today_link_default);
      $small_calendar_inherit_day_background_colors = getPref($data_dir,
              $username, 'small_calendar_inherit_day_background_colors',
              $small_calendar_inherit_day_background_colors_default);
      $max_events_per_day_on_month_view = getPref($data_dir,
              $username, 'max_events_per_day_on_month_view',
              $max_events_per_day_on_month_view_default);
      $show_week_numbers_in_month_view_override = getPref($data_dir,
              $username, 'show_week_numbers_in_month_view_override',
              $show_week_numbers_in_month_view_override_default);
   }

}



?>
