<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Presents the user with an interface to edit or create events
  *
  * @param array $color Standard SquirrelMail colors array
  * @param int $year Default start year
  * @param int $month Default start month
  * @param int $day Default start day
  * @param int $hour Default start hour (-1 if none given)
  * @param int $minute Default start (and end) minute (-1 if none given)
  * @param int $calendarID The ID of the calendar whose event is being edited/created
  * @param object $event The event being edited (optional)
  * @param string $calAction The action that should be sent 
  *                          when the form is submitted - should
  *                          correspond to the event management 
  *                          constants in {@link constants.php}
  * @param string $message A message for display at screen top (optional)
  *
  */
function display_event_edit_interface($color, $year, $month, $day, $hour, $minute, 
                                      $calendarID, $event='', $calAction, $message='')
{

   global $editor_size, $day_view_start_time, $max_event_name_length, 
          $calendar_theme, $hour_format;
//LEFT OFF HERE -- is this a config file thing?  or what? (is important to synch with DB backend)
$max_event_name_length = 100;


   if (!isset($color[12])) $color[12] = '';


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   // various defaults
   //
   $endYear = $year;
   $endMonth = $month;
   $endDay = $day;
   $isAllDay = FALSE;
   $startHour = ($hour == -1 ? $day_view_start_time : $hour);
   $startMinute = ($minute == -1 ? 0 : $minute);
   $startSeconds = 0;
   $endHour = $startHour + 1;
   $endMinute = ($minute == -1 ? 0 : $minute);
   $endSeconds = 0;
   $eventLength = 60;
   $endType = 'time';
   $eventName = '';
   $reminderTime = 0;
   $reminderOn = FALSE;
   $eventContent = '';
   $recurrenceType = FALSE;
   $recurrenceInterval = 1;
   $recurrenceDays = FALSE;
   $endRecurrenceYear = $year;
   $endRecurrenceMonth = $month;
   $endRecurrenceDay = $day;
   $recurrenceCount = 4;
   $recurrenceEndType = 'date';
   $priority = '';



// LEFT OFF HERE 
// LEFT OFF HERE
// javascript date/time popups should only be rendered when $javascript_on is set
// if we have javascript, we could also do fancy things with the end time vs length 
// settings (at least disabling and resetting the one that is turned off)
//
// actually, we can leave the popups active no matter what - if JS is off, they
// just can't set the date back in the main screen
//
// other attributes to show:
// -------------------------
// recurring clause, etc
// invited
// accepted
// maybe
// declined
//
   // set default values for an event if one is given
   //
   if (!empty($event))
   {

      list($year, $month, $day) = $event->startDate();
      list($endYear, $endMonth, $endDay) = $event->endDate();
      list($startHour, $startMinute, $startSeconds) = $event->startTime();
      list($endHour, $endMinute, $endSeconds) = $event->endTime();
      $isAllDay = $event->isAllDay();
      $eventLength = $event->lengthInMinutes();
      $eventName = cal_encode_output($event->getTitle());
      $eventContent = cal_encode_output($event->getDescription(), FALSE); 

//TODO: reminder/alarm...
$reminderMinutes = FALSE;
////      $reminderMinutes = $event->getReminderMinutes();
      $reminderTime = ($reminderMinutes === FALSE ? 0 : $reminderMinutes);
      $reminderOn = ($reminderMinutes !== FALSE);

      // FALSE if not recurring, otherwise a value from $RECURRENCE_TYPES constant
      //
      $recurrenceType = $event->getRecurrenceType();

      // FALSE if not recurring or interval not given
      //
      $recurrenceInterval = $event->getRecurrenceInterval();

      // FALSE if not recurring or no recurrence days available
      //
      $recurrenceDays = $event->getRecurrenceDays();

      // FALSE or array(year, month, day)
      //
      $recEnd = $event->recurrenceEnd();
      if ($recEnd !== FALSE) 
      {
         $endRecurrenceYear = $recEnd[0];
         $endRecurrenceMonth =$recEnd[1];
         $endRecurrenceDay =$recEnd[2];
      }

      // FALSE or integer
      //
      $recurrenceCount = $event->maxRecurrenceCount();
   
      if ($recurrenceCount !== FALSE) $recurrenceEndType = 'count';

      $priority = $event->getPriority();

   }



   $recurrenceHelpText = ''; // _("For example:\n - Days --> Every 3 days\n - Weeks --> Every other Tuesday\n - Months (by day) --> The 5th of every month\n - Months (by weekday) --> The 2nd Friday of every month\n - Months (by day from end) --> The last day of every other month\n - Years --> January 8th of every year");



   // restore other input elements 
   // when coming back from same page
   //
   if (!empty($message))
   {
      sqgetGlobalVar('endType', $endType, SQ_FORM);
      sqgetGlobalVar('recurrenceEndType', $recurrenceEndType, SQ_FORM);
   }



   if ($calAction == SM_CAL_EVENT_ACTION_UPDATE)
      $submitButtonText = _("Update Event");
   else
      $submitButtonText = _("Create Event");



   // display message if given 
   //
   if (!empty($message))
      echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 
           'width="100%" border="0" cellpadding="2" cellspacing="1"')
         . html_tag('tr') 
         . html_tag('th', '', 'center')
         . '<span style="color: ' . $color[2] . ';">' . $message . '</span>'
         . '</th></tr></table>';



//TODO: I think instead of using $colors, we could put these in calendar_theme config? nah
   // dumb IE puts a space above the form unless we zero out the margins of this non-displayable element
   echo '<form style="margin:0" name="eventDataForm" action="event_manage.php" method="POST">'
      . ($calAction == SM_CAL_EVENT_ACTION_UPDATE 
      ? '<input type="hidden" name="eventID" value="' . $event->getID() . '" />' : '')
      . '<input type="hidden" name="calAction" value="' . $calAction . '" />'
      . '<input type="hidden" name="calID" value="' . urlencode($calendarID) . '" />'
      . '<input type="hidden" name="year" value="' . $year . '" />'
      . '<input type="hidden" name="month" value="' . $month . '" />'
      . '<input type="hidden" name="day" value="' . $day . '" />'
      . '<input type="hidden" name="eventType" value="' . SM_EVENT_TYPE_EVENT . '" />'
      . html_tag('table', '', '', $color[0], 'width="100%" border="0" cellpadding="2" cellspacing="1"')


   // title/name
   //
      . html_tag('tr') 
      . html_tag('td', _("Summary:"), 'right', $color[4], 'colspan="2"') . "\n" 
      . html_tag('td', '', 'left', $color[4]) 
      . "<input type=\"text\" name=\"eventName\" size=\"30\" maxlength=\"$max_event_name_length\" value=\"$eventName\" />"
      . ' <input type="checkbox" name="isAllDay" id="isAllDay" value="YES"' 
      . ($isAllDay ? ' CHECKED>' : '>')
      . '<label for="isAllDay">' . _("All Day") . "</label><br />\n"
      . "      </td></tr>\n"


   // start date/time
   //
      . html_tag('tr')
      . html_tag('td', _("Start:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . "      <select name=\"startYear\">\n"
      . select_option_year($year)
      . "      </select>\n"
//      . "      &nbsp;\n"
      . "      <select name=\"startMonth\">\n";

   // select_option_month() needs to be called when in SM core locale
   // 
   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

   echo select_option_month($month);

   // switch back to our locale
   //
   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

   echo "      </select>\n"
//      . "      &nbsp;\n"
      . "      <select name=\"startDay\">\n"
      . select_option_day($day)
      . "      </select>\n"
//LEFT OFF HERE: when JS is on, we could pass the *current* selections in the date select boxes to be highlighted in the popup window....
      . '      <a href="#" onClick="window.open(\'helper_month.php?calID=' . urlencode($calendarID) 
      . '&month=' . $month . '&year=' . $year 
      . '\', \'helperMonth\', \'width=300,height=220\'); return false;"><img src="images/tinycal.png" border="0"></a>'
      . "      &nbsp;&nbsp;\n"
      . "      <select name=\"startHour\">\n"
      . select_option_hour($startHour)
      . "      </select>"
//      . "      &nbsp;\n"
      . "<strong>:</strong><select name=\"startMinute\">\n"
      . select_option_minute($startMinute)
      . "      </select>\n"
//LEFT OFF HERE: when JS is on, we could pass the *current* selections in the time select boxes to be highlighted in the popup window...
      . '      <a href="#" onClick="window.open(\'helper_time.php?hour=' . $startHour . '&minute=' . $startMinute
      . '\', \'helperTime\', \'width=300,height=220\'); return false;"><img src="images/tinyclock.png" border="0"></a>'
      . "      </td></tr>\n"


   // end date/time
   //
      . html_tag('tr')
      . html_tag('td', '<input type="radio" name="endType" value="time" id="endtime" '
      . ($endType == 'time' ? 'CHECKED' : '') . ' />',
        'right', $color[4])
      . html_tag('td', '<label for="endtime">' . _("End:") . '</label>', 
        'right', $color[4]) . "\n"
      . html_tag('td', '', 'left', $color[4])
      . "      <select name=\"endYear\">\n"
      . select_option_year($endYear)
      . "      </select>\n"
//      . "      &nbsp;\n"
      . "      <select name=\"endMonth\">\n";

   // select_option_month() needs to be called when in SM core locale
   // 
   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

   echo select_option_month($endMonth);

   // switch back to our locale
   //
   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

   echo "      </select>\n"
//      . "      &nbsp;\n"
      . "      <select name=\"endDay\">\n"
      . select_option_day($endDay)
      . "      </select>\n"
//LEFT OFF HERE: when JS is on, we could pass the *current* selections in the date select boxes to be highlighted in the popup window....
      . '      <a href="#" onClick="window.open(\'helper_month.php?calID=' . urlencode($calendarID)
      . '&month=' . $endMonth . '&year=' . $endYear
      . '\', \'helperMonth\', \'width=300,height=220\'); return false;"><img src="images/tinycal.png" border="0"></a>'
      . "      &nbsp;&nbsp;\n"
      . "      <select name=\"endHour\">\n"
      . select_option_hour($endHour)
      . "      </select>"
//      . "      &nbsp;\n"
      . "<strong>:</strong><select name=\"endMinute\">\n"
      . select_option_minute($endMinute)
      . "      </select>\n"
//LEFT OFF HERE: when JS is on, we could pass the *current* selections in the time select boxes to be highlighted in the popup window...
      . '      <a href="#" onClick="window.open(\'helper_time.php?hour=' . $endHour . '&minute=' . $endMinute 
      . '\', \'helperTime\', \'width=300,height=220\'); return false;"><img src="images/tinyclock.png" border="0"></a>'
      . "      </td></tr>\n"


   // length
   //
      . html_tag('tr') 
      . html_tag('td', '<input type="radio" name="endType" value="length" id="endlength" '
      . ($endType == 'length' ? 'CHECKED' : '') . ' />',
        'right', $color[4])
      . html_tag('td', '<label for="endlength">' . _("Duration:") . '</label>', 
        'right', $color[4]) . "\n" 
      . html_tag('td', '', 'left', $color[4]) 
      . "      <select name=\"eventLength\">\n"
      . select_option_length($eventLength)
      . "      </select>\n"
      . "      </td></tr>\n"


   // one-time vs recurrence
   //
      . html_tag('tr') 
      . html_tag('td', _("Recurrence:"), 'right', $color[4], 'colspan="2"') . "\n" 
      . html_tag('td', '', 'left', $color[4]) 
      . '<input type="radio" name="isRecurring" id="onetime" value="no"'
      . ($recurrenceType === FALSE ? ' CHECKED' : '') 
      . ' /><label for="onetime"> ' . _("One Time") 
      . '</label>&nbsp;&nbsp;<input type="radio" name="isRecurring" id="recurring" value="yes"' 
      . ($recurrenceType !== FALSE ? ' CHECKED' : '') 
      . ' /><label title="' . $recurrenceHelpText . '" for="recurring"> ' 
      . _("Recurring Every") . '</label> '
      . '      <select name="recurrenceInterval">'
      . select_option_integer(1, 99, $recurrenceInterval)
      . '      </select>'
/* as a text input:
      . '<input name="recurrenceInterval" value="' . $recurrenceInterval 
      . '" type="text" size="1" maxlength="2" />'
*/
      . "      <select name=\"recurrenceType\">\n"
      . select_option_recurrence_type($recurrenceType)
      . "      </select>&nbsp;\n"
      . '<a href="" title="' . $recurrenceHelpText . '" target="_blank">' . _("Help") . '</a>'
      . '      <br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' 
      . _("On") . ':&nbsp;&nbsp;' 
      . '<input type="checkbox" name="recurrenceDays[]" value="SU" id="onSunday"'
      . ($recurrenceDays && in_array(SU, $recurrenceDays) ? ' CHECKED' : '') . '>'
      . '<label for="onSunday"> ' 
      . _("Sun") . '</label>&nbsp;&nbsp;'
      . '<input type="checkbox" name="recurrenceDays[]" value="MO" id="onMonday"'
      . ($recurrenceDays && in_array(MO, $recurrenceDays) ? ' CHECKED' : '') . '>'
      . '<label for="onMonday"> ' 
      . _("Mon") . '</label>&nbsp;&nbsp;'
      . '<input type="checkbox" name="recurrenceDays[]" value="TU" id="onTuesday"'
      . ($recurrenceDays && in_array(TU, $recurrenceDays) ? ' CHECKED' : '') . '>'
      . '<label for="onTuesday"> ' 
      . _("Tue") . '</label>&nbsp;&nbsp;'
      . '<input type="checkbox" name="recurrenceDays[]" value="WE" id="onWednesday"'
      . ($recurrenceDays && in_array(WE, $recurrenceDays) ? ' CHECKED' : '') . '>'
      . '<label for="onWednesday"> ' 
      . _("Wed") . '</label>&nbsp;&nbsp;'
      . '<input type="checkbox" name="recurrenceDays[]" value="TH" id="onThursday"'
      . ($recurrenceDays && in_array(TH, $recurrenceDays) ? ' CHECKED' : '') . '>'
      . '<label for="onThursday"> ' 
      . _("Thu") . '</label>&nbsp;&nbsp;'
      . '<input type="checkbox" name="recurrenceDays[]" value="FR" id="onFriday"'
      . ($recurrenceDays && in_array(FR, $recurrenceDays) ? ' CHECKED' : '') . '>'
      . '<label for="onFriday"> ' 
      . _("Fri") . '</label>&nbsp;&nbsp;'
      . '<input type="checkbox" name="recurrenceDays[]" value="SA" id="onSaturday"'
      . ($recurrenceDays && in_array(SA, $recurrenceDays) ? ' CHECKED' : '') . '>'
      . '<label for="onSaturday"> ' 
      . _("Sat") . '</label>&nbsp;&nbsp;'
      . "      </td></tr>\n"


   // recurrence end date
   //
      . html_tag('tr')
      . html_tag('td', '<input type="radio" name="recurrenceEndType" value="date" id="recbydate" '
      . ($recurrenceEndType == 'date' ? 'CHECKED' : '') . ' />',
        'right', $color[4])
      . html_tag('td', '<label for="recbydate">' . _("End Recurrence:") . '</label>', 
        'right', $color[4]) . "\n"
      . html_tag('td', '', 'left', $color[4])
      . "      <select name=\"endRecurrenceYear\">\n"
      . select_option_year($endRecurrenceYear)
      . "      </select>\n"
//      . "      &nbsp;\n"
      . "      <select name=\"endRecurrenceMonth\">\n";

   // select_option_month() needs to be called when in SM core locale
   // 
   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

   echo select_option_month($endRecurrenceMonth);

   // switch back to our locale
   //
   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

   echo "      </select>\n"
//      . "      &nbsp;\n"
      . "      <select name=\"endRecurrenceDay\">\n"
      . select_option_day($endRecurrenceDay)
      . "      </select>\n"
//LEFT OFF HERE: when JS is on, we could pass the *current* selections in the date select boxes to be highlighted in the popup window....
      . '      <a href="#" onClick="window.open(\'helper_month.php?calID=' . urlencode($calendarID) 
      . '&month=' . $month . '&year=' . $year 
      . '\', \'helperMonth\', \'width=300,height=220\'); return false;"><img src="images/tinycal.png" border="0"></a>'
      . "      </td></tr>\n"


   // recurrence count
   //
      . html_tag('tr') 
      . html_tag('td', '<input type="radio" name="recurrenceEndType" value="count" id="recbycount" '
      . ($recurrenceEndType == 'count' ? 'CHECKED' : '') . ' />',
        'right', $color[4])
      . html_tag('td', '<label for="recbycount">' . _("Recurrence Count:") . '</label>', 
        'right', $color[4]) . "\n" 
      . html_tag('td', '', 'left', $color[4]) 
      . '      <select name="recurrenceCount">'
      . select_option_integer(1, 99, $recurrenceCount)
      . '      </select>'
      . "      </td></tr>\n"


   // priority
   //
      . html_tag('tr') 
      . html_tag('td', _("Priority:"), 'right', $color[4], 'colspan="2"') . "\n" 
      . html_tag('td', '', 'left', $color[4]) 
      . "      <select name=\"eventPriority\">\n"
      . select_option_priority($priority)
      . "      </select>\n"
      . "      </td></tr>\n"


   // reminder time
   //
      . html_tag('tr')
      . html_tag('td', 
        '<input DISABLED type="checkbox" name="enableReminder" value="1" id="enableReminder" '
      . ($reminderOn ? ' CHECKED' : '') . ' />',
        'right', $color[4])
      . html_tag('td', '<label for="enableReminder">' . _("Reminder:") . '</label>',
        'right', $color[4]) . "\n"
      . html_tag('td', '', 'left', $color[4])
      . "      <select DISABLED name=\"reminderTime\">\n"
      . select_option_length($reminderTime)
      . "      </select>\n"
/*
      . "      <select name=\"reminderHours\">\n"
      . select_option_hour()
      . "      </select>"
//      . "      &nbsp;\n"
      . "<strong>:</strong><select name=\"reminderMinutes\">\n"
      . select_option_minute()
      . "      </select>\n"
      . '      <a href="#" onClick="window.open(); return false;"><img src="images/tinyclock.png" border="0"></a> &nbsp;'
*/
      . _("before event start") . "</td></tr>\n"


   // content/description
   //
      . html_tag('tr') 
      . html_tag('td', _("Description:"), 'right', $color[4], 'colspan="2"') . "\n" 
      . html_tag('td', '', 'left', $color[4])
      . "<textarea name=\"eventContent\" rows=\"5\" cols=\"$editor_size\">" 
      . $eventContent
      . "</textarea>\n" 
      . "      </td></tr>\n"


   // submit button
   //
      . html_tag('tr') 
      . html_tag('td',
        "<input type=\"submit\" name=\"submitevent\" value=\"" 
      . $submitButtonText . "\" />\n" ,
        'center', $color[4], 'colspan="2"' ) 
      . html_tag('td',
      ($calAction == SM_CAL_EVENT_ACTION_UPDATE
      ? '<input type="submit" name="deleteevent" value="'
      . _("Delete Event") . '"/>' : '')
      , '', $color[4]) . '</td>'
      . '</tr>';


   if ($calAction == SM_CAL_EVENT_ACTION_UPDATE)
   {

      // last updated by/on
      //
      $lastUpdator = $event->lastUpdatedBy();
      $lastUpdateDate = $event->lastUpdatedOn();
      if (empty($lastUpdator))
         $lastUpdator = $event->createdBy();
      if (empty($lastUpdateDate))
         $lastUpdateDate = $event->createdOn();
      $creator = $event->createdBy();


      // switch back to SM text domain for date_intl()
      //
      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

      $updateDt = date_intl('M d, Y ' . ($hour_format == SMPREF_TIME_24HR ? 'H:i' : 'g:ia'), $lastUpdateDate);
      $createDt = date_intl('M d, Y ' . ($hour_format == SMPREF_TIME_24HR ? 'H:i' : 'g:ia'), $event->createdOn());

      bindtextdomain ('calendar', SM_PATH . 'locale');
      textdomain ('calendar');


      echo html_tag('tr') 
         . html_tag('td', _("Last Updated:"), 'right', $color[4], 'colspan="2"') . "\n" 
         . html_tag('td', '', 'left', $color[4])
         . $updateDt
         . (!empty($lastUpdator) ? ' [' . $lastUpdator . ']' : '')
         . "      </td></tr>\n"


      // created by/on
      //
         . html_tag('tr') 
         . html_tag('td', _("Created:"), 'right', $color[4], 'colspan="2"') . "\n" 
         . html_tag('td', '', 'left', $color[4])
         . $createDt
         . (!empty($creator) ? ' [' . $creator . ']' : '')
         . "      </td></tr>\n";

   }


   echo '</table></form>';


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/**
  * Presents the user with an interface to view (and possibly delete) an event
  *
  * @param array $color Standard SquirrelMail colors array
  * @param int $year Default start year
  * @param int $month Default start month
  * @param int $day Default start day
  * @param int $calendarID The ID of the calendar whose event is being viewed
  * @param object $event The event being viewed
  * @param string $calAction The action that should be sent 
  *                          when the form is submitted - should
  *                          correspond to the event management 
  *                          constants in {@link constants.php} (optional)
  * @param string $message A message for display at screen top (optional)
  *
  */
function display_event_display_interface($color, $year, $month, $day, $calendarID, 
                                         $event, $calAction='', $message='')
{

   global $calendar_theme, $RECURRENCE_TYPES, $EVENT_PRIORITIES,
          $hour_format;


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   if (!isset($color[12])) $color[12] = '';

   $eventName = cal_encode_output($event->getTitle());
   $eventContent = cal_encode_output($event->getDescription(), FALSE);

//TODO: reminder/alarm...
$reminderMinutes = FALSE;
////      $reminderMinutes = $event->getReminderMinutes();
   $reminderTime = ($reminderMinutes === FALSE ? 0 : $reminderMinutes);
   $reminderOn = ($reminderMinutes !== FALSE);
   $reminderHTML = select_option_length($reminderTime);
   if (strpos($reminderHTML, 'selected') === FALSE)
      $reminderText = 'Zero minutes';
   else
   {
      preg_match('/<option value="\d+" selected>(.+)<\/option>/', $reminderHTML, $matches);
      $reminderText = $matches[1];
   }
   if ($reminderOn)
      $reminderText .= ' ' . _("before event start");
   else
      $reminderText = _("Reminder not set");


   // FALSE if not recurring or no recurrence days available
   //
   $recurrenceDaysText = FALSE;
   $recurrenceDays = $event->getRecurrenceDays();
   if ($recurrenceDays && is_array($recurrenceDays))
   {
      $recurrenceDaysText = array();
      if (in_array(SU, $recurrenceDays))
         $recurrenceDaysText[] = ("Sun");
      if (in_array(MO, $recurrenceDays))
         $recurrenceDaysText[] = ("Mon");
      if (in_array(TU, $recurrenceDays))
         $recurrenceDaysText[] = ("Tue");
      if (in_array(WE, $recurrenceDays))
         $recurrenceDaysText[] = ("Wed");
      if (in_array(TH, $recurrenceDays))
         $recurrenceDaysText[] = ("Thu");
      if (in_array(FR, $recurrenceDays))
         $recurrenceDaysText[] = ("Fri");
      if (in_array(SA, $recurrenceDays))
         $recurrenceDaysText[] = ("Sat");
      $recurrenceDaysText = implode(', ', $recurrenceDaysText);
   }


   // FALSE if not recurring, otherwise a value from $RECURRENCE_TYPES constant
   //
   $recurrenceType = $event->getRecurrenceType();
   if ($recurrenceType === FALSE)
      $eventRecurrenceText = _("One Time");
   else
      $eventRecurrenceText = _("Recurring Every") 
                           . ' ' . $event->getRecurrenceInterval() 
                           . ' ' . $RECURRENCE_TYPES[$recurrenceType];

   // FALSE or array(year, month, day)
   //
   $recEnd = $event->recurrenceEnd();
   if ($recEnd !== FALSE)
   {
      $endRecurrenceYear = $recEnd[0];
      $endRecurrenceMonth =$recEnd[1];
      $endRecurrenceDay =$recEnd[2];
   }

   // FALSE or integer
   //
   $recurrenceCount = $event->maxRecurrenceCount();

   $recurrenceEndType = 'date';
   if ($recurrenceCount !== FALSE) $recurrenceEndType = 'count';

   $priority = $event->getPriority();
   if (!empty($priority))
      $eventPriority = $EVENT_PRIORITIES[$priority];
   else
      $eventPriority = '';


   $lastUpdator = $event->lastUpdatedBy();
   $lastUpdateDate = $event->lastUpdatedOn();
   if (empty($lastUpdator))
      $lastUpdator = $event->createdBy();
   if (empty($lastUpdateDate))
      $lastUpdateDate = $event->createdOn();
   $creator = $event->createdBy();


   // switch back to SM text domain for date_intl()
   //
   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

   $updateDt = date_intl('M d, Y ' . ($hour_format == SMPREF_TIME_24HR ? 'H:i' : 'g:ia'), $lastUpdateDate); 
   $createDt = date_intl('M d, Y ' . ($hour_format == SMPREF_TIME_24HR ? 'H:i' : 'g:ia'), $event->createdOn());

   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   // display message if given
   //
   if (!empty($message))
      echo html_tag('table', '', '', $calendar_theme['month_view_title_background'],
           'width="100%" border="0" cellpadding="2" cellspacing="1"')
         . html_tag('tr')
         . html_tag('th', '', 'center')
         . '<span style="color: ' . $color[2] . ';">' . $message . '</span>'
         . '</th></tr></table>';



//TODO: I think instead of using $colors, we could put these in calendar_theme config? nah
   echo html_tag('table', '', '', $color[0], 'width="100%" border="0" cellpadding="2" cellspacing="1"')


   // title/name
   //
      . html_tag('tr')
      . html_tag('td', _("Summary:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . "$eventName<br />\n"
      . "      </td></tr>\n"


   // start date/time
   //
      . html_tag('tr')
      . html_tag('td', _("Start:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $event->formattedStartDate() . ' ' . $event->formattedStartTime()
      . ($event->isAllDay() ? ' (' . _("All Day") . ')' : '')
      . "      </td></tr>\n"


   // end date/time
   //
      . html_tag('tr')
      . html_tag('td', _("End:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $event->formattedEndDate() . ' ' . $event->formattedEndTime()
      . "      </td></tr>\n"


   // type (and recurrence details if recurring)
   //
      . html_tag('tr')
      . html_tag('td', _("Recurrence:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $eventRecurrenceText
      . ($recurrenceDaysText ? '<br />' . _("On") . ' ' . $recurrenceDaysText : '')
      . "      </td></tr>\n"


   // end recurrence date
   //
      . ($recurrenceType !== FALSE ?
        html_tag('tr')
      . html_tag('td', _("End Recurrence:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . ($recurrenceEndType == 'count' ? $recurrenceCount . ' ' . _("Occurrences") 
      : $event->formattedEndRecurrenceDate())
      . "      </td></tr>\n" : '')


   // priority
   //
      . html_tag('tr')
      . html_tag('td', _("Priority:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $eventPriority
      . "      </td></tr>\n"


   // reminder time
   //
      . html_tag('tr')
      . html_tag('td', _("Reminder:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $reminderText
      . "</td></tr>\n"


   // content/description
   //
      . html_tag('tr')
      . html_tag('td', _("Description:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $eventContent
      . "      </td></tr>\n"


   // last updated by/on
   //
      . html_tag('tr')
      . html_tag('td', _("Last Updated:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $updateDt
      . (!empty($lastUpdator) ? ' [' . $lastUpdator . ']' : '')
      . "      </td></tr>\n"


   // created by/on
   //
      . html_tag('tr')
      . html_tag('td', _("Created:"), 'right', $color[4], 'colspan="2"') . "\n"
      . html_tag('td', '', 'left', $color[4])
      . $createDt
      . (!empty($creator) ? ' [' . $creator . ']' : '')
      . "      </td></tr>\n"


   // submit button
   //
      . (!empty($calAction) && $calAction == SM_CAL_EVENT_ACTION_REMOVE
      ? html_tag('tr')
      . html_tag('td',
   // dumb IE puts a space above the form unless we zero out the margins of this non-displayable element
        '<form style="margin:0" name="deleteEventForm" action="event_manage.php" method="POST">'
      . '<input type="hidden" name="eventID" value="' . $event->getID() . '" />'
      . '<input type="hidden" name="calAction" value="' . $calAction . '" />'
      . '<input type="hidden" name="calID" value="' . urlencode($calendarID) . '" />'
      . '<input type="hidden" name="year" value="' . $year . '" />'
      . '<input type="hidden" name="month" value="' . $month . '" />'
      . '<input type="hidden" name="day" value="' . $day . '" />'
      . "<input type=\"submit\" name=\"submitevent\" value=\""
      . _("Confirm Deletion") . "\" /></form>\n" ,
        'center', $color[4], 'colspan="2"' )
      . html_tag('td', '', '', $color[4]) . '</td>'
      . '</tr>'
      : '')


      . '</table></form>';


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



?>
