<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Displays page header for calendar day view
  *
  * @param object $calendar The calendar being viewed
  * @param int $year The year of the day to be shown
  * @param int $month The month of the day to be shown
  * @param int $day The day to be shown
  *
  */
function showDayViewHeader($calendar, $year, $month, $day)
{

   global $color, $calendar_theme, $username;

   $prev_date = mktime(0, 0, 0, $month, $day - 1, $year);
   $act_date  = mktime(0, 0, 0, $month, $day, $year);
   $next_date = mktime(0, 0, 0, $month, $day + 1, $year);
   $prev_day = date('j', $prev_date );
   $next_day = date('j', $next_date);
   $prev_month = date('n', $prev_date );
   $next_month = date('n', $next_date);
   $prev_year = date('Y', $prev_date);
   $next_year = date('Y', $next_date );


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   $self = 'day.php';

   echo html_tag('table', '', '', 
        $calendar_theme['day_view_title_background'], 
        'width="100%" border="0" cellpadding="2" cellspacing="1"')
      . html_tag('tr', "\n"
      . html_tag('th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) 
      . "&year=$prev_year&month=$prev_month&day=$prev_day\">&lt;&nbsp;" 
      . date_intl('D', $prev_date) . "</a>") . "\n"
      . html_tag('th', date_intl('l, F d Y', $act_date) 
      . ($calendar->isOwner($username) || $calendar->canWrite($username)
      ? ' <a href="event_manage.php?calID=' . urlencode($calendar->getID()) 
      . "&year=$year&month=$month&day=$day&calAction=" . SM_CAL_EVENT_ACTION_ADD 
      . "\"><img src=\"images/new.png\" border=\"0\"></a>" : ''),
        '', $calendar_theme['day_view_title_background'], '')
      . html_tag( 'th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) 
      . "&year=$next_year&month=$next_month&day=$next_day\">" 
      . date_intl('D', $next_date) . "&nbsp;&gt;</a>")) . "\n"
      . '</table>';


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}


/**
  * Displays one day view of the given calendar
  *
  * @param object $calendar The calendar being viewed
  * @param int $year The year of the day to be shown
  * @param int $month The month of the day to be shown
  * @param int $day The day to be shown
  * @param string $user The user for which the calendar is being displayed
  * @param boolean $allDay Indicates if the whole day should be
  *                        displayed, from midnight to midnight.  If
  *                        FALSE, a limited number of hours are
  *                        displayed per the configuration file.
  *
  */
function showCalendarDay(&$calendar, $year, $month, $day, $user, $allDay=FALSE)
{

   showDayViewHeader($calendar, $year, $month, $day);


   global $color, $calendar_theme, $day_view_start_time, $day_view_end_time,
          $username, $max_displayable_early_morn_late_nite_event_names,
          $twentyfourHourTime, $day_view_short_time, $highlight_threshold,
          $day_view_show_hourly_add_buttons;


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   // all day display?
   //
   if ($allDay)
   {
      $day_view_start_time = 0;
      $day_view_end_time = 23;
   }


   // figure out user permissions on this calendar
   //
   $writePermission = ($calendar->isOwner($username) || $calendar->canWrite($username));


   // get events for today, which are displayed below
   //
   $events = $calendar->getEventsForDay($year, $month, $day, $user);
//   $organizedEvents = organizeEvents($events, $year, $month, $day, $day_view_start_time);
   $organizedEvents = organizeEvents($events, $year, $month, $day);



   // figure out how many hours have no events in them
   // (meaning no events that either start or end that hour)
   //
   $hoursWithNoEvents = array();
   for ($hour = $day_view_start_time; $hour < $day_view_end_time + 1; $hour++)
   {

      foreach ($events as $event)
      {
         list($endHour, $endMinute, $endSeconds) = $event->endTime();

         if (($event->startHour($year, $month, $day) == $hour
           && $event->startsOnDay($year, $month, $day)
           && $event->startQuarterHour($year, $month, $day) != 0)

          || ($event->endHour($year, $month, $day) == $hour
           && $event->endsOnDay($year, $month, $day)
           && $endMinute != 0))

            continue 2;
      }

      $hoursWithNoEvents[$hour] = 'NO EVENTS';

   }



   // build output matrix
   //
   $earlyMornEvents = array();
   $output = array();
   $outputIndex = -1 - ($day_view_start_time * 4);
   $numberOfEventsToday = 0;
   for ($timeIndex = 0; $timeIndex < $day_view_end_time + 1; $timeIndex += 0.25)
//   for ($timeIndex = $day_view_start_time; $timeIndex < $day_view_end_time + 1; $timeIndex += 0.25)
   {

      $hour = floor($timeIndex);
      $minute = ($timeIndex - $hour) * 60;
      $outputIndex++;



      // events that start earlier than the displayed hours
      // either get pushed to the start time (if they run
      // into any displayable hours) or put into list of 
      // out-of-bounds events
      // 
      if ($timeIndex < $day_view_start_time)
      {

         while (isset($organizedEvents[$hour][$minute]) 
          && is_array($organizedEvents[$hour][$minute])
          && sizeof($organizedEvents[$hour][$minute]) > 0)
         {

            $event = array_shift($organizedEvents[$hour][$minute]);

            if ($event->endHour($year, $month, $day) !== FALSE
             && $event->endHour($year, $month, $day) < $day_view_start_time)
               $earlyMornEvents[] = $event;
            else
               $organizedEvents[$day_view_start_time][0][] = $event;

         }

         continue;

      }



      // an output "slot" corresponds to a column in day view
      // each "slot" is an array indexed by time units (not actual time values)
      //
      foreach ($output as $i => $outputSlot)
      {

         if (isset($outputSlot[$outputIndex])) continue;


         // fill in events that occur in any empty cells in
         // rolumns that already exist
         //
         if (isset($organizedEvents[$hour][$minute]) && is_array($organizedEvents[$hour][$minute])
          && sizeof($organizedEvents[$hour][$minute]) > 0)
         {

            $event = array_shift($organizedEvents[$hour][$minute]);

            $rowspan = 0;
            $addToRowspan = TRUE;


            $eventLength = $event->lengthInQuarterHours();


            // events that start on earlier days but are shown starting
            // at hour zero need to have their length trimmed back
            //
            if ($timeIndex == 0 && !$event->startsOnDay($year, $month, $day))
               if (!$event->endsOnDay($year, $month, $day))
                  $eventLength = ($day_view_end_time - $day_view_start_time + 1) * 4;
               else
                  $eventLength = $event->endHour($year, $month, $day) * 4
                               + ($event->endQuarterHour($year, $month, $day) / 15);


            // whereas events that got pushed from earlier to the starting 
            // display hour also need to have their length trimmed back
            //
            else if ($timeIndex == $day_view_start_time && $event->startHour($year, $month, $day) != $hour)
               if (!$event->startsOnDay($year, $month, $day))
                  $eventLength = ($event->endHour($year, $month, $day) - $day_view_start_time) * 4
                               + ($event->endQuarterHour($year, $month, $day) / 15);
               else
                  $eventLength -= ($timeIndex - $event->startHour($year, $month, $day)) * 4
                                + ($event->startQuarterHour($year, $month, $day) / 15);


            // fill out time cells in this column for this event
            //
            for ($eventLengthCounter = $outputIndex; 
                 $eventLengthCounter < $eventLength + $outputIndex
                 && $eventLengthCounter < ($day_view_end_time - $day_view_start_time + 1) * 4; 
                 $eventLengthCounter++)
            {
               $output[$i][$eventLengthCounter] = $event->getID();
               $hr = floor($eventLengthCounter / 4) + $day_view_start_time;
               if ($eventLengthCounter % 4 == 0)
               {
                  $rowspan += 1;
                  if (isset($hoursWithNoEvents[$hr])) 
                     $addToRowspan = FALSE;
                  else
                     $addToRowspan = TRUE;
               }
               else if ($addToRowspan)
                  $rowspan += 1;
            }


            if ($rowspan == 0) $rowspan = 1;
//            $output[sizeof($output) - 1][$outputIndex] = array('rowspan' => $eventLengthCounter - $outputIndex,
            $output[$i][$outputIndex] = array('rowspan' => $rowspan,
                                                               'event'   => $event);
            $numberOfEventsToday++;

         }

      }


      // build new columns for any events still left over
      //
      while (isset($organizedEvents[$hour][$minute]) && is_array($organizedEvents[$hour][$minute])
       && sizeof($organizedEvents[$hour][$minute]) > 0)
      {

         $event = array_shift($organizedEvents[$hour][$minute]);

         $output[] = array();
         $rowspan = 0;
         $addToRowspan = TRUE;

         $eventLength = $event->lengthInQuarterHours();


         // events that start on earlier days but are shown starting
         // at hour zero need to have their length trimmed back
         //
         if ($timeIndex == 0 && !$event->startsOnDay($year, $month, $day))
            if (!$event->endsOnDay($year, $month, $day))
               $eventLength = ($day_view_end_time - $day_view_start_time + 1) * 4;
            else
               $eventLength = $event->endHour($year, $month, $day) * 4
                            + ($event->endQuarterHour($year, $month, $day) / 15);


         // whereas events that got pushed from earlier to the starting 
         // display hour also need to have their length trimmed back
         //
         else if ($timeIndex == $day_view_start_time && $event->startHour($year, $month, $day) != $hour)
            if (!$event->startsOnDay($year, $month, $day))
               $eventLength = ($event->endHour($year, $month, $day) - $day_view_start_time) * 4
                            + ($event->endQuarterHour($year, $month, $day) / 15);
            else
               $eventLength -= ($timeIndex - $event->startHour($year, $month, $day)) * 4
                             + ($event->startQuarterHour($year, $month, $day) / 15);


         // fill out time cells in this column for this event
         //
         for ($eventLengthCounter = $outputIndex; 
              $eventLengthCounter < $eventLength + $outputIndex
              && $eventLengthCounter < ($day_view_end_time - $day_view_start_time + 1) * 4; 
              $eventLengthCounter++)
         {
            $output[sizeof($output) - 1][$eventLengthCounter] = $event->getID();
            $hr = floor($eventLengthCounter / 4) + $day_view_start_time;
            if ($eventLengthCounter % 4 == 0)
            {
               $rowspan += 1;
               if (isset($hoursWithNoEvents[$hr])) 
                  $addToRowspan = FALSE;
               else
                  $addToRowspan = TRUE;
            }
            else if ($addToRowspan)
               $rowspan += 1;
         }


         if ($rowspan == 0) $rowspan = 1;
//         $output[sizeof($output) - 1][$outputIndex] = array('rowspan' => $eventLengthCounter - $outputIndex,
         $output[sizeof($output) - 1][$outputIndex] = array('rowspan' => $rowspan,
                                                            'event'   => $event);
         $numberOfEventsToday++;

      }

   }



   // gather up remaining events (those that start before
   // and after the last displayable hour on the screen)
   //
/*     THIS IS NOW TAKEN CARE OF WHEN BUILDING OUTPUT MATRIX
   $earlyMornEvents = array();
   for ($timeIndex = 0; $timeIndex < $day_view_start_time; $timeIndex += 0.25)
   {

      $hour = floor($timeIndex);
      $minute = ($timeIndex - $hour) * 60;

      if (isset($organizedEvents[$hour][$minute]) && is_array($organizedEvents[$hour][$minute])
       && sizeof($organizedEvents[$hour][$minute]) > 0)
      {
         foreach ($organizedEvents[$hour][$minute] as $event)
            $earlyMornEvents[] = $event;
      }

   }
*/
   $lateNightEvents = array();
   for ($timeIndex = $day_view_end_time + 1; $timeIndex < 24; $timeIndex += 0.25)
   {

      $hour = floor($timeIndex);
      $minute = ($timeIndex - $hour) * 60;

      if (isset($organizedEvents[$hour][$minute]) && is_array($organizedEvents[$hour][$minute])
       && sizeof($organizedEvents[$hour][$minute]) > 0)
      {
         foreach ($organizedEvents[$hour][$minute] as $event)
            $lateNightEvents[] = $event;
      }

   }
// LEFT OFF HERE -- test events right on the border of displayable hours, before and after!!
// LEFT OFF HERE -- test events right on the border of displayable hours, before and after!!



   // add extra column when events would otherwise look too big
   //
//   if ($numberOfEventsToday < 3)
   if (sizeof($output) < 3)
      $output[] = array();



   // show output
   //
   echo html_tag('table', '', '', $calendar_theme['day_view_title_background'], 
        'width="100%" border="0" cellpadding="2" cellspacing="1"') ."\n";



   echo "<tr><td bgcolor=\"" . $calendar_theme['day_view_event_background_1'] 
      . "\" colspan=\"" . (sizeof($output) + 1) . "\"></td></tr>\n";



   // print link to view events that fall outside of displayable hours
   //
   if  (sizeof($earlyMornEvents))
   {
      echo html_tag('tr')
         . html_tag('td', '<small><a href="day.php?calID=' . urlencode($calendar->getID()) 
         . "&year=$year&month=$month&day=$day&allday=yes\">" . _("More") . '</a></small>', 'left',
           $calendar_theme['day_view_time_header'])
         . html_tag('td', '', 'left', 
           $calendar_theme['day_view_title_background'], 'colspan="' . sizeof($output) . '"');
      $count = 0;
      foreach ($earlyMornEvents as $event)
      {
         if ($count++ > 0) echo '<small>, </small>';
         echo '<small' 
            . (($event->getPriority() <= $highlight_threshold)
            ? ' style="text-decoration:none; color: '
            . $calendar_theme['month_view_event_text_urgent'] . '"'
            : ' style="text-decoration:none; color: '
            . $calendar_theme['month_view_event_text_normal'] . '"')
            . '>' . $event->getTitle() . '</small>';
         if ($count >= $max_displayable_early_morn_late_nite_event_names)
            break;
      }
      echo '</td></tr>';
   }



   $outputIndex = -1;
   $alternatingBackgroundColor = 0;
   for ($timeIndex = $day_view_start_time; $timeIndex < $day_view_end_time + 1; $timeIndex += 0.25)
   {

      $hour = floor($timeIndex);
      $minute = ($timeIndex - $hour) * 60;
      $outputIndex++;
      if ($alternatingBackgroundColor == 0)
         $alternatingBackgroundColor = 1;
      else
         $alternatingBackgroundColor = 0;

      
      echo html_tag('tr');


      $haveEventsThisHour = !isset($hoursWithNoEvents[$hour]);


      if ($outputIndex % 4 == 0)
      {
         $timeString = ($twentyfourHourTime ? $timeIndex 
                        : ($timeIndex < 13 ? ($timeIndex == 0 ? '12' : $timeIndex) 
                           : $timeIndex - 12)) 
                     . ($day_view_short_time ? '' : ':00');

         echo html_tag('td', '<small>' 
            . ($twentyfourHourTime ? $timeString 
               : ($timeIndex < 12 ? sprintf(_("%sam"), $timeString) 
                  : sprintf(_("%spm"), $timeString)))
            . '</small>'
            . ($day_view_show_hourly_add_buttons && 
              $calendar->isOwner($username) || $calendar->canWrite($username)
            ? '<a href="event_manage.php?calID=' . urlencode($calendar->getID())
            . "&year=$year&month=$month&day=$day&hour=$timeIndex&calAction=" . SM_CAL_EVENT_ACTION_ADD
            . "\"><img src=\"images/new.png\" border=\"0\"></a>" : ''), 
              'center',
              $calendar_theme['day_view_time_header'], 'style="white-space:nowrap" width="1%" rowspan="'
            . ($haveEventsThisHour ? '4' : '1') . '"');
      }



      // render each column of events
      //
      $colsToSpan = array();
      foreach ($output as $i => $outputSlot)
      {

         if (isset($outputSlot[$outputIndex]) && is_array($outputSlot[$outputIndex]))
         {

            $content = cal_encode_output($outputSlot[$outputIndex]['event']->getDescription());
            parseUrl($content);


            $editLink = '<a href="event_manage.php?calID=' . urlencode($calendar->getID())
               . "&year=$year&month=$month&day=$day&eventID="
               . $outputSlot[$outputIndex]['event']->getID()
               . '&calAction=' . SM_CAL_EVENT_ACTION_EDIT . '"'
               . (($outputSlot[$outputIndex]['event']->getPriority() <= $highlight_threshold)
               ? ' style="text-decoration:none; color: '
               . $calendar_theme['month_view_event_text_urgent'] . '"'
               : ' style="text-decoration:none; color: '
               . $calendar_theme['month_view_event_text_normal'] . '"') . '>';


            // put our own edit link into content, but we need to place it 
            // carefully around the links inserted by parseUrl() above
            //
            $content = $editLink . preg_replace(array('/<a\s+href/i',
                                                      '/<\/a>/i', 
                                                      '/###EDITLINKSTART###/', 
                                                      '/###EDITLINKEND###/'), 
                                                array('###EDITLINKEND###<a href',
                                                      '</a>###EDITLINKSTART###', 
                                                      $editLink, 
                                                      '</a>'),
                                                $content) . '</a>';


//TODO: wow.  this is completely unreadable.  need to clean up.
            echo html_tag('td', '', '',
                 $calendar_theme['day_view_event_background_1'],
////                 $calendar_theme['day_view_event_background_' . $alternatingBackgroundColor],
                 'rowspan="' . $outputSlot[$outputIndex]['rowspan'] . '" valign="top"'
               . (($outputSlot[$outputIndex]['event']->getPriority() <= $highlight_threshold)
               ? ' style="text-decoration:none; color: '
               . $calendar_theme['month_view_event_text_urgent'] . '"'
               : ' style="text-decoration:none; color: '
               . $calendar_theme['month_view_event_text_normal'] . '"'))
//TODO -- minor problem: say an event ends on the first quarter hour, and all other events on the page are "rowspanned" over that quarter of an hour (no actual cells for it), then it gets squished down to nothing and it is barely discernable that the event ends in that first quarter hour and not at the end of the last hour.  Hmmmm, how do we give it just a bit o' height?  
//TODO -- I have since made some changes to which hours get expanded... does this problem still exist? -- YES, it appears to...
               . '<small><a name="' . $outputSlot[$outputIndex]['event']->getID() 
               . '">' . $editLink
// uncomment for help debugging:
// . $outputSlot[$outputIndex]['event']->lengthInQuarterHours() . ' quarters :  '
               . $outputSlot[$outputIndex]['event']->getTitle() 
               . '</a></a>' . $editLink 
               . buildEventTimeDisplayText($outputSlot[$outputIndex]['event'], 
                                           $year, $month, $day)
               . '</a>' . ($calendar->isOwner($username) || $calendar->canWrite($username)
               ? '<a href="event_manage.php?calID=' . urlencode($calendar->getID())
               . "&year=$year&month=$month&day=$day&eventID=" 
               . $outputSlot[$outputIndex]['event']->getID()
               . '&calAction=' . SM_CAL_EVENT_ACTION_DELETE_CONFIRM 
               . '"><img src="images/delete_icon2.png" border="0"></a>' : '')
               . '<br />' . $content . '</small></td>';
         }


         // these should already be "rowspanned"
         //
         else if (isset($outputSlot[$outputIndex]))
         {}


         else
            $colsToSpan[] = $i;

      }



      // spit out empty cell(s) if needed
      //
      if (sizeof($colsToSpan))
      {

         // roll up adjacent empty cells into one
         // 
         $colspan = 0;
         $lastIndex = $colsToSpan[0] - 1;
         for ($i = 0; $i < sizeof($colsToSpan); $i++)
         {
            if ($colsToSpan[$i] == $lastIndex + 1)
               $colspan++;

            else
            {
               echo html_tag('td', '<small>&nbsp;</small>', '', 
                    $calendar_theme['day_view_no_event_background_' . $alternatingBackgroundColor],
                    'colspan="' . $colspan . '"');
               $colspan = 1;
            }

            $lastIndex = $colsToSpan[$i];
         }
         if ($colspan > 0)
            echo html_tag('td', '<small>&nbsp;</small>', '', 
                 $calendar_theme['day_view_no_event_background_' . $alternatingBackgroundColor],
                 'colspan="' . $colspan . '"');

      }


      // no events this hour -- skip next three quarter hours
      //
      if (!$haveEventsThisHour)
      {
         $timeIndex += 0.75;
         $outputIndex += 3;
      }



      echo '</tr>';

   }



   // print link to view events that fall outside of displayable hours
   //
   if  (sizeof($lateNightEvents))
   {
      echo html_tag('tr')
         . html_tag('td', '<small><a href="day.php?calID=' . urlencode($calendar->getID()) 
         . "&year=$year&month=$month&day=$day&allday=yes\">" . _("More") . '</a></small>', 'left',
           $calendar_theme['day_view_time_header'])
         . html_tag('td', '', 'left', 
           $calendar_theme['day_view_title_background'], 'colspan="' . sizeof($output) . '"');
      $count = 0;
      foreach ($lateNightEvents as $event)
      {
         if ($count++ > 0) echo '<small>, </small>';
         echo '<small' 
            . (($event->getPriority() <= $highlight_threshold)
            ? ' style="text-decoration:none; color: '
            . $calendar_theme['month_view_event_text_urgent'] . '"'
            : ' style="text-decoration:none; color: '
            . $calendar_theme['month_view_event_text_normal'] . '"')
            . '>' . $event->getTitle() . '</small>';
         if ($count >= $max_displayable_early_morn_late_nite_event_names)
            break;
      }
      echo '</td></tr>';
   }



   echo "<tr><td bgcolor=\"" . $calendar_theme['day_view_event_background_1'] 
      . "\" colspan=\"" . (sizeof($output) + 1) . "\"></td></tr></table>\n";


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

   showDayViewFooter($calendar, $year, $month, $day);

}



/**
  * Displays page footer for calendar day view
  *
  * @param object $calendar The calendar being viewed
  * @param int $year The year of the day to be shown
  * @param int $month The month of the day to be shown
  * @param int $day The day to be shown
  *
  */
function showDayViewFooter($calendar, $year, $month, $day)
{

   global $color, $username, $domain, $calendar_theme;


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   $external_list = get_all_external_calendars();
   $shared_list = get_all_accessible_calendars($username, $domain);
   $public_list = get_all_public_calendars();
   $calList = array_merge($shared_list, $public_list, $external_list);
   usort($calList, 'calendar_sort');


   // normal footer
   //
   echo html_tag('table', '', '', $calendar_theme['day_view_title_background'], 'width="100%" border="0" cellpadding="2" cellspacing="1"')
      . html_tag('tr') ."\n" 
      . html_tag('td', '', 'left', '', '') ."\n" 
      . "<form name=\"caljump\" action=\"day.php\" method=\"POST\">\n"
      . "<select name=\"year\">\n"
      . select_option_year($year)
      . "          </select>\n"
      . "          <select name=\"month\">\n"
      . select_option_month($month)
      . "          </select>\n"
      . "          <select name=\"day\">\n"
      . select_option_day($day)
      . "          </select>\n"
      . '         <input type="submit" value="' . _("Go") . "\">\n"
      . "         <input type=\"hidden\" name=\"calID\" value=\"" . urlencode($calendar->getID()) . "\">\n"
      . "          </form>\n"
      . "          </td>\n"
      . html_tag('td', '', 'center', '', 'valign="top"')
      . ($calendar->isOwner($username) || $calendar->canWrite($username)
      ? '<a href="event_manage.php?calID=' . urlencode($calendar->getID()) 
      . "&year=$year&month=$month&day=$day&calAction=" . SM_CAL_EVENT_ACTION_ADD . '">' 
      . _("Add Event") . '</a>' : '') 
      . '</td>'
      . html_tag('td', '', 'right', '', '') 
      . "\n<form name=\"calswitch\"><select name=\"calselect\">\n";


   foreach ($calList as $cal)
   {
      $calID = urlencode($cal->getID());
      echo "<option value=\"day.php?year=$year&month=$month&day=$day&calID=$calID\""
         . ($cal->getID() == $calendar->getID() ? ' SELECTED' : '')
         . ">" . $cal->getName() . "</option>\n";
   }


   echo "<option value=\"day.php?year=$year&month=$month&day=$day&calID=personal\""
      . ($calendar->getID() == get_personal_cal_id($username, $domain) ? ' SELECTED' : '')
      . ">Personal</option>\n"
      . "          </select>\n"
      . '          <input type="button" value="' . _("Go") . '" onClick="' 
      . 'for (i=0;i<document.calswitch.calselect.length;i++){ ' 
      . 'if (document.calswitch.calselect.options[i].selected) ' 
      . 'dest=document.calswitch.calselect.options[i].value;} ' 
      . 'location.href=dest;">' . "\n";
   echo "          </form></td></tr>\n".
        "</table>\n";


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



?>
