<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


define('SM_PATH','../../');



if (file_exists(SM_PATH . 'include/validate.php'))
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/interface/calendar_options.php');



// lock out users if not allowed to change prefs
//
global $cal_user_can_override_defaults;
if (!$cal_user_can_override_defaults) exit;



// update prefs if necessary
//
global $calendar_options_save_error_messages;
$calendar_options_save_error_messages = array();
sqgetGlobalVar('changeCalendarOptions', $changeCalendarOptions, SQ_POST);
if (!empty($changeCalendarOptions))
{

   global $username, $data_dir;


   sqgetGlobalVar('twentyfourHourTime', $twentyfourHourTime, SQ_POST);
   sqgetGlobalVar('external_calendar_clock_skew', $external_calendar_clock_skew, SQ_POST);
   sqgetGlobalVar('week_start_day', $week_start_day, SQ_POST);
   sqgetGlobalVar('highlight_threshold', $highlight_threshold, SQ_POST);
   sqgetGlobalVar('show_week_numbers_in_month_view_override', $show_week_numbers_in_month_view_override, SQ_POST);
   sqgetGlobalVar('max_events_per_day_on_month_view', $max_events_per_day_on_month_view, SQ_POST);
   sqgetGlobalVar('month_view_show_event_start_time', $month_view_show_event_start_time, SQ_POST);
   sqgetGlobalVar('month_view_show_daily_add_buttons', $month_view_show_daily_add_buttons, SQ_POST);
   sqgetGlobalVar('day_view_short_time', $day_view_short_time, SQ_POST);
   sqgetGlobalVar('day_view_show_hourly_add_buttons', $day_view_show_hourly_add_buttons, SQ_POST);
   sqgetGlobalVar('day_view_start_time', $newDay_view_start_time, SQ_POST);
   sqgetGlobalVar('day_view_end_time', $newDay_view_end_time, SQ_POST);
   sqgetGlobalVar('show_small_calendar', $show_small_calendar, SQ_POST);
   sqgetGlobalVar('small_calendar_calID', $small_calendar_calID, SQ_POST);
   sqgetGlobalVar('small_calendar_size', $small_calendar_size, SQ_POST);
   sqgetGlobalVar('small_calendar_separator', $small_calendar_separator, SQ_POST);
   sqgetGlobalVar('small_calendar_show_year', $small_calendar_show_year, SQ_POST);
   sqgetGlobalVar('small_calendar_show_today_link', $small_calendar_show_today_link, SQ_POST);
   sqgetGlobalVar('small_calendar_show_day_titles', $small_calendar_show_day_titles, SQ_POST);
   sqgetGlobalVar('small_calendar_inherit_day_background_colors', $small_calendar_inherit_day_background_colors, SQ_POST);
   sqgetGlobalVar('small_calendar_event_italic_style', $small_calendar_event_italic_style, SQ_POST);
   sqgetGlobalVar('small_calendar_header_color', $newSmall_calendar_header_color, SQ_POST);
   sqgetGlobalVar('small_calendar_today_color', $newSmall_calendar_today_color, SQ_POST);
   sqgetGlobalVar('small_calendar_event_color', $newSmall_calendar_event_color, SQ_POST);
   sqgetGlobalVar('small_calendar_day_color', $newSmall_calendar_day_color, SQ_POST);


   setPref($data_dir, $username, 'twentyfourHourTime', $twentyfourHourTime);
   setPref($data_dir, $username, 'external_calendar_clock_skew', $external_calendar_clock_skew);
   setPref($data_dir, $username, 'week_start_day', $week_start_day);
   setPref($data_dir, $username, 'highlight_threshold', $highlight_threshold);
   setPref($data_dir, $username, 'show_week_numbers_in_month_view_override', $show_week_numbers_in_month_view_override);
   setPref($data_dir, $username, 'max_events_per_day_on_month_view', $max_events_per_day_on_month_view);
   setPref($data_dir, $username, 'month_view_show_event_start_time', $month_view_show_event_start_time);
   setPref($data_dir, $username, 'month_view_show_daily_add_buttons', $month_view_show_daily_add_buttons);
   setPref($data_dir, $username, 'day_view_short_time', $day_view_short_time);
   setPref($data_dir, $username, 'day_view_show_hourly_add_buttons', $day_view_show_hourly_add_buttons);
   setPref($data_dir, $username, 'show_small_calendar', $show_small_calendar);
   setPref($data_dir, $username, 'small_calendar_calID', $small_calendar_calID);
   setPref($data_dir, $username, 'small_calendar_size', $small_calendar_size);
   setPref($data_dir, $username, 'small_calendar_separator', $small_calendar_separator);
   setPref($data_dir, $username, 'small_calendar_show_year', $small_calendar_show_year);
   setPref($data_dir, $username, 'small_calendar_show_today_link', $small_calendar_show_today_link);
   setPref($data_dir, $username, 'small_calendar_show_day_titles', $small_calendar_show_day_titles);
   setPref($data_dir, $username, 'small_calendar_inherit_day_background_colors', $small_calendar_inherit_day_background_colors);
   setPref($data_dir, $username, 'small_calendar_event_italic_style', $small_calendar_event_italic_style);
//LEFT OFF HERE -- default values in config file are
//                 usually in the form  $color[x] but
//                 when shown and subsequently submitted
//                 here, they come in as #770000 so we
//                 lose the theme changing compatibility.
//                 so for now, we should check if the
//                 submitted value is the same as the
//                 default, DO NOT set the user pref!!
//
//                 This applies to:
//                    small_calendar_header_color
//                    small_calendar_today_color
//                    small_calendar_event_color
//                    small_calendar_day_color


   // if any colors are the same as the defaults, remove any trace
   // of that color from user prefs (because the default might actually
   // be in the form $color[x], where we will retain cross-theme
   // compatibility -- setting it to a hard-coded value here would
   // be less desirable 
   //
   // also, make sure colors are in hex form with leading pound sign only
   //
   if ($newSmall_calendar_header_color == $small_calendar_header_color_default)
   {
      removePref($data_dir, $username, 'small_calendar_header_color');
      $small_calendar_header_color = $small_calendar_header_color_default;
   }
   else if (preg_match('/^#[0-9A-Fa-f]{6}$/', $newSmall_calendar_header_color))
   {
      setPref($data_dir, $username, 'small_calendar_header_color', $newSmall_calendar_header_color);
      $small_calendar_header_color = $newSmall_calendar_header_color;
   }
   else
   {
      $calendar_options_save_error_messages[] = _("Badly formatted header color");
   }

   if ($newSmall_calendar_today_color == $small_calendar_today_color_default)
   {
      removePref($data_dir, $username, 'small_calendar_today_color');
      $small_calendar_today_color = $small_calendar_today_color_default;
   }
   else if (preg_match('/^#[0-9A-Fa-f]{6}$/', $newSmall_calendar_today_color))
   {
      setPref($data_dir, $username, 'small_calendar_today_color', $newSmall_calendar_today_color);
      $small_calendar_today_color = $newSmall_calendar_today_color;
   }
   else
   {
      $calendar_options_save_error_messages[] = _("Badly formatted today color");
   }

   if ($newSmall_calendar_event_color == $small_calendar_event_color_default)
   {
      removePref($data_dir, $username, 'small_calendar_event_color');
      $small_calendar_event_color = $small_calendar_event_color_default;
   }
   else if (preg_match('/^#[0-9A-Fa-f]{6}$/', $newSmall_calendar_event_color))
   {
      setPref($data_dir, $username, 'small_calendar_event_color', $newSmall_calendar_event_color);
      $small_calendar_event_color = $newSmall_calendar_event_color;
   }
   else
   {
      $calendar_options_save_error_messages[] = _("Badly formatted event color");
   }

   if ($newSmall_calendar_day_color == $small_calendar_day_color_default)
   {
      removePref($data_dir, $username, 'small_calendar_day_color');
      $small_calendar_day_color = $small_calendar_day_color_default;
   }
   else if (preg_match('/^#[0-9A-Fa-f]{6}$/', $newSmall_calendar_day_color))
   {
      setPref($data_dir, $username, 'small_calendar_day_color', $newSmall_calendar_day_color);
      $small_calendar_day_color = $newSmall_calendar_day_color;
   }
   else
   {
      $calendar_options_save_error_messages[] = _("Badly formatted day color");
   }


   // don't allow day view start time to come after end time
   //
   if ($newDay_view_start_time >= $newDay_view_end_time)
   {
      $calendar_options_save_error_messages[] = _("Day view start time must come before end time");
   }
   else
   {
      setPref($data_dir, $username, 'day_view_start_time', $newDay_view_start_time);
      setPref($data_dir, $username, 'day_view_end_time', $newDay_view_end_time);
      $day_view_start_time = $newDay_view_start_time;
      $day_view_end_time = $newDay_view_end_time;
   }

}



// print standard SM page header
//
global $color;
if (!isset($color[12])) $color[12] = '';
displayPageHeader($color, 'None');



display_calendar_options($calendar_options_save_error_messages);



?>
