<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


define('SM_PATH','../../');



if (file_exists(SM_PATH . 'include/validate.php')) 
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');
include_once(SM_PATH . 'functions/date.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/interface/calendar.php');



// get calendar...
//
global $username, $domain, $color, $week_start_day;
sqgetGlobalVar('calID', $calID, SQ_FORM);
$calID = urldecode($calID);



// personal calendar: get ID from backend, then get calendar
//
if ($calID == 'personal') 
{
   $calID = get_personal_cal_id($username, $domain);
   $calendar = get_calendar($calID);
}


// for any other type of calendar, we should check 
// that user has access rights 
// 
else
{
   $calendar = get_calendar($calID);
   if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
      exit;
}



sqgetGlobalVar('year', $year, SQ_FORM);
$now = time();
$dateArray = getdate($now);
$todaysYear = $dateArray['year'];
$todaysMonth = $dateArray['mon'];
$todaysDay = $dateArray['mday'];
$month = $todaysMonth;
$day = $todaysDay;



// make sure we have viewing year
//
if (empty($year))
{
   $year = $todaysYear;
}



// print standard SM page header
// and generic calendar header
//
if (!isset($color[12])) $color[12] = '';
displayPageHeader($color, 'None');
showCalendarHeader($calendar, SM_CAL_VIEW_MODE_MONTH, $year, $month, $day);



// show the calendar
//
$calendar->showAllMonths($year, $username, $week_start_day);



echo '</body></html>';

?>
