<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



function download_calendar($calID, $absolute_dl)
{

   $calendar = get_calendar($calID);
   $filename = $calendar->getName() . '.ics';


/* nope.  this is all just new in 1.5.1...... how/can we put it and ALL its dependencies in the compatibility plugin?
// TODO: do we need to do this?  does it work with 1.4.x? (copied from 1.5.1)
// note that maybe maybe (uh, maybe not), the cal already gives it to us in the right charset
   global $default_charset;
   set_my_charset();
//TODO- if we use this, understand the params... is all it needs filename?
//           does it need fullPath?  what is that boolean param?
//TODO -- also does this  stuff exist in 1.4.x or 1.2.x?
   $filename = charset_encode($filename, $default_charset, false);
*/


   // from /src/download.php:  
   header('Pragma: ');
   header('Cache-Control: cache');


   $type0 = 'text';
   $type1 = 'calendar';


   cal_SendDownloadHeaders($type0, $type1, $filename, ($absolute_dl=='true'));


   // Don't kill the connection if the browser is over a dialup
   // and it would take over 30 seconds to download it.
   // Don't call set_time_limit in safe mode.
   //
   if (!ini_get('safe_mode')) 
      set_time_limit(0);


   global $username;


   // echo iCal stream directly to browser, then exit
   //
   echo $calendar->getICal(FALSE, $username);
   exit;


}



   //
   // from here on is a modified rip-off of same fxn in SM core
   //


/*
 * This function is verified to work with Netscape and the *very latest*
 * version of IE.  I don't know if it works with Opera, but it should now.
 */
function cal_SendDownloadHeaders($type0, $type1, $filename, $force, $filesize=0) {

    // get global variables for versions of PHP < 4.1
    //
    if (!compatibility_check_php_version(4, 1)) {
       global $HTTP_SERVER_VARS;
       $_SERVER = $HTTP_SERVER_VARS;
    }


//LEFT OFF HERE: we really should remove this and use the same fxn in SM
//               the compatibility plugin should provide it as well as a
//                stand-in (when needed) for sqgetGlobalVar, which is in
//               the orig version of this fxn which is why we aren't using it here ATM
    $HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];

    global $languages, $squirrelmail_language;
    $isIE = $isIE6 = 0;

     if (strstr($HTTP_USER_AGENT, 'compatible; MSIE ') !== false &&
         strstr($HTTP_USER_AGENT, 'Opera') === false) {
         $isIE = 1;
     }

     if (strstr($HTTP_USER_AGENT, 'compatible; MSIE 6') !== false &&
         strstr($HTTP_USER_AGENT, 'Opera') === false) {
         $isIE6 = 1;
     }

//LEFT OFF HERE - does this break on older SM versions?  or is it ok?
     if (isset($languages[$squirrelmail_language]['XTRA_CODE']) &&
         function_exists($languages[$squirrelmail_language]['XTRA_CODE'] . '_downloadfilename')) {
         $filename =
         call_user_func($languages[$squirrelmail_language]['XTRA_CODE'] . '_downloadfilename', $filename, $HTTP_USER_AGENT);
     } else {
         $filename = ereg_replace('[\\/:\*\?"<>\|;]', '_', str_replace('&nbsp;', ' ', $filename));
     }

     // A Pox on Microsoft and it's Internet Explorer!
     //
     // IE has lots of bugs with file downloads.
     // It also has problems with SSL.  Both of these cause problems
     // for us in this function.
     //
     // See this article on Cache Control headers and SSL
     // http://support.microsoft.com/default.aspx?scid=kb;en-us;323308
     //
     // The best thing you can do for IE is to upgrade to the latest
     // version
     //set all the Cache Control Headers for IE
     if ($isIE) {
         $filename=rawurlencode($filename);
         header ("Pragma: public");
         header ("Cache-Control: no-store, max-age=0, no-cache, must-revalidate"); # HTTP/1.1
         header ("Cache-Control: post-check=0, pre-check=0", false);
         header ("Cache-control: private");

         //set the inline header for IE, we'll add the attachment header later if we need it
         header ("Content-Disposition: inline; filename=$filename");
     }

     if (!$force) {
         // Try to show in browser window
         header ("Content-Disposition: inline; filename=\"$filename\"");
         header ("Content-Type: $type0/$type1; name=\"$filename\"");
     } else {
         // Try to pop up the "save as" box

         // IE makes this hard.  It pops up 2 save boxes, or none.
         // http://support.microsoft.com/support/kb/articles/Q238/5/88.ASP
         // http://support.microsoft.com/default.aspx?scid=kb;EN-US;260519
         // But, according to Microsoft, it is "RFC compliant but doesn't
         // take into account some deviations that allowed within the
         // specification."  Doesn't that mean RFC non-compliant?
         // http://support.microsoft.com/support/kb/articles/Q258/4/52.ASP

         // all browsers need the application/octet-stream header for this
         header ("Content-Type: application/octet-stream; name=\"$filename\"");

         // http://support.microsoft.com/support/kb/articles/Q182/3/15.asp
         // Do not have quotes around filename, but that applied to
         // "attachment"... does it apply to inline too?
         header ("Content-Disposition: attachment; filename=\"$filename\"");

         if ($isIE && !$isIE6) {
             // This combination seems to work mostly.  IE 5.5 SP 1 has
             // known issues (see the Microsoft Knowledge Base)

             // This works for most types, but doesn't work with Word files
             header ("Content-Type: application/download; name=\"$filename\"");

             // These are spares, just in case.  :-)
             //header("Content-Type: $type0/$type1; name=\"$filename\"");
             //header("Content-Type: application/x-msdownload; name=\"$filename\"");
             //header("Content-Type: application/octet-stream; name=\"$filename\"");
         } else {
             // another application/octet-stream forces download for Netscape
             header ("Content-Type: application/octet-stream; name=\"$filename\"");
         }
     }

     //send the content-length header if the calling function provides it
     if ($filesize > 0) {
         header("Content-Length: $filesize");
     }

}  // end fn SendDownloadHeaders



?>
