#!/bin/sh

# Converts older SquirrelMail calendar data files into iCal files
#
# Usage: convert_cal_data 
#
# Pulls data directory location from command line, bails if not given.
#

clear
echo ""
echo "Usage: give the path to the calendar plugin directory on"
echo "       the command line or script will fail"
echo ""
echo "Requires the Date::ICal Perl module; will fail if not installed"
echo ""
echo "Requires the convert_cal_to_ical.pl file to be in the directory"
echo "from which this script is being executed; will fail if not found"
echo ""
echo "Requires /tmp to be writable by user running this script; will"
echo "fail if it is not found or not accessible (change $newCalFile"
echo "in convert_cal_to_ical.pl if you need to point it elsewhere)"
echo ""
echo "Note that events without any duration are converted into one-day events"
echo ""



DIRNAME=$1
shift
if test -z "$DIRNAME" -o ! -d "$DIRNAME"; then
   
   echo ""
   echo "Data directory path not given; exiting"
   echo ""
   exit 1

fi


STARTDIR=`pwd`


echo "Finding calendar files to convert..."
echo



#==================================================================================

function convert_cal_files
{


local MYDIR=$1
shift

pushd $MYDIR > /dev/null


#for FILENAME in *     # Traverse all files in directory.
for FILENAME in `ls`     # Traverse all files in directory.

do

#echo -n "FILE IS "
#echo $FILENAME
#continue


   # recurse
   #
   if test -d "$FILENAME"; then

      local DIRNAME="$FILENAME"

      convert_cal_files "$FILENAME"

      continue

   fi


   # only pick out files that end with ".cal"
   #
   if test ${FILENAME:(-4)} = '.cal'; then
      
      echo "------------------------------  $FILENAME ------------------------------"
#cat $FILENAME

      $STARTDIR/convert_cal_to_ical.pl $FILENAME

   fi


done

popd > /dev/null

}

convert_cal_files $DIRNAME

echo 
