<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


define('SM_PATH','../../');



if (file_exists(SM_PATH . 'include/validate.php')) 
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/interface/admin_interface.php');



// lock out unauthorized users
//
global $username;
$userType = check_cal_user_type($username);
if (!($userType == SM_CAL_SUPERUSER || $userType == SM_CAL_LIMITED_ADMIN))
   exit;



// print standard SM page header
// and calendar main admin menu
//
global $color;
if (!isset($color[12])) $color[12] = '';
displayPageHeader($color, 'None');
display_main_admin_interface($color);



// has the user chosen to edit either users or calendars?
// if so, $cal_action will have SM_CAL_EDIT_USERS or
// SM_CAL_EDIT_CALENDARS in it
//
sqgetGlobalVar('cal_action', $cal_action, SQ_FORM);
if (isset($cal_action) 
 && ($cal_action == SM_CAL_EDIT_USERS || $cal_action == SM_CAL_EDIT_CALENDARS
  || $cal_action == SM_CAL_EDIT_HOLIDAYS))
{

   //====================================================================================
   // EDIT CALENDARS
   //====================================================================================

   if ($cal_action == SM_CAL_EDIT_CALENDARS) 
   {

      sqgetGlobalVar('add_action', $add_action, SQ_POST);
      sqgetGlobalVar('del_action', $del_action, SQ_POST);


      // add new calendar
      //
      if (isset($add_action) && $add_action == 'Add') 
      {

         sqgetGlobalVar('public', $public, SQ_POST);
         sqgetGlobalVar('new_cal', $new_cal, SQ_POST);
         $new_cal = trim($new_cal);

         if (!empty($new_cal)) 
         {

            global $domain;

            if (isset($public) && $public == 'yes') 
               $calendar = new Calendar('', 0, $domain, '', SM_CAL_TYPE_PUBLIC, 
                                        $new_cal, $username, gmdate('Ymd\THis\Z'), 
                                        '', '', array($username));
            else 
               $calendar = new Calendar('', 0, $domain, '', SM_CAL_TYPE_SHARED, 
                                        $new_cal, $username, gmdate('Ymd\THis\Z'), 
                                        '', '', array($username));

            create_calendar($calendar);

         }
      }


      // delete calendar(s)
      //
      elseif (isset($del_action) && $del_action == 'Delete')
      {

         sqgetGlobalVar('delitem', $delitem, SQ_POST);
         if (is_array($delitem)) foreach ($delitem as $calID => $junk)
         {

            delete_calendar($calID);

         }

      }


      // get list of all calendars available to this admin user
      //
      $calList = get_all_owned_calendars($username);
      display_calendar_admin_interface($color, $calList);

   }

   //====================================================================================
   // EDIT USERS
   //====================================================================================

   elseif ($cal_action == SM_CAL_EDIT_USERS) 
   {

      sqgetGlobalVar('user_action', $user_action, SQ_POST);

      // delete users from calendar
      // 
      if (isset($user_action) && $user_action == 'delete')
      {

         sqgetGlobalVar('users', $users, SQ_POST);
         sqgetGlobalVar('calID', $calID, SQ_POST);
         $calendar = get_calendar($calID);

         if (is_array($users)) foreach ($users as $user => $junk)
         {

            // decode user name
            //
            $user = str_replace(array('SPACE', 'QUESTION', 'ASTERISK'), array(' ', '?', '*'), $user);


            // remove user
            //
            $calendar->remove_user($user);

         }

         // now increment calendar sequence and re-save calendar
         //
         $calendar->incrementSequence();
         $calendar->setLastUpdator($username);
         $calendar->setLastUpdateDate(gmdate('Ymd\THis\Z'));
         update_calendar($calendar);

      }


      // add new user to calendar 
      //
      else if (isset($user_action) && $user_action == 'add')
      {

         sqgetGlobalVar('addUser', $addUser, SQ_POST);
         $addUser = trim($addUser);
         sqgetGlobalVar('addUserPerm', $addUserPerm, SQ_POST);
         sqgetGlobalVar('calID', $calID, SQ_POST);
         $calendar = get_calendar($calID);

         if (!empty($addUser))
         {
            $calendar->add_user($addUser, $addUserPerm);
            $calendar->incrementSequence();
            $calendar->setLastUpdator($username);
            $calendar->setLastUpdateDate(gmdate('Ymd\THis\Z'));
            update_calendar($calendar);
         }

      }


      // update user permissions
      //
      else if (isset($user_action) && $user_action == 'saveperms')
      {

         sqgetGlobalVar('userPerms', $userPerms, SQ_POST);
         sqgetGlobalVar('calID', $calID, SQ_POST);
         $calendar = get_calendar($calID);

         if (is_array($userPerms)) foreach ($userPerms as $user => $perm)
         {

            // decode user name
            //
            $user = str_replace(array('SPACE', 'QUESTION', 'ASTERISK'), array(' ', '?', '*'), $user);


            // remove and re-add user with correct permissions
            //
            $calendar->remove_user($user);
            $calendar->add_user($user, $perm);

         }

         // now increment calendar sequence and re-save calendar
         //
         $calendar->incrementSequence();
         $calendar->setLastUpdator($username);
         $calendar->setLastUpdateDate(gmdate('Ymd\THis\Z'));
         update_calendar($calendar);

      }


      // get list of all calendars available to this admin user
      //
      $calList = get_all_owned_calendars($username);
      display_user_admin_interface($color, $calList);

   }        

   //====================================================================================
   // EDIT HOLIDAYS
   //====================================================================================

   elseif ($cal_action == SM_CAL_EDIT_HOLIDAYS) 
   {

      sqgetGlobalVar('calID', $calID, SQ_FORM);

      sqgetGlobalVar('holidayAction', $holidayAction, SQ_POST);


//   LEFT OFF HERE  --  NOTE!!  if calID is for a personal calendar, note that 
//                              the user came in from a different interface (month/year cal view)
//                              instead of the admin interface, so make sure that works
//                              correctly and also doesn't expose admin interface to non admins!
//   ALSO, it's a bit questionable to let all cal admins see holidays created for
//        a user's personal calendar (privacy), so maybe just allow private cals to
//        use preexisting holidays but not create their own holidays!  yes.
//LEFT OFF HERE ... just sample code from above....  what holiday actions do we have...?
//LEFT OFF HERE ... just sample code from above....  what holiday actions do we have...?
//LEFT OFF HERE ... just sample code from above....  what holiday actions do we have...?
      // delete users from calendar
      // 
      if (isset($user_action) && $user_action == 'delete')
      {

         sqgetGlobalVar('users', $users, SQ_POST);
         sqgetGlobalVar('calID', $calID, SQ_POST);
         $calendar = get_calendar($calID);

         if (is_array($users)) foreach ($users as $user => $junk)
         {

            // decode user name
            //
            $user = str_replace(array('SPACE', 'QUESTION', 'ASTERISK'), array(' ', '?', '*'), $user);


            // remove user
            //
            $calendar->remove_user($user);

         }

         // now re-save calendar
         //
         $calendar->incrementSequence();
         $calendar->setLastUpdator($username);
         $calendar->setLastUpdateDate(gmdate('Ymd\THis\Z'));
         update_calendar($calendar);

      }


      // get list of all holidays and the holidays 
      // for this calendar (those are contained in
      // the calendar object)
      //
      $calendar = get_calendar($calID);
      $holidayList = get_all_global_holidays();
      display_holiday_admin_interface($color, $calendar, $holidayList);

   }

}

echo '</body></html>';

?>
