<?php
/*
 *  functions.php
 *
 *  Copyright (c) 2001 Michal Szczotka <michal@tuxy.org>
 *  Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 *  miscelenous functions.
 *  Modified by Jason Munro 6/28/02
 *
 */



function cal_admin_block_do()
{

    global $username;
    if (isset($_SESSION['username'])) 
        $username = $_SESSION['username'];

    $approved = approve_cal_admin($username);
    if (!($approved == 'SUPERUSER' || $approved == 'LIMITED'))
        return;

    global $optpage_blocks;
    $optpage_blocks[] = array(
        'name' => _("Shared Calendar Administration"),
        'url'  => '../plugins/calendar/admin_options.php',
        'desc' => _("Create and maintain shared calendars. Assign access by user or create publicly available calendars"),
        'js'   => false
        );

}


// returns "SUPERUSER" if the user in question has 
// permission to edit any and all calendars, or 
// "LIMITED" if the user only can edit their own
// calendar(s), or "NONE" if the user has no administrative
// permissions
//
function approve_cal_admin($user) {

    $debug = 0;

    global $admins;

    include_once(SM_PATH . 'plugins/calendar/data/config.php');

    foreach ($admins as $admin => $perms) 
    {

        if ($debug) echo "username=$user admin=$admin<br>admin == username ?? --> ". (strtolower($user)==strtolower($admin))."<br>";


        if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'),
                       strtoupper($admin)) . '$/', strtoupper($user)))
        {
            $perms = trim($perms);
            if (strtolower($perms) == 'yes')
                return 'SUPERUSER';
            else
                return 'LIMITED';
        }

    }

    return 'NONE';

}


function calendar_header() {
    //Add Second layer ofCalendar links to upper menu
    global $color,$year,$day,$month,$cal;

    $todaysMonth = date( 'm' );
    if ($month == $todaysMonth)
       $theDay = $day;
    else
       $theDay = '01';

    $print_cal = urldecode($cal);
    echo "<TABLE BGCOLOR=\"$color[0]\" BORDER=0 WIDTH=\"100%\" CELLSPACING=0 CELLPADDING=2>".
         "<TR><TD ALIGN=left WIDTH=\"100%\">";

    print "<tr><td><center><h3>$print_cal Calendar</h3></center></td></tr>";


    displayInternalLink("plugins/calendar/year.php?year=$year&month=$month&day=$theDay&cal=".urlencode($cal),_("Year View"),"right");
    echo "&nbsp;&nbsp\n";
    displayInternalLink("plugins/calendar/calendar.php?year=$year&month=$month&cal=".urlencode($cal),_("Month View"),"right");
    echo "&nbsp;&nbsp\n";
    displayInternalLink("plugins/calendar/day.php?year=$year&month=$month&day=$theDay&cal=".urlencode($cal),_("Day View"),"right");
    echo "&nbsp;&nbsp\n";
    // displayInternalLink("plugins/calendar/event_create.php?year=$year&month=$month&day=$day",_("Add Event"),"right");
    // echo "&nbsp;&nbsp\n";
    echo '</TD></TR>';

}

function select_option_length($selected) {

    $eventlength = array(
        '0' => _("0 min."),
        '15' => _("15 min."),
        '30' => _("30 min."),
        '45' => _("45 min."),
        '60' => _("1 hr."),
        '90' => _("1.5 hr."),
        '120' => _("2 hr."),
        '150' => _("2.5 hr."),
        '180' => _("3 hr."),
        '210' => _("3.5 hr."),
        '240' => _("4 hr."),
        '300' => _("5 hr."),
        '360' => _("6 hr.")
    );

    while( $bar = each($eventlength)) {
        if($selected==$bar['key']){
                echo "        <OPTION VALUE=\"".$bar['key']."\" SELECTED>".$bar['value']."</OPTION>\n";
        } else {
                echo "        <OPTION VALUE=\"".$bar['key']."\">".$bar['value']."</OPTION>\n";
        }
    }
}

function select_option_minute($selected) {
    $eventminute = array(
    '00'=>'00',
    '05'=>'05',
    '10'=>'10',
    '15'=>'15',
    '20'=>'20',
    '25'=>'25',
    '30'=>'30',
    '35'=>'35',
    '40'=>'40',
    '45'=>'45',
    '50'=>'50',
    '55'=>'55'
    );

    while ( $bar = each($eventminute)) {
        if ($selected==$bar['key']){
                echo "        <OPTION VALUE=\"".$bar['key']."\" SELECTED>".$bar['value']."</OPTION>\n";
        } else {
                echo "        <OPTION VALUE=\"".$bar['key']."\">".$bar['value']."</OPTION>\n";
        }
    }
}

function select_option_hour($selected) {

    for ($i=0;$i<24;$i++){
        ($i<10)? $ih = "0" . $i : $ih = $i;
        if ($ih==$selected){
            echo "            <OPTION VALUE=\"$ih\" SELECTED>$i</OPTION>\n";
        } else {
            echo "            <OPTION VALUE=\"$ih\">$i</OPTION>\n";
        }
    }
}

function select_option_priority($selected) {
    $eventpriority = array(
        '0' => _("Normal"),
        '1' => _("High"),
    );

    while( $bar = each($eventpriority)) {
        if($selected==$bar['key']){
                echo "        <OPTION VALUE=\"".$bar['key']."\" SELECTED>".$bar['value']."</OPTION>\n";
        } else {
                echo "        <OPTION VALUE=\"".$bar['key']."\">".$bar['value']."</OPTION>\n";
        }
    }
}

function select_option_year($selected) {

    for ($i=1902;$i<2038;$i++){
        if ($i==$selected){
            echo "            <OPTION VALUE=\"$i\" SELECTED>$i</OPTION>\n";
        } else {
            echo "            <OPTION VALUE=\"$i\">$i</OPTION>\n";
        }
    }
}

function select_option_month($selected) {

    for ($i=1;$i<13;$i++){
        $im=date('m',mktime(0,0,0,$i,1,1));
        $is = substr( _( date('F',mktime(0,0,0,$i,1,1)) ), 0, 3 );
        if ($im==$selected){
            echo "            <OPTION VALUE=\"$im\" SELECTED>$is</OPTION>\n";
        } else {
            echo "            <OPTION VALUE=\"$im\">$is</OPTION>\n";
        }
    }
}

function select_option_day($selected) {

    for ($i=1;$i<32;$i++){
        ($i<10)? $ih="0".$i : $ih=$i;
        if ($i==$selected){
            echo "            <OPTION VALUE=\"$ih\" SELECTED>$i</OPTION>\n";
        } else {
            echo "            <OPTION VALUE=\"$ih\">$i</OPTION>\n";
        }
    }
}

?>
