<?php
/*
 *  calendar_data.php
 *
 *  Copyright (c) 2001 Michal Szczotka <michal@tuxy.org>
 *  Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 *  functions to operate on calendar data files.
 *  Modified by Jason Munro on 6/28/02
 *
 */

// this is array that contains all events
// it is three dimensional array with fallowing structure
// $calendardata[date][time] = array(length,priority,title,message);
$calendardata = array();

    
//read events into array
//data is | delimited, just like addresbook
//files are structured like this:
//date|time|length|priority|title|message);
//files are divide by year for performance increase
function readcalendardata() {
    global $calendardata, $username, $data_dir, $year, $cal;

    if ($cal != 'Personal') {
        $cal_name = $cal;
        $filename = $data_dir . "$cal_name.$year.cal";
    }
    else {
        $cal_name = $username;
        $filename = getHashedFile($username, $data_dir, "$cal_name.$year.cal");
    }


    if (file_exists($filename)){
        $fp = fopen ($filename,'r');

        if ($fp){
            while ($fdata = fgetcsv ($fp, 4096, '|')) {
                $calendardata[$fdata[0]][$fdata[1]] = array( 'length' => $fdata[2],
                                                            'priority' => $fdata[3],
                                                            'title' => htmlentities($fdata[4]),
                                            // don't need to htmlentities-ize the 
                                            // message, since it is done upon creation
                                                            'message' => $fdata[5],
                                                            'reminder' => htmlentities($fdata[6]),
                                                            'creator' => $fdata[7], 
                                                            'editedby' => $fdata[8] );
            }
            fclose ($fp);
        }
    }
}

//makes events persistant
function writecalendardata() {
    global $calendardata, $username, $data_dir, $year, $cal;
    if ($cal != 'Personal') {
        $cal_name = $cal;
        $filename = $data_dir . "$cal_name.$year.cal";
        $filetmp = $data_dir . "$cal_name.$year.cal.tmp";
    }
    else {
        $cal_name = $username;
        $filetmp = getHashedFile($username, $data_dir, "$cal_name.$year.cal.tmp");
        $filename = getHashedFile($username, $data_dir, "$cal_name.$year.cal");
    }
    $fp = fopen ($filetmp,"w");
    if ($fp) {
        while ( $calfoo = each ($calendardata)) {
            while ( $calbar = each ($calfoo['value'])) {
                $calfoobar = $calendardata[$calfoo['key']][$calbar['key']];
                if (!isset($calfoobar['reminder'])) {
                    $calfoobar['reminder'] = '';
                }
                $calstr = "$calfoo[key]|$calbar[key]|$calfoobar[length]|$calfoobar[priority]|$calfoobar[title]|$calfoobar[message]|$calfoobar[reminder]|$calfoobar[creator]|$calfoobar[editedby]\n";
                fwrite($fp, $calstr, 4096);
            }

        }
        fclose ($fp);
        @unlink($filename);
        rename($filetmp,$filename);
    }
}

//deletes event from file
function delete_event($date, $time) {
    global $calendardata, $username, $data_dir, $year, $cal;

    if ($cal != 'Personal') {
        $cal_name = $cal;
        $filename = $data_dir . "$cal_name.$year.cal";
    }
    else {
        $cal_name = $username;
        $filename = getHashedFile($username, $data_dir, "$cal_name.$year.cal");
    }

    $fp = fopen ($filename,'r');
    if ($fp){
        while ($fdata = fgetcsv ($fp, 4096, "|")) {
            if (($fdata[0]==$date) && ($fdata[1]==$time)){
            // do nothing
            } else {
                $calendardata[$fdata[0]][$fdata[1]] = array( 'length' => $fdata[2],
                                                             'priority' => $fdata[3],
                                                             'title' => $fdata[4],
                                                             'message' => $fdata[5],
                                                            'reminder' => htmlentities($fdata[6]),
                                                            'creator' => $fdata[7], 
                                                            'editedby' => $fdata[8] );
            }
        }
        fclose ($fp);
    }
    writecalendardata();

}

// same as delete but not saves calendar
// saving is done inside event_edit.php
function update_event($date, $time) {
    global $calendardata, $username, $data_dir, $year, $cal;

    if ($cal != 'Personal') {
        $cal_name = $cal;
        $filename = $data_dir . "$cal_name.$year.cal";
    }
    else {
        $cal_name = $username;
        $filename = getHashedFile($username, $data_dir, "$cal_name.$year.cal");
    }

    $fp = fopen ($filename,'r');
    if ($fp){
        while ($fdata = fgetcsv ($fp, 4096, '|')) {
            if (($fdata[0]==$date) && ($fdata[1]==$time)){
            // do nothing
            } else {
                $calendardata[$fdata[0]][$fdata[1]] = array( 'length' => $fdata[2],
                                                             'priority' => $fdata[3],
                                                             'title' => $fdata[4],
                                                             'message' => $fdata[5],
                                                            'reminder' => htmlentities($fdata[6]),
                                                            'creator' => $fdata[7], 
                                                            'editedby' => $fdata[8] );
            }
        }
        fclose ($fp);
    }
}


?>
