<?php

/**
  *  Admin options page for the Shared Calendar plugin
  *  by Jason Munro 6/23/02
  *
  **/

require_once('shared_functions.php');
chdir ('..');
require_once('../src/validate.php');
require_once('../functions/page_header.php');

extract($_POST);

if (!isset($color[12])) $color[12] = '';
displayPageHeader($color, 'None');
main_menu($color);
$indent = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
if (isset($cal_action)) {
     if ($cal_action == 'Calendars') {
        if (isset($add_action) && $add_action == 'Add') {
            if (!empty($new_cal) && !preg_match("/^(\s){1,}$/", $new_cal)) {
                if (isset($public) && $public == 'yes') {
                    $type = 'public';
                    $cal_list = read_calendar_list($data_dir, 'public');
                    array_push($cal_list, $new_cal);
                    save_calendar_list($data_dir, $cal_list, $type);
                }
                else {
                    $type = 'shared';
                    $cal_list = read_calendar_list($data_dir, 'shared');
                    array_push($cal_list, $new_cal);
                    save_calendar_list($data_dir, $cal_list, $type);
                    addto_user_codes($data_dir);
                }
            }
        }
        elseif (isset($del_action) && $del_action == 'Delete' &&
               (isset($selected_shared_calendar) || isset($selected_public_calendar))) {
            if (isset($selected_shared_calendar)) {
                $type = 'shared';
                $selected_calendar = $selected_shared_calendar;
            }
            elseif (isset($selected_public_calendar)) {
                $type = 'public';
                $selected_calendar = $selected_public_calendar;
            }
            $cal_list = read_calendar_list($data_dir, $type);
            array_splice($cal_list, $selected_calendar, 1); 
            save_calendar_list($data_dir, $cal_list, $type);
            if (isset($selected_shared_calendar)) {
                if (empty($cal_list)) {
                    delall_user_codes($data_dir);
                }
                else {
                    delfrom_user_codes($data_dir, $selected_calendar);
                }
            }
        }
         $shared_list = read_calendar_list($data_dir, 'shared');
         print "<br><table align=center width=\"80%\"><tr><td align=left>" . _("<b>Shared</b>\n".
               " calendars can be assigned to users with read only\n".
               " or read/write access. To enable users to access defined\n".
               " calendars use the \"Users\" button.") . "</td></tr><tr><td align=left>";
        print "<br>" . _("<b>Public</b> calendars are available to all SquirrelMail users\n".
              " in addition to their private personal calendar.") . "</td></tr></table><br>\n".
              "<form action=\"admin_options.php\" method=post>\n".
              "<table align=center width=\"80%\" bgcolor=\"$color[9]\">\n".
              "<tr bgcolor=\"$color[4]\"><td align=center>\n";
         if (!empty($shared_list)) {
            print "<br><table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                  "<tr bgcolor=\"$color[10]\"><td align=center></td><td align=center>\n".
                  "<b>" . _("Shared calendars") . "</b>\n".
                  "</td></tr>\n";
            $r=0;
            foreach ($shared_list as $calendar) {
                print "<tr><td align=center>\n".
                      "<input type=radio name=\"selected_shared_calendar\" value=\"$r\">\n".
                      "</td><td align=center>$calendar</td></tr>\n";
                $r++;
            }
         }
         else {
             print "<table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                   "<tr bgcolor=\"$color[10]\"><td align=center>\n".
                   "<b>Shared calendars</b>\n".
                   "</td></tr><tr><td align=center>\n".
                   "<b>" . _("No Shared Calendars Defined") . "</b></td></tr>\n";
         }
        print "</table><br>\n";
        $public_list = read_calendar_list($data_dir, 'public');
        if (!empty($public_list)) {
            print "<table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                  "<tr bgcolor=\"$color[10]\"><td align=center></td><td align=center>\n".
                  "<b>" . _("Public calendars") . "</b>\n".
                  "</td></tr>\n";
            $p=0;
            foreach ($public_list as $calendar) {
                print "<tr><td align=center>\n".
                      "<input type=radio name=\"selected_public_calendar\" value=\"$p\">\n".
                      "</td><td align=center>$calendar</td></tr>\n";
                $p++;
            }
        }
        else {
            print "<table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                  "<tr bgcolor=\"$color[10]\"><td align=center>\n".
                  "<b>Public calendars</b>\n".
                  "</td></tr><tr><td align=center>\n".
                  "<b>" . _("No Public Calendars Defined") . "</b></td></tr>\n";
        }
        print "</table><br>\n".
               "</td></tr></table>\n";

         print "<br><table width=\"80%\" align=center><tr><td>\n".
               "<b>" . _("Delete selected calendar") . "</b></td></tr><tr><td align=center>\n".
               "<input type=submit value=\"" . _("Delete") . "\">\n".
               "<input type=hidden name=del_action value=\"Delete\">\n".
               "<input type=hidden name=cal_action value=\"Calendars\">\n".
               "</td></tr></table></form>\n".
               "<form action=\"admin_options.php\" method=post>\n".
               "<table width=\"80%\" align=center><tr><td><b>" . _("Add a new calender") . "</b></td></tr><tr><td align=center>\n".
               _("Name") . ":&nbsp;<input type=text name=new_cal size=\"50\">\n".
               "</td></tr><tr><td align=center>\n".
               "<input type=hidden name=cal_action value=\"Calendars\">\n".
               "<input type=hidden name=add_action value=\"Add\">\n".
               "<input type=checkbox name=public value=\"yes\">\n".
               "&nbsp;&nbsp;" . _("make <b>PUBLIC</b> (read/write for all users)") . "\n".
               "</tr></td><tr><td align=center><input type=submit value=\"" . _("Add") . "\">\n".
               "</td></tr></table><br><br></form>\n";
              
     }

     elseif ($cal_action == 'Users') {
         $cal_list = read_calendar_list($data_dir, 'shared');
         print "<table align=center width=\"80%\"><tr><td>\n";
         print _("Here you can manage user access to shared calendars.\n"
             . " First create the shared calendars with the \"Calendars\" button.\n"
             . " Then you can add users to the access table below. Select that user\n"
             . " to modify his/her access to each individual shared calendar\n"
             . " or to remove them from the shared calendar access table.<br><br>\n"
             . " Note that you may use wildcards in user names: * means \"zero\n"
             . " or more characters\" and ? means \"exactly one alphanumeric\n"
             . " character\". For example, \"*@mydomain.com\" will give everyone\n"
             . " in \"mydomain.com\" access to the calendars you assign to that\n"
             . " username.\n");
         print "</td></tr></table>\n";
             
         if (isset($commit_modify) && $commit_modify == 'Submit') {
         //   $cal_list = read_calendar_list($data_dir);
            $count = count($cal_list);
            $val = '';
            for ($j=0;$j<$count;$j++) {
                $var = "cal".$j;
                $val .= $$var; 
            }
            $userdata = get_user_codes($data_dir);
            $usercount = count($userdata);
            for ($j=0;$j<$usercount;$j++) {
                if ($Name == $userdata[$j]['name']) 
                //if (preg_match("/^$Name$/", $userdata[$j]['name'])) 
                {
                   $userdata[$j]['code'] = $val;
                }
            }
            save_user_codes($data_dir, $userdata);
         }
             
         elseif (isset($add_user) && $add_user == 'Add') {
             if (!empty($user_input) && !preg_match("/^(\s){1,}$/", $user_input)) {
         //       $cal_list = read_calendar_list($data_dir);
                if (empty($cal_list)) {
                    print "<br><center><b><font color=red> " . _("You must define a shared calendar before ".
                          "you can assign user access.<br>Click on the Calendars button ".
                          "to manage shared calendars") . "</font></b></center><br>\n";
                }
                else {
                    $userdata = add_user($data_dir, $user_input, $cal_list);
                }
             }
         }
         elseif (isset($mod_user) && $mod_user == 'Modify' && isset($user_select)) {
             print "<form action\"admin_options.php\" method=post>\n".
                   "<center><table bgcolor=\"$color[10]\" width=50%>\n".
                   "<tr><td align=center><b>$user_select</b>\n".
                   "</tr></td></table></center>\n";
             $ccode = get_user_code($data_dir, $user_select);
             $code_array = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
             print "<table width=50% bgcolor=\"$color[9]\" align=center>";
             $l=0;
             foreach ($cal_list as $calendar) {
                print "<tr><td align=center>$calendar</td><td align=center> <select name=\"cal" . $l ."\">\n";
                print "<option value=\"0\"";
                if ($code_array[$l] == 0) {
                    print "SELECTED>" . _("none") . "\n";
                }
                else {
                    print ">" . _("none") . "\n";
                }
                print "<option value=\"1\"";
                if ($code_array[$l] == 1) {
                    print "SELECTED>" . _("read") . "\n";
                }
                else {
                    print ">" . _("read") . "\n";
                }
                print "<option value=\"2\"";
                if ($code_array[$l] == 2) {
                    print "SELECTED>" . _("write") . "\n";
                }
                else {
                    print ">" . _("write") . "\n";
                }
                $l++;
             }
             print "</select></td></tr>\n".
                   "</table><br>\n".
                   "<center><input type=submit value=\"" . _("Submit") . "\">\n".
                   "<center><input type=hidden name=commit_modify value=\"Submit\">\n".
                   "</center><input type=hidden name=cal_action value=\"Users\">\n".
                   "</center><input type=hidden name=\"Name\" value=\"$user_select\">\n".
                   "</form>\n";
             exit();
         }
         elseif (isset($mod_user) && $mod_user == 'Delete' && isset($user_select)) {
             remove_user($data_dir, $user_select);
         }
         if (!isset($userdata)) {
            $userdata = get_user_codes($data_dir);
         }
         print "<form action=\"admin_options.php\" method=post>\n";
         print "<br><table align=center><tr><td align=center>\n".
               "<b>Add user to shared calendar setup</b>\n".
               "</td></tr><tr><td align=center>\n".
               "<input type=text name=user_input>\n".
               "</td></tr><tr><td align=center>\n".
               "<input type=submit value=\"" . _("Add") . "\">\n".
               "<input type=hidden name=add_user value=\"Add\">\n".
               "<input type=hidden name=cal_action value=\"Users\">\n".
               "</td></tr></table>\n".
               "</form>\n".
               "<form name=\"modUserForm\" action=\"admin_options.php\" method=post>\n".
               "<br><center><table  bgcolor=\"$color[9]\"><tr><td>\n".
               "<center><b>Shared Calendar Access Table</b></td></tr><tr><td>\n".
               "<table  bgcolor=\"$color[4]\">\n".
               "<tr bgcolor=\"$color[5]\"><td></td><td width=\"100\" nowrap><b>User</b></td>\n";
         foreach ($cal_list as $calendar) {
             print "<td width=\"150\" align=center nowrap><b>$calendar</b></td>";
         }
         print "</tr>\n";
         $count = count($userdata);
         if ($count == 0) {
             print "</table><br><center>No users defined for shared calendars </center><br><table>\n";
         }
         else {
         for ($x=0;$x<$count;$x++) {
            $name = $userdata[$x]['name'];
            print "<tr bgcolor=\"$color[12]\"><td align=center><input type=radio name=user_select ".
                  "value=\"$name\"></td><td>\n".
                  "$name\n</td>";
            $code = preg_split('//', trim($userdata[$x]['code']), -1, PREG_SPLIT_NO_EMPTY);
            for ($n=0;$n<count($code);$n++) {
                switch ($code[$n]) {
                    case 0:
                        $setting = 'No';
                        break;
                    case 1:
                        $setting = 'Read';
                        break;
                    case 2:
                        $setting = 'Write';
                        break;
                    default;
                        $setting = '';
                        break;
                }
                if (!empty($setting)) {
                    print "<td align=center>$setting</td>\n";
                }
            }
         }
         }
         print "</tr></table></td></tr></table></center>\n".       
               "<input type=hidden name=cal_action value=\"Users\">\n".
               "<br><table align=center><tr><td>\n".
               "<input type=hidden name=mod_user value=\"\">\n".
               "<input type=submit value=\"" . _("Modify") . "\" onClick=\"document.modUserForm.mod_user.value='Modify'\">$indent\n".
               "</td><td><b>" . _("Modify the currently selected user's calendar access") . "</b>\n".
               "</td></tr><tr><td><input type=submit value=\"" . _("Delete") . "\" onClick=\"document.modUserForm.mod_user.value='Delete'\">$indent\n". 
               "</td><td><b>" . _("Remove the currently selected user from shared calendar access") . "</b>\n".
               "</td></tr></table><br></form>";
    }        
}
print "</body></html>\n";

?>
