<?php
/*
 *  setup.php
 *
 *  Copyright (c) 2001 Michal Szczotka <michal@tuxy.org>
 *  Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 *  init plugin into squirrelmail 
 *
 *  Modified by Jason Munro 6/23/02 for Shared Calendar access
 *
 */

function approve_cal_admin() {
    global $username;

/**********************************************************************
   Users that have access to the shared calendar administration interface
    should be entered into the following array.
***********************************************************************/

    $admins = array("user1@mydomain.com", "user2", "user3");

/**********************************************************************   
 *    Then those users can go to Options->Shared Calendar
 *    Administration.  
**********************************************************************/


    $debug = 0;

    $approved = false; 
    if (isset($_SESSION['username'])) {
        $username = $_SESSION['username'];
    }
    foreach ($admins as $admin) {
        if (isset($username)) {
            if ($debug) echo "username=$username admin=$admin<br>";
            if (strtolower($username) == strtolower($admin)) {
                $approved = true;
            }
        }
    }
    return $approved;
}

function squirrelmail_plugin_init_calendar() {
    global $squirrelmail_plugin_hooks;
    $approved = approve_cal_admin();
    $squirrelmail_plugin_hooks["menuline"]["calendar"] = "calendar";
    if ($approved == true) { 
        $squirrelmail_plugin_hooks['optpage_register_block']['calendar'] = 'cal_admin_block';
    }
}

function calendar() {
    //Add Calendar link to upper menu
    displayInternalLink("plugins/calendar/calendar_check.php",_("Calendar"),"right");
    echo "&nbsp;&nbsp\n";
}

function cal_admin_block() {
    global $optpage_blocks;
    $optpage_blocks[] = array(
        'name' => _("Shared Calendar Administration"),
        'url'  => '../plugins/calendar/admin_options.php',
        'desc' => _("Create and maintain shared calendars. Assign access by user or create publicly available calendars"),
        'js'   => false
        );
}


function calendar_version() {

    return '0.5.6';

}


?>
