#!/bin/sh

# need a valid username/password for testing
if [ ! -s test_creds ]; then 
  read -p "IMAP username: " USER
  read -p "IMAP password: " PASS
  echo $USER > test_creds
  echo $PASS >> test_creds
fi

# to run the command as the PHP files will, need to change to a different
# directory first. If SERVERSIDEFILTERHOME is changed, this must be changed
# also.
RUNFROM=../../../src
SCRIPTDIR=../plugins/serversidefilter/script

cd $RUNFROM
cat $SCRIPTDIR/test_creds | $SCRIPTDIR/filtercmd getrc filter > $SCRIPTDIR/filter; 
xx=$?
if [ $xx -eq '0' ] ; then
   echo "Pass: Filter get"
else
   echo "RESULT:" $xx
fi;
cp $SCRIPTDIR/filter $SCRIPTDIR/filter.orig
echo '# filtercmd testing ' >> $SCRIPTDIR/filter
cat $SCRIPTDIR/test_creds $SCRIPTDIR/filter | $SCRIPTDIR/filtercmd putrc filter;
xx=$?
if [ $xx -eq '0' ] ; then
   echo "Pass: Filter put"
else
   echo "RESULT:" $xx
fi;
rm $SCRIPTDIR/filter
cat $SCRIPTDIR/test_creds | $SCRIPTDIR/filtercmd getrc filter > $SCRIPTDIR/filter;
xx=$?
if [ $xx -eq '0' ] ; then
   command=`grep "filtercmd testing" $SCRIPTDIR/filter`;
   if [ -n "$command" ] ; then
      echo "Pass: You are able to correctly retrieve and save your filter file."
      echo "      Your filter file is saved in the current directory as 'filter'"
      cat $SCRIPTDIR/test_creds $SCRIPTDIR/filter.orig | $SCRIPTDIR/filtercmd putrc filter 2> /dev/null;
      mv $SCRIPTDIR/filter.orig $SCRIPTDIR/filter
   else
      echo "Fail: A problem occurred saving your filter file"
   fi;
else
   echo "RESULT:" $xx
fi;


echo If you do not need to perform additional tests, remove the file 'test_creds'
REMOVE=x
while [ $REMOVE != 'y' ] && [ $REMOVE != 'Y' ] && 
      [ $REMOVE != 'n' ] && [ $REMOVE != 'N' ] ; do
   read -p "Remove now? (Y/n): " REMOVE
done;

if [ $REMOVE = 'y' ] || [ $REMOVE = 'Y' ] ; then
   rm $SCRIPTDIR/test_creds
fi;
