<?php
	// include compatibility plugin
	//
	if (defined('SM_PATH'))
		include_once(SM_PATH . 'plugins/compatibility/functions.php');
	else if (file_exists('../plugins/compatibility/functions.php'))
		include_once('../plugins/compatibility/functions.php');
	else if (file_exists('./plugins/compatibility/functions.php'))
		include_once('./plugins/compatibility/functions.php');



	if (compatibility_check_sm_version(1, 3))
	{
		include_once (SM_PATH . 'plugins/serversidefilter/config.php');
		include_once (SM_PATH . 'plugins/serversidefilter/functions.php');
	}
	else
	{
		include_once ('../plugins/serversidefilter/config.php');
		include_once ('../plugins/serversidefilter/functions.php');
	}

	// Display dropdown menu of field options

	function fieldDropdown($str) {
		global $fields;

		print("<select name=field>\n");

		for ($i = 0; $i < count($fields); $i++) {
			print("<option value=\"$i\"");
			if ($fields[$i] == $str)
				print(" selected");
			if ($fields[$i] == "TO_")
				print(">To or Cc</option>\n");
			else
				print(">$fields[$i]</option>\n");
		}

		print("</select>\n");
	}

	// Display dropdown menu of folder options

	function folderDropdown($str) {
		global $folders;

		print("<select name=folder>\n");

		for ($i = 0; $i < count($folders); $i++) {
			print("<option value=\"$i\"");
			if ($folders[$i] == $str)
				print(" selected");
			print(">$folders[$i]</option>\n");
		}
		
		print("</select>\n");
	}

	function read_recipies($file) {
		global $recipies, $spamrule_set;
	
                $buf = '';

		if ($fd = fopen($file, 'r'))
		while (!feof($fd) && $buf != "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail")
			$buf = rtrim(fgets($fd, 4096));

		while (!feof($fd) && $buf != "##End Filter Configuration") {
			$buf = fgets($fd, 4096);
			if (substr($buf, 0, 3) == "###") {
				$tmp = explode(" '' ", substr($buf, 3));
				$new['field'] = stripslashes($tmp[0]);
                                if ($new['field'] == 'X-Spam-Flag')
				   $spamrule_set = true;
				$new['string'] = stripslashes($tmp[1]);
				$new['folder'] = stripslashes($tmp[2]);
				$new['action'] = stripslashes($tmp[3]);
                                if (isset($tmp[4])) $new['toFolder'] = stripslashes($tmp[4]);
                                else $new['toFolder'] = 'on';
				if (isset($tmp[5])) $new['toAddress'] = stripslashes($tmp[5]);
                                else $new['toAddress'] = 'off';
                                if (isset($tmp[6])) $new['add_string'] = stripslashes(trim($tmp[6]));
                                else $new['add_string'] = "";
                                array_push($recipies, $new);
			}
		}

		fclose($fd);
	}

	// Write the recipes in the recipies array
	
	function write_recipies($oldfile, $newfile) {
		global $username, $recipies, $SEPERATOR, $SPAMFILTER,
                       $VIRTUAL_DOMAINS, $LOCAL_MAILDIR, $FILE_BACKEND, $CREATE_DOT_QMAIL;

                if (isset($VIRTUAL_DOMAINS) && $VIRTUAL_DOMAINS==1)
                   list($user, $domain) = split($SEPERATOR,$username);
                else
                   $user = $username;
                $MAILDIR = preg_replace("/\[USERNAME\]/","$user",$LOCAL_MAILDIR);
		
		$of = fopen($oldfile, 'r');
		$nf = fopen($newfile, 'w');

		$buf = rtrim(fgets($of, 4096));
		while (!feof($of) && $buf != "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail") {
			fputs($nf, "$buf\n");
			$buf = rtrim(fgets($of, 4096));
		}


		fputs($nf, "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail\n");
		fputs($nf, "MAILDIR=$MAILDIR # Default mail directory\n");

                if (isset($SPAMFILTER) && $SPAMFILTER != '')
                   write_spam_filter($nf);

		for ($i = 0; $i < count($recipies); $i++) {
			$field = $recipies[$i]['field'];
			$string = $recipies[$i]['string'];
			$folder = $recipies[$i]['folder'];
                        $action = $recipies[$i]['action'];
                        $toFolder = $recipies[$i]['toFolder'];
                        $toAddress = $recipies[$i]['toAddress'];
                        $add_string = $recipies[$i]['add_string'];

			$ssfield = addslashes($recipies[$i]['field']);
			$ssstring = addslashes($recipies[$i]['string']);
			$ssfolder = addslashes($recipies[$i]['folder']);
			$ssaction = addslashes($recipies[$i]['action']);
                        $sstoFolder = addslashes($recipies[$i]['toFolder']);
                        $sstoAddress = addslashes($recipies[$i]['toAddress']);
                        $ssadd_string = addslashes($recipies[$i]['add_string']);
			
			fputs($nf, "\n###${ssfield} '' ${ssstring} '' ${ssfolder} '' ${ssaction} '' ${sstoFolder} '' ${sstoAddress} '' ${ssadd_string} \n");
                        write_filter_recipie($nf, $action, $field, $string, $folder, 
                                             $toFolder, $toAddress, $add_string);
		}

                write_default_recipie($nf);

		fputs($nf, "\n##End Filter Configuration\n");


		while (!feof($of) && $buf != "##End Filter Configuration")
			$buf = rtrim(fgets($of,4096));

		while (!feof($of)) {
			$buf = fgets($of,4096);
			fputs($nf, "$buf");
		}

		fclose($of);
		fclose($nf);
                
                if (isset($CREATE_DOT_QMAIL) && $CREATE_DOT_QMAIL == 1 && 
                    $FILE_BACKEND != 'local')
                    write_dot_qmail();
	}

	function create_filter() {
		global $username, $SEPERATOR, $SPAMFILTER, $FILTERFILE,
                       $VIRTUAL_DOMAINS, $LOCAL_MAILDIR, $FILE_BACKEND, $CREATE_DOT_QMAIL;

                if (isset($VIRTUAL_DOMAINS) && $VIRTUAL_DOMAINS==1)
                   list($user, $domain) = split($SEPERATOR,$username);
                else
                   $user = $username;
                $MAILDIR = preg_replace("/\[USERNAME\]/","$user",$LOCAL_MAILDIR);
                $file = "/tmp/$FILTERFILE.$username";
		$nf = fopen($file, "w");

		fputs($nf, "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail\n");
		fputs($nf, "MAILDIR=$MAILDIR # Default mail directory\n");

                if (isset($SPAMFILTER) && $SPAMFILTER != '')
                   write_spam_filter($nf);

                write_default_recipie($nf);
		fputs($nf, "\n##End Filter Configuration\n");
		fclose($nf);
		filter_put($file);
                unlink($file);
                if (isset($CREATE_DOT_QMAIL) && $CREATE_DOT_QMAIL == 1 && 
                    $FILE_BACKEND != 'local')
                    write_dot_qmail();
	}

	// Print the recipies

	function print_recipies() {
		global $recipies, $color;

                $bgcolor = $color[0];
		for ($i = 0; $i < count($recipies); $i++) {
			$str = $recipies[$i]['string'];
                        $toFolder = '';
                        $toAddress = '';
                        if ($recipies[$i]['toFolder'] == 'on') $toFolder = 'checked';
                        if ($recipies[$i]['toAddress'] == 'on') $toAddress = 'checked';
                        $add = $recipies[$i]['add_string'];

			print("<form method=post action=\"options.php\"><input type=hidden name=rule value=\"$i\">\n");
			print("<tr><td align=right valign=top>");
			if ($recipies[$i]['field'] == 'X-Spam-Flag') {
                           print('<input type=hidden name=field value="X-Spam-Flag">');
                           print('<input type=hidden name=string value="Yes">');
                           print(_("If message is marked as") . ' <b>' . _("SPAM") . '</b> ' . _("then") . " ");
                        } else {
                           print(_("If") . " ");
  			   fieldDropdown($recipies[$i]['field']);
			   print(_("contains") . " <input type=text name=string size=10 value=\"$str\"> " . _("then") . " ");
                        }
			print("<select name=action>\n");

			if ($recipies[$i]['action'] == "m")
				print("<option value=m selected>" . _("move") . "</option>\n<option value=c>" . _("copy") . "</option>\n");
			else
				print("<option value=m>" . _("move") . "</option>\n<option value=c selected>" . _("copy"). "</option>\n");

			print("</select>\n " . _("to") . "</td>");
                        print("<td><table border=0 cellspacing=0 cellpadding=0>");
                        print("<tr>");
                        print("<td><input type=checkbox name=toFolder $toFolder>" . _("Folder") . "&nbsp;&nbsp;</td>");
                        print("<td>"); folderDropdown($recipies[$i]['folder']); print("</td>");
                        print("</tr><tr>");
                        print("<td><input type=checkbox name=toAddress $toAddress>" . _("Email") . "&nbsp;&nbsp;</td>");
                        print("<td><input type=text name=add_string value=\"$add\"></td>");
                        print("</td></table>");
			print("\n</td>\n");
			print("<td valign=top><input type=image src=\"images/save.gif\" border=0 name=modify alt=\"save\"></td>\n");
			print("<td valign=top><input type=image src=\"images/delete.gif\" border=0 name=delete alt=\"delete\"></td>\n");

			// Let's not display the move arrows if they're not needed
			if (count($recipies) == 1) {
				print("<td>&nbsp;</td>\n<td>&nbsp;</td>\n");
			} else if ($i == 0) {
				print("<td colspan=2 align=center valign=top><input type=image src=\"images/down.gif\" border=0 name=down alt=\"move down\"></td>\n");
			} else if ($i == count($recipies)-1) {
				print("<td colspan=2 align=center valign=top><input type=image src=\"images/up.gif\" border=0 name=up alt=\"move up\"></td>\n");
			} else {
				print("<td valign=top><input type=image src=\"images/up.gif\" border=0 name=up alt=\"move up\"></td>\n");
				print("<td valign=top><input type=image src=\"images/down.gif\" border=0 name=down alt=\"move down\"></td>\n");
			}

			print("</tr></form>\n");
		}
                return $i;
	}
?>
