<?php

/**
  * SquirrelMail Server Settings Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage server_settings
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_server_settings()
{

   global $squirrelmail_plugin_hooks;


   // show options block on SM main options page
   //
   $squirrelmail_plugin_hooks['optpage_register_block']['server_settings']
      = 'server_settings_option_blocks';


   // show links in menu on top of content pane (1.4.x)
   // 
   $squirrelmail_plugin_hooks['menuline']['server_settings']
      = 'server_settings_menuline';


   // show links in menu on top of content pane (1.5.2+)
   // 
   $squirrelmail_plugin_hooks['template_construct_page_header.tpl']['server_settings']
      = 'server_settings_menuline';


   // set up custom options page
   //
   $squirrelmail_plugin_hooks['optpage_set_loadinfo']['server_settings']
      = 'server_settings_setup_options_page';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['server_settings']
      = 'server_settings_check_configuration';

}



/**
  * Force the getpot script to pick up these translations
  * (which are in the config file in non-translated form)
  *
  * @ignore
  *
  */
function ss_no_op()
{
   $ignore = _("Spam Controls");
   $ignore = _("Manage the settings that control anti-spam efforts on the server.");
   $ignore = _("Manage the settings that control how your email is protected from spam.");
   $ignore = _("Whitelist and Blacklist");
   $ignore = _("Whitelist/Blacklist");
   $ignore = _("Manage the senders whom you have either whitelisted or blacklisted.");
   $ignore = _("Whitelisted Senders");
   $ignore = _("Blacklisted Senders");
   $ignore = _("Whitelist");
   $ignore = _("Manage your sender whitelist.");
   $ignore = _("Blacklist");
   $ignore = _("Manage your sender blacklist.");
   $ignore = _("Spam Detection");
   $ignore = _("Required Score");
   $ignore = _("The required score is the level of confidence that a message is spam at which you want the message to actually be tagged as such.");
   $ignore = _("1 - Extremely Strict");
   $ignore = _("3 - Strict");
   $ignore = _("5 - Average");
   $ignore = _("8 - Loose");
   $ignore = _("10 - Extremely Loose");
   $ignore = _("Real-time Blacklist Scoring");
   $ignore = _("The real-time blacklist score is the number of \"spam points\" that a message is given when it contains any links that are found in real-time blacklist testing.");
   $ignore = _("Acceptable Languages");
   $ignore = _("When a message is received in one of the selected languages, it is considered more likely not to be spam; messages in all other languages are usually spam");
   $ignore = _("All languages are acceptable");
   $ignore = _("Western languages, especially English");
   $ignore = _("Japanese");
   $ignore = _("Korean");
   $ignore = _("Cyrillic languages");
   $ignore = _("Thai");
   $ignore = _("Chinese");
   $ignore = _("Spam Report Subject");
   $ignore = _("When a message is tagged as spam, how should its subject be changed?  You can set this as blank so the subject is not changed or set it to something such as \"[SPAM]\".");
   $ignore = _("Spam Report Format");
   $ignore = _("When a message is tagged as spam, should it be preserved as-is in an attachment to the spam report, attached as only a plain text email, or should it be left unaltered?");
   $ignore = _("Leave unaltered");
   $ignore = _("Attach to spam report");
   $ignore = _("Attach as a text message");
   $ignore = _("Mail Forwarding");
   $ignore = _("Set up other email addresses to which your incoming messages will be forwarded.");
   $ignore = _("Forward Incoming Messages To These Addresses");
   $ignore = _("(separate multiple addresses with commas)");
   $ignore = _("(separate multiple addresses with commas;<br />enter your own address herein to keep copies of messages in this account)"); // don't use in 1.5.2+!
   $ignore = _("(separate multiple addresses with commas; enter your own address herein to keep copies of messages in this account)");
   $ignore = _("Autoresponder");
   $ignore = _("Set up an auto-reply message for you incoming email.  This can be useful when you are away on vacation.");
   $ignore = _("Enable Auto-Reply To Sender");
   $ignore = _("Subject");
   $ignore = _("Message");
}



/**
  * Returns info about this plugin
  *
  */
function server_settings_info()
{

   return array(
                 'english_name' => 'Server Settings',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 1,
                 'summary' => 'Provides a front end to the configuration options for any system running outside of SquirrelMail.',
                 'details' => 'This plugin provides a front end to the configuration options for any system running outside of SquirrelMail.  This can include anti-spam software such as SpamAssassin, or even ANY unrelated software that users should be able to configure using the SquirrelMail interface.  It is tightly coupled with the Server Settings Backend plugin so that it can offer user control over settings that are stored in a variety of backends.  Settings stored inside the SquirrelMail user preference mechanism are also supported, however, another plugin will have to make use of such settings.  This plugin also has a small API that provides other plugins (for example, the Spam Buttons plugin) the ability to access and use the settings that are configured herein.',
                 'requires_source_patch' => 0,
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'required_plugins' => array(),
                    ),
                    '1.5.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                    '1.4.10' => array(
                       'required_plugins' => array(),
                    ),
                    '1.4.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function server_settings_version()
{
   $info = server_settings_info();
   return $info['version'];
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function server_settings_check_configuration()
{
   include_once(SM_PATH . 'plugins/server_settings/configtest.php');
   return server_settings_check_configuration_do();
}



/**
  * Show options block on SM main options page
  *
  */
function server_settings_option_blocks()
{
   include_once(SM_PATH . 'plugins/server_settings/init.php');
   server_settings_option_blocks_do();
}



/**
  * Show links in menu on top of content pane
  *
  */
function server_settings_menuline()
{
   include_once(SM_PATH . 'plugins/server_settings/init.php');
   return server_settings_menuline_do();
}



/**
  * Set up custom options page
  *
  */
function server_settings_setup_options_page()
{
   include_once(SM_PATH . 'plugins/server_settings/options.php');
   server_settings_setup_options_page_do();
}



