<?php

/**
  * SquirrelMail Server Settings Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage server_settings
  *
  */


/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function server_settings_check_configuration_do()
{

   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // if running 1.4.10+ (but not 1.5.0 or 1.5.1)
      // this test does not need to be performed
      //
      if (check_sm_version(1, 4, 10) && !check_sm_version(1, 5, 0))
      { /* no-op */ }


      // otherwise, try to find Compatibility, and 
      // then that it is v2.0.7+
      //
      else
      {
         if (function_exists('check_plugin_version')
          && check_plugin_version('compatibility', 2, 0, 7, TRUE))
         { /* no-op */ }


         // something went wrong
         //
         else
         {
            do_err('Server Settings plugin requires the Compatibility plugin version 2.0.7+', FALSE);
            return TRUE;
         }
      }

   }


   // make sure plugin is correctly configured
   //
   global $server_settings_configtest;
   $server_settings_configtest = TRUE;
   include_once(SM_PATH . 'plugins/server_settings/init.php');
   if (!server_settings_init())
   {
      do_err('Server Settings plugin is not configured correctly', FALSE);
      return TRUE;
   }


//TODO: what else can we test?  whatever we can do to help users get the syntax of the config file correct, that would be helpful

   return FALSE;

}



