<?php

/**
  * SquirrelMail Server Settings Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage server_settings
  *
  */

global $server_settings_option_pages;



// This is where the options pages that let users configure
// various parts of your backend systems are defined.
//
// You may define as many options pages as you'd like.  Each
// one is defined in an array that consists of the following
// elements (as the corresponding array keys - see the examples
// below):
//
//    TITLE          This text will be shown both on the SquirrelMail
//                   Options page (where all other options pages are
//                   listed) as well as at the top of the actual page
//                   you are creating.
//
//    DESCRIPTION    This text will be shown on the SquirrelMail
//                   Options page (where all other options pages are
//                   listed), and should give a short (one or two
//                   sentence) explanation of the settings that are
//                   controlled on the page you are creating.
//
//    NO_OPTION_PAGE If present (filled with any non-empty value),
//                   this indicates that no link on the SquirrelMail
//                   Options page for this group of settings.  This
//                   is most commonly used in conjunction with the
//                   "MENU_LINK" element.  Please ensure that this
//                   element *does not* exist when an option link
//                   is to be shown for this group of settings.
//
//    MENU_LINK      When present, this is the text of a link that
//                   will be added to the menu that is shown across
//                   the top of all SquirrelMail content pages
//                   (the menu that typically starts with "Compose",
//                   "Addresses", "Folders", etc.).  The link will
//                   take the user to the options page for this
//                   settings group.
//
//    RETURN_TO_SELF When present (filled with any non-empty value),
//                   the option page will simply reload when the user
//                   clicks the submit button (instead of returning
//                   to the SquirrelMail main Options page).
//
//    WIDGETS        This is an array of the controls/settings that
//                   will be contained in the options page.  This
//                   array should contain all the typical elements
//                   that help define option widgets per the normal
//                   SquirrelMail options API explained here (NAME,
//                   CAPTION, TYPE, etc.):
//
//                      http://squirrelmail.org/docs/devel/devel-4.html#ss4.7
//
//                   Additionally, you may specify three more special
//                   elements in the widget's configuration:
//
//                      SECTION        This defines the subsection on
//                                     the options page under which this
//                                     widget should be placed.  It is
//                                     optional, and if not given, it will
//                                     be grouped in a generic unlabelled
//                                     section.
//
//                      SETUP_LOCATION This indicates where the initial
//                                     value for the widget should be
//                                     placed in the widget information
//                                     array.  This is NOT a required
//                                     element, and if not given, the
//                                     value will be placed in
//                                     "initial_value".  Sometimes this
//                                     needs to be changed, such as for
//                                     options of type SM_OPT_EDIT_LIST,
//                                     which need to be set as "posvals".
//
//                      MULTIPLE_VALUE_UPDATES_SEPERATELY
//                                     If present (filled with any non-empty
//                                     value), this indicates that when saving
//                                     widgets consisting of multiple values,
//                                     adds and removals should be done
//                                     seperately (as opposed to reconstructing
//                                     the whole list and re-saving it all at
//                                     once).  This is useful for backends
//                                     such as SQL where unchanged items in the
//                                     list should be left as is.
//
//                   If the setting should be stored by SquirrelMail
//                   in the normal user preferences, then this is all
//                   that is needed, however, if the setting corresponds
//                   to a configuration value stored elsewhere on the
//                   server, you must also define elements here that
//                   indicate how to retrieve and set the value:
//
//                      STORAGE  This is a subarray of information explaining
//                               how to look up the setting's value and put
//                               a new value in its place.  The elements herein
//                               and their possible values are defined in the
//                               Server Settings plugin (see the Configuration
//                               section in its README file).
//
// Note that several of the values herein will be passed through the
// SquirrelMail translation engine before being displayed.  If you use
// one of the suggested strings that is already in the Server Settings
// translation file, it will be translated automatically for you (assuming
// translation availability).  If you use custom wording in any of these,
// it will not be translated unless you add your strings to the Server
// Settings translations.  These items will be translated:
//
//    TITLE
//    DESCRIPTION
//    MENU_LINK
//    WIDGET[SECTION]
//    WIDGET[CAPTION]
//    WIDGET[TRAILING_TEXT]
//    WIDGET[COMMENT]
//    WIDGET[POSVALS]
//    WIDGET[YES_TEXT]
//    WIDGET[NO_TEXT]
//TODO: possibly other attributes need to be added - see line 288 in options.php
//
// Here are the strings that are already included in the Server Settings
// translation file (note that this is subject to expand in future plugin
// versions, so please send requests for new strings):
//
//    Whitelist and Blacklist
//    Whitelist/Blacklist
//    Manage the senders whom you have either whitelisted or blacklisted.
//    Whitelisted Senders
//    Blacklisted Senders
//    Whitelist
//    Manage your sender whitelist.
//    Blacklist
//    Manage your sender blacklist.
//    Spam Controls
//    Manage the settings that control anti-spam efforts on the server.
//    Manage the settings that control how your email is protected from spam.
//    Spam Detection
//    Required Score
//    The required score is the level of confidence that a message is spam at which you want the message to actually be tagged as such.
//    1 - Extremely strict
//    3 - Strict
//    5 - Average
//    8 - Loose
//    10 - Extremely loose
//    Real-time Blacklist Scoring
//    The real-time blacklist score is the number of "spam points" that a message is given when it contains any links that are found in real-time blacklist testing.
//    Acceptable Languages
//    When a message is received in one of the selected languages, it is considered more likely not to be spam; messages in all other languages are usually spam
//    All languages are acceptable
//    Western languages, especially English
//    Japanese
//    Korean
//    Cyrillic languages
//    Thai
//    Chinese
//    Spam Report Subject
//    When a message is tagged as spam, how should its subject be changed?  You can set this as blank so the subject is not changed or set it to something such as \"[SPAM]\".
//    Spam Report Format
//    When a message is tagged as spam, should it be preserved as-is in an attachment to the spam report, attached as only a plain text email, or should it be left unaltered?
//    Leave unaltered
//    Attach to spam report
//    Attach as a text message
//    Mail Forwarding
//    Set up other email addresses to which your incoming messages will be forwarded.
//    Forward Incoming Messages To These Addresses
//    (separate multiple addresses with commas)
//    (separate multiple addresses with commas;<br />enter your own address herein to keep copies of messages in this account)   (don't use in 1.5.2+!)
//    (separate multiple addresses with commas; enter your own address herein to keep copies of messages in this account)
//    Autoresponder
//    Set up an auto-reply message for you incoming email.  This can be useful when you are away on vacation.
//    Enable Auto-Reply To Sender
//    Subject
//    Message
//
$server_settings_option_pages = array(

   // =========================================================================
   array(

      // This is an example page that contains a series of option widgets
      // whose data is stored in the normal SquirrelMail user preferences
      // system (because they don't specify a "STORAGE" entry in their
      // configuration array).  These can be managed and presented by this
      // plugin, but to make use of these settings, another plugin would
      // need to be installed and do something with the data.
      //
      'TITLE'       => 'Miscellaneous Settings',
      'DESCRIPTION' => 'Manage some settings on the server.',
      'WIDGETS' => array(

         // ------------------------------------------------
         array(
            'NAME'    => 'test_setting_1',
            'SECTION' => 'Lists',
            'CAPTION' => 'Single Select List',
            'TYPE'    => SMOPT_TYPE_STRLIST,
            'REFRESH' => SMOPT_REFRESH_NONE,
            'POSVALS' => array(0 => 'Not used', 1, 2, 3),
         ),

         // ------------------------------------------------
         array(
            'NAME'    => 'separator_1',
            'SECTION' => 'Lists',
            'CAPTION' => '',
            'COMMENT' => '',
            'TYPE'    => SMOPT_TYPE_COMMENT,
         ),

         // ------------------------------------------------
         array(
            'NAME'    => 'separator_2',
            'SECTION' => 'Lists',
            'CAPTION' => '',
            'COMMENT' => '',
            'TYPE'    => SMOPT_TYPE_COMMENT,
         ),

         // ------------------------------------------------
         array(
            'NAME'    => 'test_setting_2',
            'SECTION' => 'Lists',
            'CAPTION' => 'Multiple Select List',
            'TYPE'    => SMOPT_TYPE_STRLIST_MULTI,
            'REFRESH' => SMOPT_REFRESH_NONE,
            'POSVALS' => array(0 => 'Not used', 1, 2, 3),
         ),

         // ------------------------------------------------
         array(
            'NAME'           => 'test_setting_3',
            'SECTION'        => 'Lists',
            'CAPTION'        => 'Edit List',
            'TYPE'           => SMOPT_TYPE_EDIT_LIST,
            'SIZE'           => SMOPT_SIZE_TINY,
            'REFRESH'        => SMOPT_REFRESH_NONE,
            // 'LAYOUT_TYPE'    => SMOPT_EDIT_LIST_LAYOUT_LIST,
            'LAYOUT_TYPE'    => SMOPT_EDIT_LIST_LAYOUT_SELECT,
            'SETUP_LOCATION' => 'posvals',
         ),

         // ------------------------------------------------
         array(
            'NAME'    => 'test_setting_4',
            'SECTION' => 'Textual Input',
            'CAPTION' => 'One Liner',
            'TYPE'    => SMOPT_TYPE_TEXT,
            'REFRESH' => SMOPT_REFRESH_NONE,
         ),

         // ------------------------------------------------
         array(
            'NAME'    => 'test_setting_5',
            'SECTION' => 'Textual Input',
            'CAPTION' => 'Multiple Lines',
            'TYPE'    => SMOPT_TYPE_TEXTAREA,
            'REFRESH' => SMOPT_REFRESH_NONE,
         ),

         // ------------------------------------------------
         array(
            'NAME'    => 'test_setting_6',
            'SECTION' => 'Boolean Settings',
            'CAPTION' => 'Radio Buttons',
            'TYPE'    => SMOPT_TYPE_BOOLEAN_RADIO,
            'REFRESH' => SMOPT_REFRESH_NONE,
         ),

         // ------------------------------------------------
         array(
            'NAME'    => 'test_setting_7',
            'SECTION' => 'Boolean Settings',
            'CAPTION' => 'Checkbox',
            'TRAILING_TEXT' => 'Click Me!',
            'TYPE'    => SMOPT_TYPE_BOOLEAN_CHECKBOX,
            'REFRESH' => SMOPT_REFRESH_NONE,
         ),

         // ------------------------------------------------
         array(
            'NAME'           => 'test_setting_8_comment',
            'SECTION'        => 'Miscellaneous',
            'CAPTION'        => 'Explanation',
            'COMMENT'        => 'A detailed description of a setting can go here.',
            'TYPE'           => SMOPT_TYPE_COMMENT,

            // Note that if you retrieve a value from a backend lookup
            // for display in a comment, you need to do the following:
            //
            // 'SETUP_LOCATION' => 'comment',
         ),

         // ------------------------------------------------
         array(
            'NAME'          => 'test_setting_8',
            'SECTION'       => 'Miscellaneous',
            'CAPTION'       => 'Multiple Radio Buttons',
            //'POSVALS' => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
            //'POSVALS' => array('red', 'green', 'orange', 'white', 'black'),
            'POSVALS' => array(0 => 'red', 1 => 'blue',
                               2 => 'green', 3 => 'white', 4 => 'black'),
            'SIZE'          => SMOPT_SIZE_TINY,
            'TYPE'          => SMOPT_TYPE_STRLIST_RADIO,
            'REFRESH'       => SMOPT_REFRESH_NONE,
         ),

      ),
   ),

);



