<?php

/**
  * SquirrelMail Select Range Plugin
  * Copyright (c) 2003-2005 Kurt Yoder <kylist@shcorp.com>
  * Copyright (c) 2006 MrC <lists-squirrelmail@cappella.us>
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage select_range
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_select_range()
{

   global $squirrelmail_plugin_hooks;


   // show options on display preferences page
   //
   $squirrelmail_plugin_hooks['optpage_loadhook_display']['select_range']
      = 'select_range_options';


   // insert JavaScript tag in <head> of needed pages
   //
   $squirrelmail_plugin_hooks['generic_header']['select_range']
      = 'select_range_insert_script_tag';


   // display "Select Range" link at top of message list screen (1.4.x)
   //
   $squirrelmail_plugin_hooks['mailbox_index_before']['select_range']
      = 'select_range_print_link';


   // display "Select Range" link at bottom of message list screen (1.4.x)
   //
   $squirrelmail_plugin_hooks['right_main_bottom']['select_range']
      = 'select_range_print_link';


   // display "Select Range" link at top/bottom of message list screen
   // (patched 1.4.x)
   //
   $squirrelmail_plugin_hooks['mailbox_selectall_after']['select_range']
      = 'select_range_print_link';


   // display "Select Range" link at top/bottom of message list screen
   // as well as implement shift-click functionality (1.5.x)
   //
   $squirrelmail_plugin_hooks['template_construct_message_list.tpl']['select_range']
      = 'select_range_print_link';


   // add shift-click ability to checkboxes
   // (1.4.x; hook added by custom patch)
   // 
   $squirrelmail_plugin_hooks['checkbox_extra_params']['select_range']
      = 'select_range_checkbox_params';


   // display "Select Range" and "Toggle All" links on address book page
   // (1.4.x)
   // 
   $squirrelmail_plugin_hooks['address_book_header']['select_range']
      = 'select_range_abook';


   // display "Select Range" link on address book page (1.5.x)
   // 
   $squirrelmail_plugin_hooks['template_construct_addressbook_list.tpl']['select_range']
      = 'select_range_print_link';

}



/**
  * Returns info about this plugin
  *
  */
function select_range_info()
{

   return array(
                 'english_name' => 'Select Range',
                 'authors' => array(
                    'Kurt Yoder' => array(
                       'email' => 'kylist@shcorp.com',
                    ),
                    'MrC' => array(
                       'email' => 'lists-squirrelmail@cappella.us',
                    ),
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '3.7.1',
                 'required_sm_version' => '1.4.4',
                 'requires_configuration' => 0,
                 'summary' => 'Allows users to quickly select many items from a list, such as the message list or the address book list.',
                 'details' => 'This plugin allows users to quickly select many items from a list, such as the message list or the address book list.  It can be useful, for example, when the user needs to delete, move, or modify the status of several messages at once, such as when handling high-volume mailing lists.  JavaScript is required in the client browser in order for this plugin to function.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'required_plugins' => array(),
                       'requires_source_patch' => 0,
                    ),
                    '1.4.4' => array(
                       'requires_source_patch' => 2,
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function select_range_version()
{
   $info = select_range_info();
   return $info['version'];
}



/**
  * Display "Select Range" and "Toggle All" links on address book page
  *
  */
function select_range_abook()
{
   include_once(SM_PATH . 'plugins/select_range/functions.php' );
   return select_range_do_abook();
}



/**
  * Display user configuration options on display preferences page
  *
  */
function select_range_options()
{
   include_once(SM_PATH . 'plugins/select_range/functions.php' );
   select_range_do_options();
}



/**
  * Insert JavaScript tag in <head> of needed pages
  *
  */
function select_range_insert_script_tag($args)
{
   include_once(SM_PATH . 'plugins/select_range/functions.php' );
   select_range_insert_script_tag_do($args);
}



/**
  * Display "Select Range" link on various pages
  *
  */
function select_range_print_link($args)
{
   include_once(SM_PATH . 'plugins/select_range/functions.php' );
   return select_range_generate_link($args);
}



/**
  * Add shift-click ability to checkboxes
  *
  */
function select_range_checkbox_params($args)
{
   include_once(SM_PATH . 'plugins/select_range/functions.php' );
   return select_range_do_checkbox_params($args);
}



