<?php

/**
  * SquirrelMail Select Range Plugin
  * Copyright (c) 2003-2005 Kurt Yoder <kylist@shcorp.com>
  * Copyright (c) 2006 MrC <lists-squirrelmail@cappella.us>
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage select_range
  *
  */

global $select_range_display_threshold,
       $select_range_display_threshold_allow_override,
       $select_range_display_errors,
       $select_range_display_errors_allow_override,
       $select_range_abook_toggle_all,
       $select_range_abook_toggle_all_allow_override,
       $select_range_abook_select_range,
       $select_range_abook_select_range_allow_override,
       $select_range_fill_type,
       $select_range_fill_type_allow_override;



// This controls the minimum number of elements in any list
// needed before the "Select Range" link will appear.  Set
// to 0 (zero) if it should ALWAYS be shown or -1 if it
// should NEVER be shown.
// 
$select_range_display_threshold = 4;



// Should the user be able to override the value chosen
// for $select_range_display_threshold above?  Set to 1 to
// allow users to control when the "Select Range" link
// appears or 0 (zero) to disallow them such control.
//
$select_range_display_threshold_allow_override = 1;



// When multiple checkbox gaps exist in the list
// when the "Select Range" link is clicked, those
// gaps can all be filled at once or one at a time.
// If this is set to "fill_all", they will all be
// filled in at once.  If set to "bottom_up", only
// the bottom-most gap is filled (continue to click
// the "Select Range" link to fill the rest in if
// needed).  If set to "top_down", only the
// upper-most gap is filled.
// 
// $select_range_fill_type = 'bottom_up';
// $select_range_fill_type = 'top_down';
//
$select_range_fill_type = 'fill_all';



// Should the user be able to override the value chosen
// for $select_range_fill_type above?  Set to 1 to
// allow users to control how multiple gaps are filled
// or 0 (zero) to disallow them such control.
//
$select_range_fill_type_allow_override = 1;



// When the "Select Range" link is clicked upon but no
// action can be taken (only one checkbox has been
// checked so far or there are no empty checkboxes
// between the ones that have, etc.), an alert will pop
// up to indicate a problem to the user.  Set this to
// 0 (zero) to disable such notifications, or 1 to
// enable them.
//
$select_range_display_errors = 1;



// Should the user be able to override the value chosen
// for $select_range_display_errors above?  Set to 1 to
// allow users to control notification popups or 0 (zero)
// to disallow them such control.
//
$select_range_display_errors_allow_override = 1;



// A "Toggle All" link can be shown on the address book
// listing page if this is set to 1.  It will not be
// displayed if this is set to 0 (zero).
//
// This has no effect as of SquirrelMail 1.5.2 and up,
// where there is already a Toggle All checkbox.
//
$select_range_abook_toggle_all = 1;



// Should the user be able to override the value chosen
// for $select_range_abook_toggle_all above?  Set to 1
// to allow users to control the "Toggle All" link
// on the address book page or 0 (zero) to disallow
// them such control.
//
$select_range_abook_toggle_all_allow_override = 1;



// A "Select Range" link can be shown on the address book
// listing page if this is set to 1.  It will not be
// displayed if this is set to 0 (zero).
//
$select_range_abook_select_range = 1;



// Should the user be able to override the value chosen
// for $select_range_abook_select_range above?  Set to 1
// to allow users to control the "Select Range" link
// on the address book page or 0 (zero) to disallow
// them such control.
//
$select_range_abook_select_range_allow_override = 1;



