<?php

/**
  * SquirrelMail Select Range Plugin
  * Copyright (c) 2003-2005 Kurt Yoder <kylist@shcorp.com>
  * Copyright (c) 2006 MrC <lists-squirrelmail@cappella.us>
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage select_range
  *
  */



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function select_range_init()
{

   if (!@include_once (SM_PATH . 'plugins/select_range/config.php'))
      if (!@include_once (SM_PATH . 'plugins/select_range/config.sample.php'))
         return FALSE;

   return TRUE;

}



/**
  * Display user configuration options on display preferences page
  *
  */
function select_range_do_options()
{

   global $select_range_display_threshold, $data_dir, $username,
          $optpage_data, $select_range_display_errors,
          $select_range_display_threshold_allow_override,
          $select_range_display_errors_allow_override,
          $select_range_abook_toggle_all,
          $select_range_abook_toggle_all_allow_override,
          $select_range_abook_select_range,
          $select_range_abook_select_range_allow_override,
          $select_range_fill_type, $select_range_fill_type_allow_override,
          $javascript_on;
   
   if (!$javascript_on) return;

   select_range_init();

   sq_change_text_domain('select_range');

   $my_optpage_values = array();

   
   if ($select_range_display_threshold_allow_override)
   {
      $select_range_display_threshold = getPref($data_dir, $username,
                                                'select_range_threshold',
                                                $select_range_display_threshold);

      $my_optpage_values[] = array(
         'name'          => 'select_range_threshold',
         'caption'       => _("Number of list items before showing \"Select Range\" link"),
         'type'          => SMOPT_TYPE_STRLIST,
         'initial_value' => $select_range_display_threshold,
         'posvals'       => array(-1 => _("Never show"),
                                   0 => _("Always show"),
                                   4 => 4, 5 => 5, 6 => 6, 7 => 7, 8 => 8, 9 => 9,
                                  10 => 10, 12 => 12, 14 => 14, 16 => 16, 18 => 18,
                                  20 => 20, 22 => 22, 24 => 24, 26 => 26, 28 => 28,
                                  30 => 30, 35 => 35, 40 => 40, 45 => 45, 50 => 50,
                                  55 => 55, 60 => 60, 65 => 65, 70 => 70, 75 => 75,
                                  80 => 80, 85 => 85, 90 => 90, 95 => 95, 100 => 100,
                                  125 => 125, 150 => 150, 175 => 175, 200 => 200,
                                  225 => 225, 250 => 250, 275 => 275, 300 => 300,
                                  325 => 325, 350 => 350, 375 => 375, 400 => 400,
                                  425 => 425, 450 => 450, 475 => 475, 500 => 500,
                            ),
         'refresh'       => SMOPT_REFRESH_NONE,
      );
   }

   
   if ($select_range_display_errors_allow_override)
   {
      $select_range_display_errors = getPref($data_dir, $username,
                                             'select_range_display_errors',
                                             $select_range_display_errors);

      $my_optpage_values[] = array(
         'name'          => 'select_range_display_errors',
         'caption'       => _("Show errors in pop-up window"),
         'type'          => SMOPT_TYPE_BOOLEAN,
         'initial_value' => $select_range_display_errors,
         'refresh'       => SMOPT_REFRESH_NONE,
      );
   }

   
   if (!check_sm_version(1, 5, 2) && $select_range_abook_toggle_all_allow_override)
   {
      $select_range_abook_toggle_all = getPref($data_dir, $username,
                                               'select_range_abook_toggle_all',
                                               $select_range_abook_toggle_all);

      $my_optpage_values[] = array(
         'name'          => 'select_range_abook_toggle_all',
         'caption'       => _("Show \"Toggle All\" link on address book page"),
         'type'          => SMOPT_TYPE_BOOLEAN,
         'initial_value' => $select_range_abook_toggle_all,
         'refresh'       => SMOPT_REFRESH_NONE,
      );
   }


   if ($select_range_abook_select_range_allow_override)
   {
      $select_range_abook_select_range = getPref($data_dir, $username,
                                                 'select_range_abook_select_range',
                                                 $select_range_abook_select_range);

      $my_optpage_values[] = array(
         'name'          => 'select_range_abook_select_range',
         'caption'       => _("Show \"Select Range\" link on address book page"),
         'type'          => SMOPT_TYPE_BOOLEAN,
         'initial_value' => $select_range_abook_select_range,
         'refresh'       => SMOPT_REFRESH_NONE,
      );
   }


   if ($select_range_fill_type_allow_override)
   {
      $select_range_fill_type = getPref($data_dir, $username,
                                        'select_range_multiple_gaps',
                                        $select_range_fill_type);

      $my_optpage_values[] = array(
         'name'          => 'select_range_multiple_gaps',
         'caption'       => _("When filling multiple gaps"),
         'type'          => SMOPT_TYPE_STRLIST,
         'initial_value' => $select_range_fill_type,
         'posvals'       => array(
                               'fill_all' => _("Fill all gaps"),
                               'bottom_up' => _("Fill gaps from bottom up"),
                               'top_down' => _("Fill gaps from top down")
                            ),
         'refresh'       => SMOPT_REFRESH_NONE,
      );
   }


   if (!empty($my_optpage_values))
   {
      $optpage_data['grps']['select_range'] = _("Select Range");
      $optpage_data['vals']['select_range'] = $my_optpage_values;
   }

   sq_change_text_domain('squirrelmail');

}



/**
  * Insert JavaScript tag in <head> of needed pages
  *
  * @param array   $hook_arguments The array of hook arguments
  *                                passed from the core - only
  *                                used in 1.5.2+
  *
  */
function select_range_insert_script_tag_do($hook_arguments)
{

   global $javascript_on, $PHP_SELF;


   // bail if no javascript support
   //
   if (!$javascript_on) return;


   // bail if on search page - TODO/FIXME: add support for search page
   // (note that PAGE_NAME support was added in SM 1.4.11)
   //
   if ((check_sm_version(1, 4, 11) && PAGE_NAME == 'search')
    || (!check_sm_version(1, 4, 11) && strpos($PHP_SELF, '/src/search.php') !== FALSE))
      return;


   $script_tag_pre = '<script language="JavaScript" type="text/javascript" src="' . sqm_baseuri() . 'plugins/select_range/js/';
   $script_tag_post = '"></script>';


   // when in mailbox view, insert script tag
   //
   if ((check_sm_version(1, 4, 11) && PAGE_NAME == 'right_main')
    || (!check_sm_version(1, 4, 11) && strpos($PHP_SELF, '/src/right_main.php') !== FALSE))
   {

      if (check_sm_version(1, 5, 2))
      {
         $hook_arguments[0] .= $script_tag_pre . 'select_range_1_5_mailbox.js' . $script_tag_post;
      }
      else
      {
         echo $script_tag_pre . 'select_range_generic.js' . $script_tag_post;
      }

   }


   // when in address book view, insert two script tags
   //
   if ((check_sm_version(1, 4, 11) && PAGE_NAME == 'addressbook')
    || (!check_sm_version(1, 4, 11) && strpos($PHP_SELF, '/src/addressbook.php') !== FALSE))
   {

      if (check_sm_version(1, 5, 2))
      {
         $hook_arguments[0] .= $script_tag_pre . 'select_range_generic.js' . $script_tag_post;
      }
      else
      {
         echo $script_tag_pre . 'select_range_abook.js' . $script_tag_post
            . $script_tag_pre . 'select_range_generic.js' . $script_tag_post;
      }

   }

}



/**
  * Determine if the "Select Range" link is to be displayed
  * based on the number of items in the current list and
  * user/admin "threshold" settings.
  *
  * @param integer $count The number of items in the list to
  *                       which the link applies (OPTIONAL;
  *                       defaults to zero items).
  *
  * @return boolean TRUE if the link should be displayed, FALSE if not
  *
  */
function select_range_display_test($count=0)
{

   global $select_range_display_threshold, $data_dir, $username,
          $select_range_display_threshold_allow_override;

   select_range_init();


   if ($select_range_display_threshold_allow_override)
      $select_range_display_threshold = getPref($data_dir, $username,
                                                'select_range_threshold',
                                                $select_range_display_threshold);


   // -1 means never show the link
   //
   if ($select_range_display_threshold == -1)
      return FALSE;


   return ($count >= $select_range_display_threshold);

}



/**
  * Display "Select Range" link on various pages
  *
  * @param array   $hook_arguments The array of hook arguments
  *                                passed from the core - only
  *                                used in 1.5.2+
  *
  */
function select_range_generate_link($hook_arguments)
{

   global $javascript_on, $PHP_SELF, $select_range_fill_type,
          $select_range_fill_type_allow_override, $mailbox,
          $select_range_display_errors, $data_dir, $username,
          $select_range_display_errors_allow_override;
   static $display_link = NULL;


   // bail if no javascript support
   //
   if (!$javascript_on) return;


   select_range_init();


   // bail if on search page - TODO/FIXME: add support for search page
   // (note that PAGE_NAME support was added in SM 1.4.11)
   //
   if ((check_sm_version(1, 4, 11) && PAGE_NAME == 'search')
    || (!check_sm_version(1, 4, 11) && strpos($PHP_SELF, '/src/search.php') !== FALSE))
      return;


   // when in mailbox view, figure out how many messages are
   // in current mailbox and based on that determine if the
   // "Select Range" link should be shown
   //
   if ((check_sm_version(1, 4, 11) && PAGE_NAME == 'right_main')
    || (!check_sm_version(1, 4, 11) && strpos($PHP_SELF, '/src/right_main.php') !== FALSE))
   {
      
      // we only want to do this once...
      //
      if (is_null($display_link))
      {

         // get page request information about
         // how many messages to show, etc.
         //
         if (!sqgetGlobalVar('PG_SHOWNUM', $SHOWNUM))
            $SHOWNUM = 0;
         if (!sqgetGlobalVar('PG_SHOWALL', $show_all_1_4_x))
            $show_all_1_4_x = 0;
         if (!sqgetGlobalVar('showall', $show_all_1_5_x))
            $show_all_1_5_x = 0;
         if (check_sm_version(1, 5, 2))
         {
            $template = $hook_arguments[1];

            // $template is not a tempate object when folder is empty
            //
            if (!is_object($template)) return;

            $total_message_count = $template->get_template_vars('iNumberOfMessages');
         }
         else
         {
            global $numMessages;
            if (!empty($numMessages))
               $total_message_count = $numMessages;
         }
         if (!isset($total_message_count) || is_null($total_message_count))
         {
            global $imapConnection, $username, $key, $imapServerAddress,
                   $imapPort;
            if (check_sm_version(1, 5, 2)) $key = FALSE;
            if (!is_resource($imapConnection))
               $imapConnection = sqimap_login($username, $key, $imapServerAddress,
                                              $imapPort, 0);
            $total_message_count = sqimap_get_num_messages($imapConnection, $mailbox);
         }


         // figure out how many messages are on the current page
         //
         if (!empty($show_all_1_4_x) || !empty($show_all_1_5_x))
            $message_count = $total_message_count;
         else
         {
            global $startMessage;
            if (!empty($SHOWNUM))
               $message_count = $SHOWNUM;
            else
               $message_count = getPref($data_dir, $username, 'show_num', 15);
      
            if ($message_count > $total_message_count - $startMessage + 1)
               $message_count = $total_message_count - $startMessage + 1;
         }


         // finally, we can determine if the link gets shown
         //
         $display_link = select_range_display_test($message_count);
//debug
//echo "TOTAL MESSAGE COUNT: $total_message_count<hr />PAGE MESSAGE COUNT: $message_count<hr />SHOW LINK? $display_link<hr />";

      }


      // now print out link if needed
      //
      $hook_name = get_current_hook_name($hook_arguments);
      if ($select_range_fill_type_allow_override)
         $select_range_fill_type = getPref($data_dir, $username,
                                           'select_range_multiple_gaps',
                                           $select_range_fill_type);
      if ($select_range_display_errors_allow_override)
         $select_range_display_errors = getPref($data_dir, $username,
                                                'select_range_display_errors',
                                                $select_range_display_errors);


      // 1.5.x
      //
      if (check_sm_version(1, 5, 2))
      {

         // this hook not used in 1.5.x
         //
         if ($hook_name == 'right_main_bottom')
            return;


         // get link output
         //
         $safe_name = preg_replace("/[^0-9A-Za-z_]/", '_', $mailbox);
         sq_change_text_domain('select_range');
         global $oTemplate, $fancy_index_highlite;

         // if no link needed, don't build it
         //
         if (!$display_link)
            $link_output = '';
         else
         {

/* we'll use create_hyperlink() instead so template authors have one less template to worry about ---------------------------
            $oTemplate->assign('link_text', _("Select Range"));
            $oTemplate->assign('fill_type', $select_range_fill_type);
            $oTemplate->assign('form_name', 'FormMsgs' . $safe_name);
            $oTemplate->assign('show_errors', $select_range_display_errors);
            $oTemplate->assign('at_least_one_item_between_text', _("Please leave at least one un-selected message between the first and last selected messages"));
            $oTemplate->assign('at_least_two_items_selected_text', _("Please select at least two messages"));
            $link_output = $oTemplate->fetch('plugins/select_range/select_range_link.tpl');
-------------------- */
            if ($select_range_display_errors) $hide_errors = 'false';
            else $hide_errors = 'true';
            $link_output = create_hyperlink('#', _("Select Range"), '',
                                            'selectRange(\'FormMsgs' . $safe_name . '\', '
                                          . $hide_errors . ', \''
                                          . $select_range_fill_type . '\', \''
                                          . _("Please leave at least one un-selected message between the first and last selected messages")
                                          . '\', \''
                                          . _("Please select at least two messages")
                                          . '\', ' . ($fancy_index_highlite ? 'true' : 'false')
                                          . '); return false;');


            // put link in formatting
            //
            $oTemplate->assign('link', $link_output, FALSE);
            $link_output = $oTemplate->fetch('plugins/select_range/select_range_link_mailbox_display_formatting.tpl');

         }
         sq_change_text_domain('squirrelmail');


         // add shift-click support on "fancy" highlighting rows
         //
         if ($fancy_index_highlite)
            $ret['row_click_extra'] = 'doSelect(checkboxRealName, event, formName, \\\''
                                    . $select_range_fill_type . '\\\', \\\''
                                    . _("Please leave at least one un-selected message between the first and last selected messages") . '\\\', \\\''
                                    . _("Please select at least two messages") . '\\\', true);';
         else
            $ret['checkbox_javascript_onclick'] = 'doSelect(this.name, event, \'FormMsgs'
                                                . $safe_name . '\', \''
                                                . $select_range_fill_type . '\', \''
                                                . _("Please leave at least one un-selected message between the first and last selected messages") . '\', \''
                                                . ("Please select at least two messages")
                                                . '\', false);';


         // return results
         //
         $ret['mailbox_paginator_after'] = $link_output;
         return $ret;

      }


      // 1.4.x
      //
      else
      {

         // if no link needed, bail
         //
         if (!$display_link) return;


         // determine if we can show link in a nicer place
         // by detecting if our patch was applied
         //
         static $mailbox_display_is_patched = NULL;
         if (is_null($mailbox_display_is_patched))
         {
            $mailbox_display = file(SM_PATH . 'functions/mailbox_display.php');
            $mailbox_display = implode('', $mailbox_display);
            if (strpos($mailbox_display, 'mailbox_selectall_after') !== FALSE)
               $mailbox_display_is_patched = TRUE;
            else
               $mailbox_display_is_patched = FALSE;
         }


         // prepare to get output
         //
         global $t;
         sq_change_text_domain('select_range');
         $safe_name = preg_replace("/[^0-9A-Za-z_]/", '_', $mailbox);
         $t = array('link_text' => _("Select Range"),
                    'fill_type' => $select_range_fill_type,
                    'show_errors' => $select_range_display_errors,
                    'at_least_one_item_between_text' => _("Please leave at least one un-selected message between the first and last selected messages"),
                    'at_least_two_items_selected_text' => _("Please select at least two messages"),
                    'form_name' => 'FormMsgs' . $safe_name);
         sq_change_text_domain('squirrelmail');


         // unpatched, uglier location
         //
         if (!$mailbox_display_is_patched)
         {

            // top of unpatched message list page
            // bottom of unpatched message list page
            //
            include(SM_PATH . 'plugins/select_range/templates/default/select_range_link.tpl');
            return;

         }


         // patched, nicer location - only use with mailbox_selectall_after hook
         //
         else if ($hook_name == 'mailbox_selectall_after')
         {
            ob_start();
            include(SM_PATH . 'plugins/select_range/templates/default/select_range_link.tpl');
            $link = ob_get_contents();
            ob_end_clean();
            return '|&nbsp;' . $link;
         }

      }
      
   }



   // when in address book (only 1.5.2+), figure out how many addresses
   // are in current list and based on that determine if the "Select Range"
   // link should be shown
   //
   else if (check_sm_version(1, 5, 2) && PAGE_NAME == 'addressbook')
   {

      global $addresses, $current_backend, $oTemplate;

      if ($select_range_fill_type_allow_override)
         $select_range_fill_type = getPref($data_dir, $username,
                                           'select_range_multiple_gaps',
                                           $select_range_fill_type);
      if ($select_range_display_errors_allow_override)
         $select_range_display_errors = getPref($data_dir, $username,
                                                'select_range_display_errors',
                                                $select_range_display_errors);


      // put link in formatting
      //
      $links = build_abook_links(sizeof($addresses[$current_backend]['Addresses']));
      if (empty($links[1]))
         $link_output = '';
      else
      {
         $oTemplate->assign('link', $links[1], FALSE);
         $link_output = $oTemplate->fetch('plugins/select_range/select_range_link_abook_display_formatting.tpl');
      }
      $ret['address_book_navigation'] = $link_output;


      // add shift-click support on "fancy" highlighting rows
      //
      sq_change_text_domain('select_range');
      $ret['address_book_checkbox_extra'] = ' onclick="doSelect(this.name, event, \'address_book_form\', \''
                                          . $select_range_fill_type . '\', \''
                                          . _("Please leave at least one un-selected address between the first and last selected addresses") . '\', \''
                                          . ("Please select at least two addresses")
                                          . '\');" ';
      sq_change_text_domain('squirrelmail');


      // return results
      //
      return $ret;

   }



   // TODO: any other pages?
   //
   else
      $display_link = FALSE;

}



/**
  * Add shift-click ability to checkboxes
  * (patched-in functionality)
  *
  * @param string $element_name The name attribute of the checkbox
  *
  */
function select_range_do_checkbox_params($element_name)
{

   // 1.5.2+ does not use this (also exit if no JavaScript support)
   //
   global $javascript_on;
   if (check_sm_version(1, 5, 2) || !$javascript_on) return;


   global $mailbox, $select_range_fill_type_allow_override,
          $select_range_fill_type, $data_dir, $username;

   select_range_init();

   $safe_name = preg_replace("/[^0-9A-Za-z_]/", '_', $mailbox);

   if ($select_range_fill_type_allow_override)
   {
      $select_range_fill_type = getPref($data_dir, $username,
                                        'select_range_multiple_gaps',
                                        $select_range_fill_type);
   }


   // when in mailbox view, go ahead
   //
   if ((check_sm_version(1, 4, 11) && PAGE_NAME == 'right_main')
    || (!check_sm_version(1, 4, 11) && strpos($PHP_SELF, '/src/right_main.php') !== FALSE))
   {
      sq_change_text_domain('select_range');
      $at_least_one_item_between_text = _("Please leave at least one un-selected message between the first and last selected messages");
      $at_least_two_items_selected_text = _("Please select at least two messages");
      sq_change_text_domain('squirrelmail');

      // could use "this.name" instead of $element_name, same thing in the end
      return ' onclick="doSelect(\'' . $element_name . '\', event, \'FormMsgs'
           . $safe_name . '\', \'' . $select_range_fill_type . '\', \''
           . $at_least_one_item_between_text
           . '\', \'' . $at_least_two_items_selected_text . '\');" ';
   }


   // when in address book, go ahead
   //
   if ((check_sm_version(1, 4, 11) && PAGE_NAME == 'addressbook')
    || (!check_sm_version(1, 4, 11) && strpos($PHP_SELF, '/src/addressbook.php') !== FALSE))
   {
      sq_change_text_domain('select_range');
      $at_least_one_item_between_text = _("Please leave at least one un-selected address between the first and last selected addresses");
      $at_least_two_items_selected_text = _("Please select at least two addresses");
      sq_change_text_domain('squirrelmail');

      // could use $element_name instead of "this.name", same thing in the end
      return ' onclick="doSelect(this.name, event, \'address_book_form\', \''
           . $select_range_fill_type . '\', \''
           . $at_least_one_item_between_text . '\', \''
           . $at_least_two_items_selected_text . '\');" ';
   }

}



/**
  * Generates "Toggle All" and "Select Range" links for the
  * address book page
  *
  * @param int $element_count The number of elements on the current page
  *
  * @return array The two links, one in each array element
  *               (first the "Toggle All" link, then the
  *               "Select Range" link).  If either link is
  *               not to be shown, the corresponding array
  *               element will contain an empty string.
  *
  */
function build_abook_links($element_count)
{

   global $data_dir, $username, $javascript_on,
          $select_range_abook_toggle_all,
          $select_range_abook_toggle_all_allow_override,
          $select_range_abook_select_range,
          $select_range_abook_select_range_allow_override;

   $ret = array('', '');

   // bail if no javascript support
   //
   if (!$javascript_on) return $ret;

   select_range_init();

   if ($select_range_abook_toggle_all_allow_override)
      $select_range_abook_toggle_all = getPref($data_dir, $username,
                                               'select_range_abook_toggle_all',
                                               $select_range_abook_toggle_all);
   
   if ($select_range_abook_select_range_allow_override)
      $select_range_abook_select_range = getPref($data_dir, $username,
                                                 'select_range_abook_select_range',
                                                 $select_range_abook_select_range);



   // Toggle All link
   //
   sq_change_text_domain('select_range');
   if ($select_range_abook_toggle_all)
      if (check_sm_version(1, 5, 2))
      {
         // 1.5.2+ already has a toggle all checkbox
         //
         //$ret[0] = create_hyperlink('#', _("Toggle All"), '',
         //                           'CheckAllAddrs(); return false;');
      }
      else
         $ret[0] = '<a href="#" onclick="CheckAllAddrs(); return false;">' . _("Toggle All") . '</a>';
   sq_change_text_domain('squirrelmail');


   // Select Range link
   //
   if ($select_range_abook_select_range)
   {

      // do we even need to show the link?
      //
      global $address_book_form_count;
      if (!select_range_display_test($element_count)) return $ret;

      sq_change_text_domain('select_range');

      global $select_range_fill_type,
             $select_range_fill_type_allow_override,
             $select_range_display_errors,
             $select_range_display_errors_allow_override;

      if ($select_range_fill_type_allow_override)
         $select_range_fill_type = getPref($data_dir, $username,
                                           'select_range_multiple_gaps',
                                           $select_range_fill_type);
      if ($select_range_display_errors_allow_override)
         $select_range_display_errors = getPref($data_dir, $username,
                                                'select_range_display_errors',
                                                $select_range_display_errors);

      if ($select_range_display_errors) $hide_errors = 'false';
      else $hide_errors = 'true';
      if (check_sm_version(1, 5, 2))
         $ret[1] = create_hyperlink('#', _("Select Range"), '',
                                    'selectRange(\'address_book_form\', ' . $hide_errors . ', \'' . $select_range_fill_type . '\', \'' . _("Please leave at least one un-selected address between the first and last selected addresses"). '\', \'' . _("Please select at least two addresses") . '\'); return false;');
      else
         $ret[1] = '<a href="#" onclick="selectRange(\'address_book_form\', ' . $hide_errors . ', \'' . $select_range_fill_type . '\', \'' . _("Please leave at least one un-selected address between the first and last selected addresses"). '\', \'' . _("Please select at least two addresses") . '\'); return false;">' . _("Select Range") . '</a>';

      sq_change_text_domain('squirrelmail');

   }

   return $ret;

}



/**
  * Display "Select Range" and "Toggle All" links on address book page
  *
  */
function select_range_do_abook()
{

   // abook_group_pagination will add links for us if it is enabled
   //
   if (is_plugin_enabled('abook_group_pagination'))
   {
      return;
   }


   // create links
   //
   global $alist, $color;
   $output = '';
   $links = build_abook_links(sizeof($alist));
   if (!empty($links)) foreach ($links as $link)
      if (!empty($link))
         $output .= (empty($output) ? '' : '|&nbsp;') . $link . '&nbsp;';
   $output = html_tag('td', $output, 'left', $color[0], 'colspan="2"');
   return $output;

}



