<?php

/**
 * setup.php
 *
 * Copyright (c) 1999-2003 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * $Id: $
 */

//you can set this to whatever the default threshold/minimum should be
define( 'select_range_default_min', 4 );

if (!defined('SM_PATH')){
    define('SM_PATH','../../');
}

/**
 * determine if select range link has to be displayed
 * @param integer $count number of items
 * @return boolean
 */
function select_range_display_test( $count ){
    global $select_range_display_link, $select_range_display_errors;
    global $select_range_messages_threshold;

    //if no conditions are matched, we'll return true to show the link
    if( $select_range_display_link == 'never' ){
        return false;
    } else if( $select_range_display_link == 'always' ){
        return true;
    } else if( $select_range_display_link == 'threshold' ){
        //if $count can't be determined, we'll return true to show the link
        if( !isset( $count ) ){
            return true;
        } else if( $count >= $select_range_messages_threshold ){
            return true;
        } else {
            return false;
        }
    } else {
        return true;
    }
}

function select_range_do_abook(){
    global $javascript_on;
    global $select_range_display_errors;
    global $select_range_abook;

    if( $javascript_on ){
        // this should be set from the parent addressbook.php function
        global $alist;
     
        // see whether we should use extra links in address book
        $select_range_abook = 1;

        select_range_get_prefs();

        if( isset( $alist ) && is_array( $alist ) && $select_range_abook ){

            //globally tell this function that the hook to call select_range exists
            //if( $link_only ){
            //    $select_range_hook = 1;
            //}
    
            $function_bit = 'Abook';
            $abook_func = 'FormAddrs' . $function_bit;
            $result = select_range_jscript_function( $function_bit, $select_range_display_errors, 'abook' );

            if( select_range_display_test( count( $alist ) ) ) {
                // might as well add a "toggle all" link while we're at it
                $result .= <<<EOF
<script language="JavaScript" type="text/javascript">
<!--
function CheckAllAddrs() {
  for (var i = 0; i < document.$abook_func.elements.length; i++) {
    if(document.$abook_func.elements[i].type == 'checkbox'){
      document.$abook_func.elements[i].checked = 
        !(document.$abook_func.elements[i].checked);
    }
  }
}
//-->
</script>
EOF;
		          $result .= 
                    html_tag( 
                        'p', 
                        '<a href="javascript:void(0)" onClick="CheckAllAddrs();">' . 
                            _( "Toggle All" ) .
                            '</a>' .
                            '&nbsp;&nbsp;' .
                            select_range_link( 'SelectRange' . $function_bit ), 
                        'center' 
                    ) . 
                    "\n";

            }
            echo $result;
        }
    }
}

function select_range_do_options(){
    global $optpage_data, $data_dir, $username;

    include_once( SM_PATH . 'functions/i18n.php' );

    bindtextdomain( 'select_range', SM_PATH . 'plugins/select_range/locale' );
    textdomain( 'select_range' );

    $optionValues = array();
    $showed_option = false;

    if( file_exists( SM_PATH . 'plugins/select_range/config.php' ) ){
        include_once( SM_PATH . 'plugins/select_range/config.php' );
    }

    if( 
        !isset( $select_range_display_link ) && 
        !isset( $select_range_messages_threshold ) 
    ){
        $initial_threshold = 
           getPref($data_dir, $username, 'select_range_threshold', select_range_default_min );
        if( $initial_threshold === '0' ){
            $initial_threshold = ' 0';
        }
        $optionValues[] = array(
            'name' => 'select_range_threshold',
            'caption' => _("Number of list items before showing link"),
            'type' => SMOPT_TYPE_INTEGER,
            'initial_value' => $initial_threshold,
            'size' => SMOPT_SIZE_TINY,
            'save' => 'select_range_validate_threshold',
            'refresh' => 0
        );

        $optionValues[] = array(
            'name' => 'select_range_display_link',
            'caption' => _("Show link never or always?"),
            'type' => SMOPT_TYPE_STRLIST,
            'initial_value' => 
                getPref($data_dir, $username, 'select_range_display_link', 'threshold' ),
            'posvals' => 
                array( 
                    'threshold' => _("Obey previous configuration option"),
                    'always' => _("Always"),
                    'never' => _("Never")
                ),
            'refresh' => 0
        );

        $showed_option = true;
    }

    if( !isset( $select_range_display_errors ) ){
        $optionValues[] = array(
            'name' => 'select_range_display_errors',
            'caption' => _("If errors, show popup window"),
            'type' => SMOPT_TYPE_BOOLEAN,
            'initial_value' => 
                getPref( $data_dir, $username, 'select_range_display_errors', true ),
            'refresh' => 0
        );
        $showed_option = true;
    }

    if( $showed_option ){
        $optpage_data['vals']['select_range'] = $optionValues;
        $optpage_data['grps']['select_range'] = _("Select Range Options");
    }

    bindtextdomain( 'squirrelmail', SM_PATH . 'locale' );
    textdomain( 'squirrelmail' );
}

function select_range_do_print( $link_only = 0, $prefix = '' ){
    global $javascript_on;
    global $select_range_display_link, $select_range_display_errors;
    global $select_range_messages_threshold, $select_range_prefix;
    sqgetGlobalVar( 'SCRIPT_NAME', $script_name, SQ_SERVER );

    // kludgey attempt to disable this link on the search page
    // this should *really* be done a different way!
    if( $javascript_on && ( substr( $script_name, -15 ) != '/src/search.php' ) ){
        global $numMessages, $startMessage, $PG_SHOWALL, $data_dir, $username;
        global $select_range_hook;

        // globally tell this function that the hook to call select_range exists
        if( $link_only ){
            $select_range_hook = 1;
        }
 
        select_range_get_prefs();
    
        //allow $select_range_prefix to be overridden
        if( !isset( $select_range_prefix ) ){
            $select_range_prefix = $prefix;
        }

        // figure out how many messages are on the current page
        unset( $message_count );
        if( isset( $PG_SHOWALL ) && $PG_SHOWALL ){
            $message_count = $numMessages;
        } else if( isset( $numMessages ) && isset( $startMessage ) ){
            // I'd love to use $PG_SHOWNUM here, but apparently it isn't set yet
            $show_num = getPref($data_dir, $username, 'show_num', 15 );
            $message_count = (int) $show_num;
            if( $message_count > $numMessages - $startMessage + 1 ){
                $message_count = $numMessages - $startMessage + 1;
            }
        }

        $display_link = select_range_display_test($message_count);
        global $mailbox;
        $safe_name = preg_replace("/[^0-9A-Za-z_]/", '_', $mailbox);
        $func_name = "SelectRange" . $safe_name;
        $result = '';

        if( $link_only ){
            if( $display_link ){
                $result .= $select_range_prefix . select_range_link( $func_name );
                return( $result );
            }
            
        } else {
            // keep track of whether we already printed this function
            // so we don't print it more than once
            global $select_range_already_printed_jscript;
    
            if( ! isset( $select_range_already_printed_jscript ) ){
                $result .= 
                    select_range_jscript_function( 
                        $safe_name,
                        $select_range_display_errors
                    );
            }
    
            if( $display_link && !isset( $select_range_hook ) ){
                // need to put the link in a table so css rules are followed
                $result .= "\n<table>\n"
                    . "<tr><td>\n"
                    . select_range_link( $func_name )
                    . "\n"
                    . "</td></tr>\n"
                    . "</table>\n";
            }

            echo ( $result );
        }
    }
}

/**
 * get all user prefs related to plugin
 */
function select_range_get_prefs() {
    global $data_dir, $username;
    global $select_range_display_link, $select_range_display_errors;
    global $select_range_messages_threshold;
	 global $select_range_prefix, $select_range_abook;

    if( !isset( $select_range_display_link ) ){
        $select_range_display_link =
            getPref( $data_dir, $username, 'select_range_display_link', 'threshold' );
    }
    if( !isset( $select_range_messages_threshold ) ){
        $select_range_messages_threshold = 
            getPref( $data_dir, $username, 'select_range_threshold', select_range_default_min );
    }
    if( !isset( $select_range_display_errors ) ){
        $select_range_display_errors =
            getPref( $data_dir, $username, 'select_range_display_errors', true );
    }

    if( file_exists( SM_PATH . 'plugins/select_range/config.php' ) ){
        include_once( SM_PATH . 'plugins/select_range/config.php' );
    }
}

function select_range_jscript_function( $safe_name, $alerts = 1, $context = '' ){
    include_once( SM_PATH . 'functions/i18n.php' );

    global $select_range_already_printed_jscript;
    $func_name = "SelectRange" . $safe_name;

    bindtextdomain('select_range', SM_PATH . 'plugins/select_range/locale');
    textdomain('select_range');

    if( $context == 'abook' ){
        $form_name = "FormAddrs" . $safe_name;
    
        $at_least_one_item_between = _( "Please leave at least one un-selected address between the first and last selected addresses" );
        $at_least_two_items_selected = _( "Please select at least two addresses" );

    } else {
        $form_name = "FormMsgs" . $safe_name;
    
        $at_least_one_item_between = _( "Please leave at least one un-selected message between the first and last selected messages" );
        $at_least_two_items_selected = _( "Please select at least two messages" );
    }

    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
     
    $result = <<<EOF
<script language="JavaScript" type="text/javascript">
<!--
function doSelect(element, e){
  if( !e ) { 
    return; 
  }
  var shifted = 0;
  if( e.shiftKey || ( e.modifiers && ( e.modifiers & 4 ) ) ){ 
    shifted = 1;
  }
  if( shifted ){
    if( document.$form_name.elements[element].type == 'checkbox' ){
      document.$form_name.elements[element].checked = true;
    }
    $func_name( true );
  }
}

function $func_name( hide_alerts ) { 
  var display_alert = $alerts;
  if( hide_alerts ){
    display_alert = false;
  }
  var first_checked_message = -1;
  var last_checked_message = -1; 
  var unchecked_after_first = 0;
  var checked_after_unchecked = 0;
  for (var i = 0; i < document.$form_name.elements.length; i++) {
    if( document.$form_name.elements[i].type == 'checkbox' ) {
      if( document.$form_name.elements[i].checked ){
        if( first_checked_message == -1 ){
          first_checked_message = i;
        } else {
          last_checked_message = i;
        }
        if( unchecked_after_first != 0 ){
          checked_after_unchecked = 1;
        }
      } else {
        if( first_checked_message != -1 ){
          unchecked_after_first = 1;
        }
      }
    }
  }
  if( first_checked_message != -1 && last_checked_message != -1 ){
    if( checked_after_unchecked == 0 ){
      if( display_alert == 1 ){
        alert( "$at_least_one_item_between" );
      }
    } else {
      for (var i = first_checked_message; i < last_checked_message; i++) {
        if( document.$form_name.elements[i].type == 'checkbox' ) {
          document.$form_name.elements[i].checked = true;
        }
      }
    }
  } else {
    if( display_alert == 1 ){
      alert( "$at_least_two_items_selected" );
    }
  }
}
//-->
</script>

EOF;
    $select_range_already_printed_jscript = 1;
    return( $result );
}

function select_range_link( $func_name ){
    include_once( SM_PATH . 'functions/i18n.php' );

    bindtextdomain('select_range', SM_PATH . 'plugins/select_range/locale');
    textdomain('select_range');

    $return_val = "\n"
        . '<a href="javascript:void(0)" onClick="' 
        . $func_name 
        . '();">' 
        . _("Select Range")
        . "</a>\n";

    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');

    return( $return_val );
}

/**
 * make sure user passed an integer
 */
function select_range_validate_threshold( $option ){
    global $data_dir, $username;

    $thresh = $option->new_value;
    $matches = array();
    preg_match( '/^(\d*)$/', $thresh, $matches );
    if( isset( $matches[1] ) ){
        $thresh = $matches[1];
    } else {
        $thresh = select_range_default_min;
    }
	 $option->new_value = $thresh;
    save_option( $option );
}

/**
 * used for shift-click
 * if we are called, we return an "onclick" javascript param
 * which calls select range
 */
function select_range_do_checkbox_params($element_name,$always_show){
    if( $always_show ){
        return( " onclick=\"doSelect('$element_name',event);\" " );
    }
    else{
        // kludgey attempt to only add "onclick" to checkboxes on addressbook page
        // this should *really* be done a different way!
        sqgetGlobalVar( 'SCRIPT_NAME', $script_name, SQ_SERVER );
        if( substr( $script_name, -20 ) == '/src/addressbook.php' ){
            return( " onclick=\"doSelect('$element_name',event);\" " );
        }
        else{
            return( '' );
        }
    }
}

?>
